/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBondBillInveStorSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanentry");
        sic.add("drawamount");
        sic.add("investor_entry");
        sic.add("e_investamount");
        sic.add("e_investortype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateInveStorEntry(dataEntity);
        }
    }

    private void validateInveStorEntry(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        for (int i = 0; i < loanEntrys.size(); ++i) {
            BigDecimal investTotalAmt;
            HashSet<String> investSet = new HashSet<String>(4);
            BigDecimal amount = ((DynamicObject)loanEntrys.get(i)).getBigDecimal("drawamount");
            DynamicObjectCollection investEntrys = ((DynamicObject)loanEntrys.get(i)).getDynamicObjectCollection("investor_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)investEntrys) && (investTotalAmt = investEntrys.stream().map(o -> o.getBigDecimal("e_investamount")).reduce(BigDecimal::add).get()).compareTo(amount) > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u884c\u4fe1\u606f\u7684\u4e3b\u8981\u6295\u8d44\u4eba\u7684\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u884c\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusinessInfoSubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]), i + 1));
            }
            for (int k = 0; k < investEntrys.size(); ++k) {
                DynamicObject investEntry = (DynamicObject)investEntrys.get(k);
                String investType = investEntry.getString("e_investortype");
                String prop = CreditorTypeEnum.OTHER.getValue().equals(investType) ? "e_investorname" : "e_investorid";
                String key = investType + investEntry.get(prop);
                if (investSet.contains(key)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u53d1\u884c\u4fe1\u606f\u7684\u7b2c%2s\u884c\u6295\u8d44\u4eba\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusinessInfoSubmitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]), i + 1, k + 1));
                    continue;
                }
                investSet.add(key);
            }
        }
    }
}

