/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBondBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("repaymentway");
        sic.add("settleintmode");
        sic.add("basis");
        sic.add("stageplan");
        sic.add("interestsettledplan");
        sic.add("floatingratio");
        sic.add("islimitclause");
        sic.add("limitclauseexplain");
        sic.add("initstatus");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("interesttype");
        sic.add("interestrate");
        sic.add("isclientloan");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("interesttype");
        sic.add("rateadjuststyle");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("datasource");
        sic.add("rateadjustcycle");
        sic.add("renewalinteresttype");
        sic.add("loanentry");
        sic.add("creditamount");
        sic.add("creditlimit");
        sic.add("loanratesign");
        sic.add("loanratefloatpoint");
        sic.add("loanrateadjuststyle");
        sic.add("loanrate");
        sic.add("loan_contractno");
        sic.add("loan_contractname");
        sic.add("loan_shortname");
        sic.add("loan_referencerate");
        sic.add("publishprice");
        sic.add("ticketamt");
        sic.add("loan_interesttype");
        sic.add("loan_repaymentway");
        sic.add("loan_settleintmode");
        sic.add("loan_basis");
        sic.add("loan_stageplan");
        sic.add("loan_interestsettledplan");
        sic.add("loan_ratingagency");
        sic.add("loan_ratingscale");
        sic.add("loan_debtratingscale");
        sic.add("loan_custodianfinorg");
        sic.add("loan_underwritemethod");
        sic.add("loan_use");
        sic.add("payinterestamount");
        sic.add("repayamount");
        sic.add("endinstdate");
        sic.add("endpreinstdate");
        sic.add("loanrateadjuststyle");
        sic.add("feedetail");
        sic.add("feeoppunittype");
        sic.add("feeoppunit");
        sic.add("feeoppunittext");
        sic.add("loan_feedetail");
        sic.add("lfeeoppunittype");
        sic.add("lfeeoppunit");
        sic.add("lfeeoppunittext");
        sic.add("lfeeoppunittext");
        sic.add("e_underwritertype");
        sic.add("e_isbookrunner");
        sic.add("e_underwriter");
        sic.add("e_underwriteratio");
        sic.add("e_underwriteamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject initBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(initBill.getString("datasource"));
            this.validtateContractInfo(dataEntity, initBill, bizResource);
            this.validateLoanEntry(dataEntity, initBill, bizResource);
            this.validateUnderwriter(dataEntity, initBill);
            this.validateFeeInfo(dataEntity, initBill, bizResource);
            this.validateGuaranteeEntry(dataEntity);
        }
    }

    private void validtateContractInfo(ExtendedDataEntity dataEntity, DynamicObject initBill, AbstractBizResource bizResource) {
        int diffDays;
        if (TmcDataServiceHelper.isFromDatabase((ExtendedDataEntity)dataEntity)) {
            Long pkId = (Long)initBill.getPkValue();
            DynamicObject initDb = TmcDataServiceHelper.loadSingle((Object)pkId, (String)"cfm_initbill", (String)"initstatus");
            String initStatus = initDb.getString("initstatus");
            if (InitStatusEnum.INITED.getValue().equals(initStatus)) {
                this.addErrorMessage(dataEntity, bizResource.getInbSaveInited());
                return;
            }
        }
        Date startDate = initBill.getDate("startdate");
        Date endDate = initBill.getDate("enddate");
        if (startDate == null) {
            this.addErrorMessage(dataEntity, bizResource.getInbStartdateNotNull());
        }
        if (endDate == null) {
            this.addErrorMessage(dataEntity, bizResource.getInbEnddateNotNull());
        }
        if (startDate != null && endDate != null && (diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate)) <= 1) {
            this.addErrorMessage(dataEntity, bizResource.getCbEnddateMin());
        }
    }

    private void validateUnderwriter(ExtendedDataEntity dataEntity, DynamicObject info) {
        DynamicObjectCollection loanEntrys = info.getDynamicObjectCollection("loanentry");
        for (int pi = 0; pi < loanEntrys.size(); ++pi) {
            DynamicObject loanEntry = (DynamicObject)loanEntrys.get(pi);
            DynamicObjectCollection underwriterEntrys = loanEntry.getDynamicObjectCollection("underwriter_entry");
            for (int i = 0; i < underwriterEntrys.size(); ++i) {
                long isbookrunnerCount = underwriterEntrys.stream().filter(v -> v.getBoolean("e_isbookrunner")).count();
                if (isbookrunnerCount > 1L) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u53d1\u884c\u4fe1\u606f\u7684\u627f\u9500\u4fe1\u606f\u4e2d,\u7c3f\u8bb0\u7ba1\u7406\u4eba\u53ea\u80fd\u6709\u4e00\u4e2a\u3002", (String)"InitBondBillSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), pi + 1));
                }
                BigDecimal drawAmount = loanEntry.getBigDecimal("drawamount");
                BigDecimal uwAmtSum = BigDecimal.ZERO;
                BigDecimal uwRatioSum = BigDecimal.ZERO;
                for (DynamicObject underwriterEntry : underwriterEntrys) {
                    DynamicObject underwriter = underwriterEntry.getDynamicObject("e_underwriter");
                    if (EmptyUtil.isEmpty((DynamicObject)underwriter)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u53d1\u884c\u4fe1\u606f\u7684\u627f\u9500\u4fe1\u606f\u4e2d,\u627f\u9500\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitBondBillSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]), pi + 1));
                    }
                    BigDecimal uwRatio = underwriterEntry.getBigDecimal("e_underwriteratio");
                    BigDecimal uwAmount = underwriterEntry.getBigDecimal("e_underwriteamount");
                    if (BigDecimal.ZERO.compareTo(uwAmount) > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u53d1\u884c\u4fe1\u606f\u7684\u627f\u9500\u4fe1\u606f\u4e2d,\u627f\u9500\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"InitBondBillSaveValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]), pi + 1));
                    }
                    if (BigDecimal.ZERO.compareTo(uwRatio) > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u53d1\u884c\u4fe1\u606f\u7684\u627f\u9500\u4fe1\u606f\u4e2d,\u627f\u9500\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"InitBondBillSaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]), pi + 1));
                    }
                    uwAmtSum = uwAmtSum.add(uwAmount);
                    uwRatioSum = uwRatioSum.add(uwRatio);
                }
                if (BigDecimal.valueOf(100L).compareTo(uwRatioSum) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u53d1\u884c\u4fe1\u606f\u7684\u627f\u9500\u4fe1\u606f\u4e2d,\u627f\u9500\u603b\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e100%%\u3002", (String)"InitBondBillSaveValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]), pi + 1));
                }
                if (drawAmount.compareTo(uwAmtSum) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u53d1\u884c\u4fe1\u606f\u7684\u627f\u9500\u4fe1\u606f\u4e2d,\u627f\u9500\u603b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u91d1\u989d\u3002", (String)"InitBondBillSaveValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]), pi + 1));
            }
        }
    }

    private void validateFeeInfo(ExtendedDataEntity dataEntity, DynamicObject info, AbstractBizResource bizResource) {
        MainEntityType tagEntityType = MetadataServiceHelper.getDataEntityType((String)info.getDataEntityType().getName());
        DynamicObject mainOrg = info.getDynamicObject(tagEntityType.getMainOrg());
        DynamicObjectCollection contractFeeDetailEntrys = info.getDynamicObjectCollection("feedetail");
        String feeBillType = ResManager.loadKDString((String)"\u5408\u540c", (String)"BusinessInfoSaveValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]);
        String loanType = info.getString("loantype");
        if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
            feeBillType = ResManager.loadKDString((String)"\u53d1\u884c\u8ba1\u5212", (String)"InitBillSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]);
        }
        for (int i = 0; i < contractFeeDetailEntrys.size(); ++i) {
            DynamicObject feeEntry = (DynamicObject)contractFeeDetailEntrys.get(i);
            String oppType = feeEntry.getString("feeoppunittype");
            String oppName = feeEntry.getString("feeoppunittext");
            this.volidateOppUnitInfo(dataEntity, mainOrg, feeBillType, i, oppType, oppName);
        }
        DynamicObjectCollection loanEntrys = info.getDynamicObjectCollection("loanentry");
        for (DynamicObject loanEntry : loanEntrys) {
            DynamicObjectCollection loanFeeDetailEntrys = loanEntry.getDynamicObjectCollection("loan_feedetail");
            for (int i = 0; i < loanFeeDetailEntrys.size(); ++i) {
                DynamicObject feeEntry = (DynamicObject)loanFeeDetailEntrys.get(i);
                String oppType = feeEntry.getString("lfeeoppunittype");
                String oppName = feeEntry.getString("lfeeoppunittext");
                feeBillType = ResManager.loadKDString((String)"\u63d0\u6b3e", (String)"InitBillSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]);
                if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
                    feeBillType = ResManager.loadKDString((String)"\u53d1\u884c", (String)"BusinessInfoSaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]);
                }
                this.volidateOppUnitInfo(dataEntity, mainOrg, feeBillType, i, oppType, oppName);
            }
        }
    }

    private void volidateOppUnitInfo(ExtendedDataEntity dataEntity, DynamicObject mainOrg, String feeBillType, int i, String oppType, String oppName) {
        if (EmptyUtil.isNoEmpty((String)oppType) && EmptyUtil.isNoEmpty((String)oppName) && !OppUnitTypeEnum.OTHER.getValue().equals(oppType)) {
            QFilter existFilter = new QFilter("name", "=", (Object)oppName);
            if (OppUnitTypeEnum.SUPPLIER.getValue().equals(oppType) || OppUnitTypeEnum.CUSTOMER.getValue().equals(oppType)) {
                existFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)oppType, (Long)mainOrg.getLong("id")));
            }
            if (!TmcDataServiceHelper.exists((String)oppType, (QFilter[])existFilter.toArray())) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s \u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%2$s\u3011\u884c\u5bf9\u65b9\u5355\u4f4d\u7c7b\u578b\u548c\u5bf9\u65b9\u5355\u4f4d\u503c\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u70b9\u51fb\u5bf9\u65b9\u5355\u4f4d\u9009\u62e9\u3002", (String)"InitBondBillSaveValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]), feeBillType, i + 1));
            }
        }
    }

    private void validateLoanEntry(ExtendedDataEntity dataEntity, DynamicObject initBill, AbstractBizResource bizResource) {
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys)) {
            this.addErrorMessage(dataEntity, bizResource.getInbEndLoanNotNull());
            return;
        }
        BigDecimal loanTotalAmt = BigDecimal.ZERO;
        for (int i = 0; i < loanEntrys.size(); ++i) {
            Date endPreInstDate;
            BigDecimal loanRate;
            DynamicObject loanEntry = (DynamicObject)loanEntrys.get(i);
            String interestType = loanEntry.getString("loan_interesttype");
            if ((InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) && null != (loanRate = loanEntry.getBigDecimal("loanrate")) && loanRate.compareTo(BigDecimal.ZERO) == 0) {
                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u53d1\u884c\u4fe1\u606f\u201d\u7b2c%s\u884c\u5229\u7387\u4e3a0\u3002", (String)"InitBondBillSaveValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]), i + 1));
            }
            if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
                if (EmptyUtil.isEmpty((String)loanEntry.getString("loanrateadjuststyle"))) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInitRateAdjustStyleNotNull(), i + 1));
                }
                if (EmptyUtil.isEmpty((DynamicObject)loanEntry.getDynamicObject("loan_referencerate"))) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInitReferenceRateNotNull(), i + 1));
                }
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(loanEntry.getString("loanrateadjuststyle"))) {
                    Date rateAdjustDate = loanEntry.getDate("loanrateadjustdate");
                    if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
                        this.addErrorMessage(dataEntity, String.format(bizResource.getInitRateadjustDateNotNull(), i + 1));
                    } else {
                        Date endDate = loanEntry.getDate("expiredate");
                        if (rateAdjustDate.compareTo(endDate) >= 0) {
                            this.addErrorMessage(dataEntity, bizResource.getLoanRateadjustDateRange());
                        }
                        if (EmptyUtil.isEmpty((Object)loanEntry.get("loanrateadjusttype"))) {
                            this.addErrorMessage(dataEntity, bizResource.getLoanRateAdjustCycleTypeNotNull());
                        }
                        if (EmptyUtil.isEmpty((Object)loanEntry.get("loanrateadjustcycle"))) {
                            this.addErrorMessage(dataEntity, bizResource.getLoanRateAdjustCycleNotNull());
                        }
                    }
                }
            }
            Date loadDate = loanEntry.getDate("loaddate");
            Date receiveDate = loanEntry.getDate("receivedate");
            Date startInstDate = loanEntry.getDate("startinstdate");
            Date expireDate = loanEntry.getDate("expiredate");
            BigDecimal publishPrice = loanEntry.getBigDecimal("publishprice");
            if (EmptyUtil.isEmpty((BigDecimal)publishPrice)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInterestPublishPriceNotNull(), loanEntry.getInt("seq")));
            }
            if (loadDate != null && startInstDate != null && startInstDate.before(loadDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbStartdateCheck(), loanEntry.getInt("seq")));
            }
            if (loadDate != null && receiveDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)receiveDate) < 1) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbReceivedateCheck(), loanEntry.getInt("seq")));
            }
            if (loadDate != null && expireDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)expireDate) <= 1) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbExpiredateCheck(), loanEntry.getInt("seq")));
            }
            BigDecimal drawAmount = loanEntry.getBigDecimal("drawamount");
            BigDecimal repayAmount = loanEntry.getBigDecimal("repayamount");
            if (repayAmount.compareTo(BigDecimal.ZERO) > 0 && repayAmount.compareTo(drawAmount) > 0) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbRepayamountCheck(), loanEntry.getInt("seq")));
            }
            Date repayDate = loanEntry.getDate("repaydate");
            if (repayAmount.compareTo(BigDecimal.ZERO) > 0) {
                if (repayDate == null) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbRepayadateNotNull(), loanEntry.getInt("seq")));
                } else if (loadDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)repayDate) <= 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbRepayadateCheck(), loanEntry.getInt("seq")));
                }
            }
            if (EmptyUtil.isEmpty((BigDecimal)repayAmount) && EmptyUtil.isNoEmpty((Object)repayDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getRepayInfoCannotAllnull(), loanEntry.getInt("seq")));
            }
            BigDecimal payInterestAmount = loanEntry.getBigDecimal("payinterestamount");
            Date endInstDate = loanEntry.getDate("endinstdate");
            if (EmptyUtil.isEmpty((BigDecimal)payInterestAmount) && EmptyUtil.isNoEmpty((Object)endInstDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getpayIntInfoCannotAllnull(), loanEntry.getInt("seq")));
            }
            if (payInterestAmount.compareTo(BigDecimal.ZERO) > 0) {
                if (endInstDate == null) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndinstdateNotNull(), loanEntry.getInt("seq")));
                } else if (loadDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)endInstDate) < 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndinstdateCheck(), loanEntry.getInt("seq")));
                }
            }
            if ((endPreInstDate = loanEntry.getDate("endpreinstdate")) != null) {
                if (endInstDate != null && DateUtils.getDiffDays((Date)endInstDate, (Date)endPreInstDate) < 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndpreinstdateCheck(), loanEntry.getInt("seq")));
                } else if (loadDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)endPreInstDate) < 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndpreinstdateLdcheck(), loanEntry.getInt("seq")));
                }
            }
            boolean isLoanExtend = loanEntry.getBoolean("isloanextend");
            Date loanExpireDate = loanEntry.getDate("loanexpiredate");
            Boolean isExtend = initBill.getBoolean("isextend");
            if (isExtend.booleanValue() && isLoanExtend && loanExpireDate == null) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbLoanexpiredateNotnull(), loanEntry.getInt("seq")));
            } else if (isExtend.booleanValue() && isLoanExtend && expireDate != null && DateUtils.getDiffDays((Date)expireDate, (Date)loanExpireDate) <= 0) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbLoanexpiredateCheck(), loanEntry.getInt("seq")));
            }
            this.validateRepaySubEntry(dataEntity, loanEntry, isExtend);
            this.validateRepaymentWay(dataEntity, loanEntry, bizResource);
            loanTotalAmt = loanTotalAmt.add(drawAmount);
        }
        BigDecimal amount = initBill.getBigDecimal("amount");
        if (loanTotalAmt.compareTo(amount) > 0) {
            this.addErrorMessage(dataEntity, bizResource.getLbDrawamountChecksum());
        }
    }

    private void validateRepaymentWay(ExtendedDataEntity dataEntity, DynamicObject loanEntry, AbstractBizResource bizResource) {
        List<String> repayWays;
        String repaymentWay = loanEntry.getString("loan_repaymentway");
        String settleMode = loanEntry.getString("loan_settleintmode");
        List<String> intPlanWays = Arrays.asList(RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.zdyhk.getValue());
        if (intPlanWays.contains(repaymentWay) && SettleIntModeEnum.gdpljx.getValue().equals(settleMode) && EmptyUtil.isEmpty((DynamicObject)loanEntry.getDynamicObject("loan_interestsettledplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getInterestSettledPlanNotNull());
        }
        if ((repayWays = Arrays.asList(RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.debx.getValue())).contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)loanEntry.getDynamicObject("loan_stageplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getStagePlanNotNull());
        }
    }

    private void validateRepaySubEntry(ExtendedDataEntity dataEntity, DynamicObject loanEntry, Boolean isextend) {
        DynamicObjectCollection repaySubEntrys = loanEntry.getDynamicObjectCollection("repaysubentry");
        AbstractBizResource cfmBizResource = new BizResourceFactory().getBizResource(dataEntity.getDataEntity().getString("datasource"));
        if (EmptyUtil.isEmpty((DynamicObjectCollection)repaySubEntrys)) {
            this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbRepaysubentryNotnull(), loanEntry.getInt("seq")));
            return;
        }
        boolean isLoanExtend = loanEntry.getBoolean("isloanextend");
        Date loanExpireDate = loanEntry.getDate("loanexpiredate");
        Date loadDate = loanEntry.getDate("loaddate");
        Date expireDate = loanEntry.getDate("expiredate");
        if (isextend.booleanValue() && isLoanExtend && loanExpireDate != null) {
            expireDate = loanExpireDate;
        }
        Date compareDate = null;
        BigDecimal repayTotalAmt = BigDecimal.ZERO;
        for (DynamicObject repaySubEntry : repaySubEntrys) {
            Date exRepaymentDate = repaySubEntry.getDate("exrepaymentdate");
            BigDecimal exDrawAmount = repaySubEntry.getBigDecimal("exdrawamount");
            if (exRepaymentDate == null) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExrepaymentdateNotnull(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq")));
            }
            if (exDrawAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExdrawamountNotnull(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq")));
            }
            if (loadDate != null && expireDate != null && exRepaymentDate != null && (DateUtils.getDiffDays((Date)loadDate, (Date)exRepaymentDate) <= 1 || DateUtils.getDiffDays((Date)expireDate, (Date)exRepaymentDate) > 1)) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExrepaymentdateCheck(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq"), DateUtils.formatString((Date)loadDate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd")));
            }
            if (compareDate == null && exRepaymentDate != null) {
                compareDate = exRepaymentDate;
            } else if (exRepaymentDate != null && DateUtils.getDiffDays((Date)compareDate, (Date)exRepaymentDate) <= 1) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExrepaymentdateMax(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq"), DateUtils.formatString((Date)compareDate, (String)"yyyy-MM-dd")));
            }
            repayTotalAmt = repayTotalAmt.add(exDrawAmount);
        }
        BigDecimal drawAmount = loanEntry.getBigDecimal("drawamount");
        if (repayTotalAmt.compareTo(drawAmount) != 0) {
            this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExdrawamountCheck(), loanEntry.getInt("seq")));
        }
    }

    private void validateGuaranteeEntry(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        String guaWay = initBill.getString("guarantee");
        List guaWayList = Arrays.stream(guaWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        if (guaWayList.contains(GuaranteeWayEnum.NONE.getNumberValue()) && guaWayList.size() > 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u62c5\u4fdd\u53ca\u5176\u4ed6\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"InitBillSaveValidator_07", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        boolean relateDebt = this.isRelateDebt(initBill);
        if (guaWayList.contains(GuaranteeWayEnum.ENSURE.getNumberValue()) || guaWayList.contains(GuaranteeWayEnum.MORTGAGE.getNumberValue()) || guaWayList.contains(GuaranteeWayEnum.PLEDGE.getNumberValue())) {
            DynamicObjectCollection loanEntry = initBill.getDynamicObjectCollection("loanentry");
            for (DynamicObject parentRow : loanEntry) {
                DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry) && relateDebt) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u8bf7\u5148\u586b\u5199\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"InitBillSaveValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                BigDecimal totalRatio = BigDecimal.ZERO;
                Set subEntrySet = subEntry.stream().filter(e -> !e.getBoolean("gcreditguarantee")).collect(Collectors.toSet());
                for (DynamicObject subRow : subEntrySet) {
                    String guaranteeWay = Optional.ofNullable(subRow.getDynamicObject("gcontract")).map(r -> r.getString("guaranteeway")).orElse("");
                    if (EmptyUtil.isEmpty((String)guaranteeWay)) continue;
                    List onBillList = Arrays.stream(guaranteeWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> GuaranteeWayEnum.exchangeValueToNumberValue((String)r)).collect(Collectors.toList());
                    if (Collections.disjoint(guaWayList, onBillList)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u8ba1\u5212\u4e0e\u62c5\u4fdd\u5408\u540c\u7684\u62c5\u4fdd\u65b9\u5f0f\u65e0\u4ea4\u96c6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62c5\u4fdd\u5408\u540c\u3002", (String)"InitBillSaveValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
                        return;
                    }
                    totalRatio = totalRatio.add(subRow.getBigDecimal("gratio"));
                }
            }
        } else {
            DynamicObjectCollection loanEntry = initBill.getDynamicObjectCollection("loanentry");
            for (DynamicObject parentRow : loanEntry) {
                DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
                Set subEntrySet = subEntry.stream().filter(e -> !e.getBoolean("gcreditguarantee")).collect(Collectors.toSet());
                if (!EmptyUtil.isNoEmpty(subEntrySet)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u62c5\u4fdd\u4fe1\u606f\u201d\u90e8\u5206\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u6570\u636e\u3002", (String)"InitBillSaveValidator_05", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean isRelateDebt(DynamicObject bizBill) {
        DynamicObject mainBizOrg = bizBill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)bizBill.getDataEntityType().getName()).getMainOrg());
        if (EmptyUtil.isEmpty((DynamicObject)mainBizOrg)) {
            return false;
        }
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.GM.getId(), (long)mainBizOrg.getLong("id"), (String)"isrelatedebt");
    }
}

