/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractBillBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("entry.loanbillid");
        selector.add("operateType");
        selector.add("interesttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity intExtend : dataEntity) {
            DynamicObject intBatchBill = intExtend.getDataEntity();
            String loantype = intBatchBill.getString("loantype");
            String datasource = intBatchBill.getString("datasource");
            if (!EmptyUtil.isNoEmpty((String)datasource) || "hand".equals(datasource) || !EmptyUtil.isNoEmpty((String)loantype)) continue;
            DynamicObjectCollection batchEntryIntBills = intBatchBill.getDynamicObjectCollection("entry");
            ArrayList<Object> loanBillIds = new ArrayList<Object>(batchEntryIntBills.size());
            ArrayList<String> intBillNos = new ArrayList<String>(batchEntryIntBills.size());
            for (DynamicObject intBill : batchEntryIntBills) {
                loanBillIds.add(intBill.getLong("loanbillid"));
                intBillNos.add(intBill.getString("intdetailnum"));
            }
            this.validateOnWayBill(intExtend, loanBillIds, intBillNos, datasource);
        }
    }

    protected void validateOnWayBill(ExtendedDataEntity intExtend, List<Object> loanBillIds, List<String> intBillNos, String datasource) {
        QFilter statusFilter;
        DynamicObjectCollection submitInterestBills;
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("entry.loanbillid", "in", loanBillIds));
        String bizType = this.isPreInt() ? "preint" : "loan";
        qfilter.and(new QFilter("biztype", "=", (Object)bizType));
        if (EmptyUtil.isNoEmpty((Object)intExtend.getDataEntity().getPkValue())) {
            qfilter.and(new QFilter("id", "!=", intExtend.getDataEntity().getPkValue()));
        }
        DynamicObjectCollection batchEntryBills = QueryServiceHelper.query((String)"cfm_intbill_batch_pre", (String)"entry.id,entry.loanbillid", (QFilter[])qfilter.toArray());
        HashSet illegalBillIds = new HashSet();
        batchEntryBills.stream().filter(v -> loanBillIds.contains(v.get("entry.loanbillid"))).forEach(v -> illegalBillIds.add(v.getLong("entry.loanbillid")));
        if (!EmptyUtil.isEmpty(illegalBillIds)) {
            DynamicObjectCollection loanBills = LoanBillRepository.queryLoanBillByIds(illegalBillIds, (String)"billno");
            String billnos = loanBills.stream().map(d -> d.getString("billno")).collect(Collectors.joining(","));
            this.addErrorMessage(intExtend, this.getExistOnWayDataTip(billnos));
        }
        QFilter ingFilter = new QFilter("sourcebillid", "in", loanBillIds);
        if (intBillNos.size() > 0) {
            ingFilter.and("billno", "not in", intBillNos);
        }
        if ((submitInterestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"billno", (QFilter[])new QFilter[]{ingFilter, statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or("confirmstatus", "in", Arrays.asList(ConfirmStatusEnum.WAITCONFIRM.getValue(), ConfirmStatusEnum.REGISTRYING.getValue()))})).size() >= 1) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(datasource);
            List batchBillnos = submitInterestBills.stream().map(o -> o.getString("billno")).collect(Collectors.toList());
            this.addErrorMessage(intExtend, String.format(bizResource.getIbSubmitOnlyoneValidator(), String.join((CharSequence)",", batchBillnos)));
        }
    }

    public String getExistOnWayDataTip(String loanNum) {
        return ResManager.loadKDString((String)"%s\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684\u6279\u91cf\u9884\u63d0\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractBillBatchSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[]{loanNum});
    }

    public abstract boolean isPreInt();
}

