/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;

public class InterestBillByHbfxDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        ArrayList<Long> interestBillIds = new ArrayList<Long>(10);
        String entityName = dataEntities[0].getDataEntity().getDynamicObjectType().getName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject interestBill = dataEntity.getDataEntity();
            interestBillIds.add(interestBill.getLong("id"));
        }
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(2);
        List<String> billStatus = Arrays.asList("G", "F");
        filterMap.put("cas_paybill", new QFilter("billstatus", "not in", billStatus));
        filterMap.put("cas_recbill", new QFilter("billstatus", "not in", billStatus));
        Map targetBillMsgMap = TmcBotpHelper.getTargetBillMsgMap((String)entityName, interestBillIds, null, null, filterMap);
        if (targetBillMsgMap.size() == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long interestBillId = dataEntity.getDataEntity().getLong("id");
            if (!targetBillMsgMap.containsKey(interestBillId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u672c\u4ed8\u606f/\u6536\u672c\u6536\u606f\u751f\u6210\u7684\u4ed8\u606f\u5355/\u7ed3\u606f\u5355\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InterestBillByHbfxDeleteValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

