/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.opservice.loanbill.LoanBillYkxServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillLoanTypeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("datasource");
        selector.add("creditortype");
        selector.add("debtortype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("repaymentFlag", "false"))) {
            return;
        }
        String backFlage = (String)this.getOption().getVariables().get("back");
        if (EmptyUtil.isNoEmpty((String)backFlage)) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            boolean isPreInt;
            DynamicObject intBill = extendedDataEntity.getDataEntity();
            String entityName = intBill.getDynamicObjectType().getName();
            boolean bl = isPreInt = StringUtils.equals((CharSequence)entityName, (CharSequence)"cfm_preinterestbill") || StringUtils.equals((CharSequence)entityName, (CharSequence)"cim_preinterestbill");
            if (isPreInt) {
                this.validatePreInt(extendedDataEntity);
                continue;
            }
            if (LoanBillYkxServiceHelper.isYkxOp(this.getOption())) continue;
            this.validateInt(extendedDataEntity);
        }
    }

    private void validatePreInt(ExtendedDataEntity extendedDataEntity) {
        String debtorType;
        DynamicObject intBill = extendedDataEntity.getDataEntity();
        String entityName = intBill.getDynamicObjectType().getName();
        String datasource = intBill.getString("datasource");
        if (entityName.equals("cfm_preinterestbill")) {
            String debtorType2 = intBill.getString("debtortype");
            if (StringUtils.equals((CharSequence)debtorType2, (CharSequence)CreditorTypeEnum.INNERUNIT.getValue()) && datasource.equals("invest")) {
                this.addErrorMsg(extendedDataEntity, "loan");
            }
        } else if (entityName.equals("cim_preinterestbill") && StringUtils.equals((CharSequence)(debtorType = intBill.getString("creditortype")), (CharSequence)CreditorTypeEnum.INNERUNIT.getValue()) && !datasource.equals("invest")) {
            this.addErrorMsg(extendedDataEntity, "entrust");
        }
    }

    private void validateInt(ExtendedDataEntity extendedDataEntity) {
        DynamicObject intBill = extendedDataEntity.getDataEntity();
        String creditType = intBill.getString("creditortype");
        String entityName = intBill.getDynamicObjectType().getName();
        String datasource = intBill.getString("datasource");
        if (StringUtils.equals((CharSequence)creditType, (CharSequence)CreditorTypeEnum.INNERUNIT.getValue())) {
            if (entityName.equals("cfm_interestbill") && datasource.equals("invest")) {
                this.addErrorMsg(extendedDataEntity, "loan");
            } else if (entityName.equals("cim_invest_interestbill") && !datasource.equals("invest")) {
                this.addErrorMsg(extendedDataEntity, "entrust");
            }
        }
    }

    private void addErrorMsg(ExtendedDataEntity extendedDataEntity, String loanType) {
        String operateName = this.getOperationName();
        if (StringUtils.equals((CharSequence)loanType, (CharSequence)"loan")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u7531\u4f01\u4e1a\u8d37\u6b3e\u53d1\u8d77%s\u3002", (String)"InterestBillLoanTypeValidator_0", (String)"tmc-cfm-business", (Object[])new Object[]{operateName}));
        } else {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u7531\u4f01\u4e1a\u501f\u6b3e\u53d1\u8d77%s\u3002", (String)"InterestBillLoanTypeValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{operateName}));
        }
    }
}

