/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillPush2RecValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isrelcash");
        sic.add("instbillctg");
        sic.add("combineinst");
        sic.add("billstatus");
        sic.add("confirmstatus");
        sic.add("isinit");
        sic.add("eassrcid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isRelCash = bill.getBoolean("isrelcash");
            if (!isRelCash) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.InterestBillPush2RecValidator_0.loadKDString());
            }
            if (bill.getBoolean("combineinst")) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.InterestBillPush2RecValidator_2.loadKDString());
            }
            if (LoanBillHelper.isPrePayint((String)bill.getString("instbillctg"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.InterestBillPush2RecValidator_1.loadKDString());
            }
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_3.loadKDString());
            }
            if (!ConfirmStatusEnum.isYetconfirm((String)bill.getString("confirmstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_4.loadKDString());
            }
            if (bill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_2.loadKDString());
            }
            if (!EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) continue;
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_6.loadKDString());
        }
    }
}

