/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class InterestBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("bizdate");
        sic.add("loandate");
        sic.add("startinstdate");
        sic.add("endinstdate");
        sic.add("actualinstamt");
        sic.add("instbankacct");
        sic.add("billstatus");
        sic.add("datasource");
        sic.add("isoverseaentfill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("repaymentFlag", "false"))) {
            return;
        }
        if ("true".equals(this.getOption().getVariableValue("byInit", "false"))) {
            return;
        }
        Map<Long, ExtendedDataEntity> dataEntityMap = Arrays.stream(dataEntities).collect(Collectors.toMap(d -> d.getDataEntity().getLong("id"), d -> d));
        Map validateResults = InterestValidateHelper.batchValidateOnSaveBill((ExtendedDataEntity[])dataEntities);
        for (Map.Entry entry : validateResults.entrySet()) {
            ExtendedDataEntity dataEntity = dataEntityMap.get(entry.getKey());
            for (ValidateBean p : (List)entry.getValue()) {
                this.addMessage(dataEntity, p.getErrorInfo(), "error".equals(p.getErrorType()) ? ErrorLevel.Error : ErrorLevel.Warning);
            }
        }
    }
}

