/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.repository.LoanContractBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class InterestBillUnAuditOrConfirmValidator
extends AbstractTmcBizOppValidator {
    protected List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject interestBill = dataEntity.getDataEntity();
            if (interestBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, this.getBizResource(interestBill).getIbUnauditContractinit());
                continue;
            }
            String dataSource = interestBill.getString("datasource");
            if (DataSourceEnum.isIfm((String)dataSource) && !"ifm_interestbill".equals(interestBill.getDataEntityType().getName())) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.InterestBillUnAuditValidator_0.loadKDString());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected List<ExtendedDataEntity> validateLoanContract(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Set contractNos = dataEntities.stream().map(d -> d.getDataEntity().getString("contractbillno")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("billno", "in", contractNos).and("contractstatus", "=", (Object)LoanContractStatusEnum.CLOSED.getValue()).and("ishandend", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection contractBills = LoanContractBillRepository.queryByFilter((QFilter)qFilter, (String)"id,billno");
        if (contractBills.isEmpty()) {
            return dataEntities;
        }
        Map<String, DynamicObject> contractNoMap = contractBills.stream().collect(Collectors.toMap(d -> d.getString("billno"), d -> d, (d1, d2) -> d1));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject interestBill = dataEntity.getDataEntity();
            DynamicObject contractBill = contractNoMap.get(interestBill.getString("contractbillno"));
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBill)) {
                this.addErrorMessage(dataEntity, String.format(this.getBizResource(interestBill).getIbUnOpContractByHandEnd(), contractBill.getString("billno")));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected List<ExtendedDataEntity> validatePayCorAndInt(List<ExtendedDataEntity> dataEntities, boolean isUnConfirm) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List interestBills = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map checkMap = InterestValidateHelper.checkPayCorAndInt(interestBills);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject interestBill = dataEntity.getDataEntity();
            if (!((Boolean)checkMap.get(interestBill.getLong("id"))).booleanValue()) {
                AbstractBizResource bizResource = this.getBizResource(interestBill);
                this.addErrorMessage(dataEntity, !isUnConfirm ? bizResource.getIbRePayBiz() : bizResource.getIbUnConfirmPayIntBill());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected AbstractBizResource getBizResource(DynamicObject interestBill) {
        return BusinessHelper.getBizResource((DynamicObject)interestBill);
    }
}

