/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.constant.CfmBizConstant;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;

public class InterestBillWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("instbillctg");
        sic.add("billstatus");
        sic.add("sourcebillid");
        sic.add("datasource");
        sic.add("writeoffstatus");
        sic.add("creditortype");
        sic.add("creditorg");
        sic.add("org");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long orgId;
            DynamicObject intBill = dataEntity.getDataEntity();
            if (!this.getOption().getVariables().containsKey(CfmBizConstant.PARAM_AUTOWRITEOFF) && !BillStatusEnum.AUDIT.getValue().equals(intBill.getString("billstatus")) || !WriteOffStatusEnum.NO_WRITEOFF.getValue().equals(intBill.getString("writeoffstatus"))) {
                String message = ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u672a\u51b2\u9500\u5355\u636e\u5141\u8bb8\u51b2\u9500\u3002", (String)"InterestBillWriteOffValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
            String creditorType = intBill.getString("creditortype");
            String entityName = intBill.getDataEntityType().getName();
            String mainOrgFeild = "org";
            if (StringUtils.equals((CharSequence)"cim_invest_interestbill", (CharSequence)entityName) || StringUtils.equals((CharSequence)creditorType, (CharSequence)CreditorTypeEnum.INNERUNIT.getValue())) {
                mainOrgFeild = "creditorg";
            }
            if (!IntBillWriteOffHelper.isRedWriteOffParam((long)(orgId = intBill.getDynamicObject(mainOrgFeild).getLong("id")))) continue;
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\uff1a\u5168\u989d\u51b2\u9500\u6cd5\u3002", (String)"InterestBillWriteOffValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
    }
}

