/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.validate.interestbill.AbstractBillBatchSaveValidator;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanIntBillBatchSaveValidator
extends AbstractBillBatchSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("entry");
        selector.add("entry.loanbillid");
        selector.add("operateType");
        selector.add("interesttype");
        selector.add("comment");
        selector.add("isauto");
        return selector;
    }

    @Override
    public boolean isPreInt() {
        return Boolean.FALSE;
    }

    @Override
    public String getExistOnWayDataTip(String loanNum) {
        return ResManager.loadKDString((String)"%s\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684\u6279\u91cf\u6536\u606f/\u4ed8\u606f\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"LoanIntBillBatchSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[]{loanNum});
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        super.validate(dataEntity);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject intBatchBill = entity.getDataEntity();
            DynamicObjectCollection batchEntryIntBills = intBatchBill.getDynamicObjectCollection("entry");
            if (batchEntryIntBills.size() == 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u606f\u8bb0\u5f55\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanIntBillBatchSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            this.validateDate(entity, batchEntryIntBills);
        }
    }

    private boolean isPayIntByPlan(DynamicObject intBatchBill, DynamicObject intBill) {
        if (intBatchBill.getBoolean("isauto")) {
            return Boolean.TRUE;
        }
        long loanBillId = intBill.getLong("loanbillid");
        DynamicObject[] loanBills = LoanBillRepository.getLoanBillsByPayInt((Object[])new Object[]{loanBillId});
        if (loanBills.length == 0) {
            return Boolean.FALSE;
        }
        return CfmContractBillHelper.isPayIntByPlan((DynamicObject)loanBills[0]);
    }

    private void validateDate(ExtendedDataEntity entity, DynamicObjectCollection batchEntryIntBills) {
        DynamicObject[] loanBills;
        boolean isPayIntByPlan = this.isPayIntByPlan(entity.getDataEntity(), (DynamicObject)batchEntryIntBills.get(0));
        ArrayList<Long> loanBillIds = new ArrayList<Long>(batchEntryIntBills.size());
        HashMap<Long, Date> loanIdDateMap = new HashMap<Long, Date>(batchEntryIntBills.size());
        HashMap<Long, Integer> loanIdIndexMap = new HashMap<Long, Integer>(batchEntryIntBills.size());
        for (int i = 0; i < batchEntryIntBills.size(); ++i) {
            DynamicObject intBill = (DynamicObject)batchEntryIntBills.get(i);
            long loanBillId = intBill.getLong("loanbillid");
            loanBillIds.add(loanBillId);
            loanIdDateMap.put(loanBillId, intBill.getDate("payintdate"));
            loanIdIndexMap.put(loanBillId, i + 1);
        }
        String queryFields = "id, billno, datasource, lastrepaydate, repayplan_entry, exrepaymentdate, enotrepayamount, repaystate";
        for (DynamicObject loanBill : loanBills = LoanBillRepository.getLoanBillById(loanBillIds, (String)queryFields)) {
            DynamicObject intPlanEntry;
            Date exRepaymentDate;
            List intPlans;
            DynamicObjectCollection repayPlans;
            long id = loanBill.getLong("id");
            String billNo = loanBill.getString("billno");
            Date lastRepayDate = loanBill.getDate("lastrepaydate");
            Date payIntDate = DateUtils.getDataFormat((Date)((Date)loanIdDateMap.get(id)), (boolean)true);
            String dataSource = loanBill.getString("datasource");
            String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)dataSource);
            String intName = CfmBillCommonHelper.getIntNameByDataSource((String)dataSource);
            String repayName = CfmBillCommonHelper.getRepayNameByDataSource((String)dataSource);
            if (EmptyUtil.isNoEmpty((Object)lastRepayDate) && payIntDate.compareTo(DateUtils.getDataFormat((Date)lastRepayDate, (boolean)true)) < 0) {
                String msg = String.format(this.getMsgByPayIntDate(isPayIntByPlan), loanIdIndexMap.get(id), loanName, billNo, intName, DateUtils.formatString((Date)lastRepayDate, (String)"yyyy-MM-dd"), isPayIntByPlan ? intName : null);
                this.addErrorMessage(entity, msg);
            }
            if (!isPayIntByPlan || (repayPlans = loanBill.getDynamicObjectCollection("repayplan_entry")).size() <= 0 || (intPlans = repayPlans.stream().filter(o -> o.getBigDecimal("enotrepayamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("repaystate") == 0).collect(Collectors.toList())).size() == 0 || payIntDate.compareTo(DateUtils.getDataFormat((Date)(exRepaymentDate = (intPlanEntry = intPlans.stream().min(Comparator.comparing(c -> c.getDate("exrepaymentdate"))).orElseGet(null)).getDate("exrepaymentdate")), (boolean)true)) <= 0) continue;
            this.addErrorMessage(entity, String.format(this.getMsgByExRepaymentDate(), loanIdIndexMap.get(id), loanName, billNo, repayName, intName));
        }
    }

    private String getMsgByPayIntDate(boolean isPayIntByPlan) {
        if (isPayIntByPlan) {
            return ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u5355%3$s %4$s\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u8fd1\u8fd8\u6b3e\u65e5%5$s\uff0c\u8bf7\u7ef4\u62a4%6$s\u8ba1\u5212\u3002", (String)"LoanIntBillBatchSaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u5355%3$s %4$s\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u8fd1\u8fd8\u6b3e\u65e5%5$s\u3002", (String)"LoanIntBillBatchSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]);
    }

    private String getMsgByExRepaymentDate() {
        return ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u5355%3$s \u6709\u672a\u6267\u884c\u7684%4$s\u8ba1\u5212\uff0c\u4e0d\u80fd%5$s\u3002", (String)"LoanIntBillBatchSaveValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]);
    }
}

