/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanIntBillBatchSlSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("entry");
        sel.add("loanbillid");
        sel.add("loanbillno");
        sel.add("actualinstamt");
        sel.add("convertintamt");
        sel.add("slentryentity");
        sel.add("s_loanbillno");
        sel.add("s_repayinst");
        sel.add("s_instcurrency");
        sel.add("s_convertintamt");
        sel.add("s_bank");
        sel.add("s_bankrole");
        sel.add("s_loanamount");
        sel.add("s_loancurrency");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            int currencyPresion;
            DynamicObject loanIntCurrency;
            Pair loanAmountPair;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection slBankEntrys = data.getDynamicObjectCollection("slentryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)slBankEntrys)) continue;
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entry");
            Set loanBillIds = entrys.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("loanbillid"))).map(o -> o.getLong("loanbillid")).collect(Collectors.toSet());
            for (DynamicObject slBankEntry : slBankEntrys) {
                DynamicObject loanBill = slBankEntry.getDynamicObject("s_loanbillno");
                if (!EmptyUtil.isEmpty((DynamicObject)loanBill) && loanBillIds.contains(loanBill.getLong("id"))) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanIntBillBatchSlSubmitValidator_0.loadKDString(loanBill.getString("billno")));
            }
            Map<Long, Pair> loanEntryAmountPair = entrys.stream().collect(Collectors.toMap(o -> o.getLong("loanbillid"), o -> Pair.of((Object)o.getBigDecimal("actualinstamt"), (Object)o.getBigDecimal("convertintamt")), (v1, v2) -> v2));
            Map<Long, String> billNoMap = entrys.stream().collect(Collectors.toMap(o -> o.getLong("loanbillid"), o -> o.getString("loanbillno"), (v1, v2) -> v2));
            Map<Long, DynamicObject> billIntCurrMap = entrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("currency"))).collect(Collectors.toMap(o -> o.getLong("loanbillid"), o -> o.getDynamicObject("currency"), (v1, v2) -> v2));
            Map<Long, List<DynamicObject>> slLoanMap = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.groupingBy(o -> o.getDynamicObject("s_loanbillno").getLong("id")));
            Map<Long, BigDecimal> intAmountMap = slLoanMap.entrySet().stream().collect(Collectors.toMap(o -> (Long)o.getKey(), o -> ((List)o.getValue()).stream().map(e -> e.getBigDecimal("s_repayinst")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            Map<Long, BigDecimal> covertAmountMap = slLoanMap.entrySet().stream().collect(Collectors.toMap(o -> (Long)o.getKey(), o -> ((List)o.getValue()).stream().map(e -> e.getBigDecimal("s_convertintamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            for (Map.Entry<Long, BigDecimal> entry : intAmountMap.entrySet()) {
                loanAmountPair = loanEntryAmountPair.get(entry.getKey());
                if (entry.getValue().compareTo((BigDecimal)loanAmountPair.getLeft()) == 0) continue;
                loanIntCurrency = billIntCurrMap.get(entry.getKey());
                currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)loanIntCurrency);
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanIntBillBatchSlSubmitValidator_1.loadKDString(billNoMap.get(entry.getKey()), entry.getValue().setScale(currencyPresion), ((BigDecimal)loanAmountPair.getLeft()).setScale(currencyPresion)));
            }
            for (Map.Entry<Long, BigDecimal> entry : covertAmountMap.entrySet()) {
                loanAmountPair = loanEntryAmountPair.get(entry.getKey());
                if (entry.getValue().compareTo((BigDecimal)loanAmountPair.getRight()) == 0) continue;
                loanIntCurrency = billIntCurrMap.get(entry.getKey());
                currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)loanIntCurrency);
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanIntBillBatchSlSubmitValidator_2.loadKDString(billNoMap.get(entry.getKey()), entry.getValue().setScale(currencyPresion), ((BigDecimal)loanAmountPair.getLeft()).setScale(currencyPresion)));
            }
            for (DynamicObject slBankEntry : slBankEntrys) {
                DynamicObject loanBill = slBankEntry.getDynamicObject("s_loanbillno");
                DynamicObject instCurrency = slBankEntry.getDynamicObject("s_instcurrency");
                DynamicObject loanIntCurrency2 = billIntCurrMap.get(loanBill.getLong("id"));
                if (EmptyUtil.isEmpty((DynamicObject)loanBill) || EmptyUtil.isEmpty((DynamicObject)loanIntCurrency2) || !EmptyUtil.isEmpty((DynamicObject)instCurrency) && instCurrency.getLong("id") == loanIntCurrency2.getLong("id")) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanIntBillBatchSlSubmitValidator_3.loadKDString(loanBill.getString("billno")));
            }
        }
    }
}

