/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cfm.common.resource.IfmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class LoanIntBillBatchunAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity intExtend : dataEntity) {
            DynamicObject intBatchBill = intExtend.getDataEntity();
            DynamicObjectCollection batchEntryIntBills = intBatchBill.getDynamicObjectCollection("entry");
            for (DynamicObject intBill : batchEntryIntBills) {
                Map downStreamBillMap = BFTrackerServiceHelper.findTargetBills((String)"cfm_interestbill", (Long[])new Long[]{intBill.getLong("id")});
                this.validateDownStreamInfo(downStreamBillMap, ifmBizResource, intExtend);
            }
        }
    }

    private void validateDownStreamInfo(Map<String, HashSet<Long>> downStreamBillMap, IfmBizResource ifmBizResource, ExtendedDataEntity ede) {
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, HashSet<Long>> entry : downStreamBillMap.entrySet()) {
            String entityName = entry.getKey();
            if (!"cas_recbill".equals(entityName) && !"cas_paybill".equals(entityName)) continue;
            String existBillsMsg = LoanIntBillBatchunAuditValidator.findExistBillsMsg(ifmBizResource, entityName, entry.getValue());
            msg.append(existBillsMsg);
        }
        if (msg.length() > 0) {
            msg.insert(0, ifmBizResource.getExistTargetBillError());
            this.addErrorMessage(ede, msg.toString());
        }
    }

    private static String findExistBillsMsg(IfmBizResource ifmBizResource, String targetEntityName, HashSet<Long> targetBillIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)targetEntityName, (String)"billno", (QFilter[])new QFilter[]{new QFilter("ID", "in", targetBillIds)});
        if (query == null || query.size() <= 0) {
            return "";
        }
        List billnos = query.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        String targetBillName = LoanIntBillBatchunAuditValidator.getName(targetEntityName);
        return String.format(ifmBizResource.getExistTargetBillDetail(), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }

    private static String getName(String value) {
        switch (value) {
            case "ifm_bizdealbill": {
                return ResManager.loadKDString((String)"\u8d27\u6b3e\u4e1a\u52a1\u53d7\u7406", (String)"LoanIntBillBatchunAuditValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "ifm_loancontractbill": {
                return ResManager.loadKDString((String)"\u8d27\u6b3e\u5408\u540c\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "ifm_loanbill": {
                return ResManager.loadKDString((String)"\u8d37\u6b3e\u653e\u6b3e\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "ifm_repaymentbill": {
                return ResManager.loadKDString((String)"\u8d27\u6b3e\u6536\u56de\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "ifm_interestbill": {
                return ResManager.loadKDString((String)"\u8d27\u6b3e\u7ed3\u606f\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "ifm_rectransbill": {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u4ea4\u6613\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "ifm_transhandlebill": {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "cas_paybill": {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
            case "cas_recbill": {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u5904\u7406", (String)"LoanIntBillBatchunAuditValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

