/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PrePeriodParamEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExecutePush2PreInstValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("drawtype");
        selector.add("confirmstatus");
        selector.add("datasource");
        selector.add("loantype");
        selector.add("id");
        selector.add("sourcebillid");
        selector.add("endpreinstdate");
        selector.add("repaymentway");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String preperiod = (String)variables.get("preperiod");
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(data.getString("datasource"));
            String confirmStatus = data.getString("confirmstatus");
            if (!ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus)) {
                this.addErrorMessage(entity, bizResource.getLoanPreInterestConfirmStatus());
            }
            if (RepaymentWayEnum.isHbfx((String)data.getString("repaymentway"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u8fd8\u6b3e\u65b9\u5f0f\u4e3a\u7b49\u989d\u672c\u606f\u6216\u7b49\u989d\u672c\u91d1\u6216\u7b49\u672c\u7b49\u606f\uff0c\u4e0d\u80fd\u8fdb\u884c\u9884\u63d0\u64cd\u4f5c\u3002", (String)"LoanBillAutoRepayValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]), data.getString("billno")));
            }
            Date prestenddate = DateUtils.getCurrentDate();
            if (PrePeriodParamEnum.THISMONTH.getValue().equals(preperiod)) {
                prestenddate = DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate());
            } else if (PrePeriodParamEnum.LASTMONTH.getValue().equals(preperiod)) {
                prestenddate = DateUtils.getLastDayOfMonth((Date)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1));
            } else if (PrePeriodParamEnum.THISSEASON.getValue().equals(preperiod)) {
                prestenddate = DateUtils.getQuarterEnd((Date)DateUtils.getCurrentDate());
            }
            Date endPreinstDate = data.getDate("endpreinstdate");
            if (EmptyUtil.isNoEmpty((Object)endPreinstDate) && endPreinstDate.compareTo(prestenddate) >= 0) {
                this.addErrorMessage(entity, String.format(bizResource.checkPreIntStartEndDate(), data.getString("billno")));
            }
            String entityName = data.getDynamicObjectType().getName();
            String loanType = data.getString("loantype");
            if ((!"cfm_loanbill_bond".equals(entityName) || LoanTypeEnum.BOND.getValue().equals(loanType)) && ("cfm_loanbill_bond".equals(entityName) || !LoanTypeEnum.BOND.getValue().equals(loanType))) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0:%1$s\u4e0e\u8d37\u6b3e\u7c7b\u578b%2$s\u4e0d\u5339\u914d\u3002", (String)"LoanBillAutoRepayValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]), entityName, LoanTypeEnum.getName((String)loanType)));
        }
    }
}

