/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.repository.RateAdjustBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class LoanBillAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("contractbillno");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("rateadjustcycletype");
        sic.add("renewalinterestrate");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("interesttype");
        sic.add("referencerate");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("ratetype");
        sic.add("renewalinteresttype");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("creditortype");
        sic.add("ratehistory_entry");
        sic.add("createtime");
        sic.add("isinit");
        sic.add("loancontractbill");
        sic.add("issofrrate");
        sic.add("iscallcompint");
        sic.add("intcalmethod");
        sic.add("workcalendar");
        sic.add("rateresetadjustrule");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        List<ExtendedDataEntity> dataEntityList = Arrays.stream(dataEntitys).filter(d -> !LoanBillHelper.isBond((DynamicObject)d.getDataEntity())).collect(Collectors.toList());
        for (int i = dataEntityList.size() - 1; i >= 0; --i) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityList.get(i);
            if (this.contractBillClosedValidator(dataEntity)) continue;
            dataEntityList.remove(i);
        }
        this.rateAdjustBillDateValidate(dataEntityList);
    }

    private void rateAdjustBillDateValidate(List<ExtendedDataEntity> dataEntityList) {
        if (!dataEntityList.isEmpty()) {
            List loanBills = dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Map map = RateAdjustBillRepository.getAuditDateLargeCreateTime(loanBills);
            for (ExtendedDataEntity dataEntity : dataEntityList) {
                DynamicObject loanBill = dataEntity.getDataEntity();
                if (!((Boolean)map.get(loanBill.getLong("id"))).booleanValue()) continue;
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
                this.addErrorMessage(dataEntity, bizResource.getLbSubmitHaveRateAdjustBill());
            }
        }
    }

    private boolean contractBillClosedValidator(ExtendedDataEntity dataEntity) {
        DynamicObject loanBillDO = dataEntity.getDataEntity();
        DynamicObject contractF7 = loanBillDO.getDynamicObject("loancontractbill");
        if (LoanContractStatusEnum.CLOSED.getValue().equals(contractF7.getString("contractstatus"))) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBillDO.getString("datasource"));
            this.addErrorMessage(dataEntity, bizResource.getLoanStatusNotClose());
            return false;
        }
        return true;
    }
}

