/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillInstPlanSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("drawamount");
        sic.add("renewalexpiredate");
        sic.add("expiredate");
        sic.add("datasource");
        sic.add("currency");
        sic.add("interest_entry");
        sic.add("bizdate");
        sic.add("interest_entry.seq");
        sic.add("interest_entry.interestseq");
        sic.add("interest_entry.interesdate");
        sic.add("interest_entry.interestcalamount");
        sic.add("interest_entry.intstate");
        sic.add("interest_entry.intaccount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        HashSet<Date> dateSet = new HashSet<Date>(16);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject loanBillDO = dataEntity.getDataEntity();
            String dateSource = loanBillDO.getString("datasource");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dateSource);
            DynamicObjectCollection instPlans = loanBillDO.getDynamicObjectCollection("interest_entry");
            dateSet.clear();
            for (int i = 0; i < instPlans.size(); ++i) {
                BigDecimal calInstAmount;
                DynamicObject rowLoanBill = (DynamicObject)instPlans.get(i);
                if (rowLoanBill.getInt("intstate") == 1) continue;
                Date interesDate = rowLoanBill.getDate("interesdate");
                if (EmptyUtil.isEmpty((Object)interesDate)) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreInstDateIsNotnull(), i + 1));
                    continue;
                }
                Date loanDate = loanBillDO.getDate("bizdate");
                if (interesDate.compareTo(loanDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8/\u6536\u606f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u653e\u6b3e\u65e5\u671f:%s\u3002", (String)"LoanBillInstPlanSaveValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]), DateUtils.formatString((Date)loanDate, (String)"yyyy-MM-dd")));
                }
                if (!dateSet.add(interesDate)) {
                    this.addErrorMessage(dataEntity, bizResource.getLbExInstdateCheck());
                }
                if (EmptyUtil.isEmpty((BigDecimal)(calInstAmount = rowLoanBill.getBigDecimal("interestcalamount")))) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreInstAmtIsNotnull(), i + 1));
                } else if (calInstAmount.compareTo(new BigDecimal("9999999999999.9999")) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91d1\u989d\u6570\u503c\u4e0d\u80fd\u5927\u4e8e9999999999999.9999\u3002", (String)"LoanBillInstPlanSaveValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
                DynamicObject intAccount = rowLoanBill.getDynamicObject("intaccount");
                if (!EmptyUtil.isEmpty((DynamicObject)intAccount) || DataSourceEnum.isInvest((String)dateSource)) continue;
                this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreInstAccountIsNotnull(), i + 1));
            }
        }
    }
}

