/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillScheduleSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("drawamount");
        sic.add("datasource");
        sic.add("currency");
        sic.add("repayplan_entry");
        sic.add("isnofixedterm");
        sic.add("repaymentway");
        sic.add("startloanrate");
        sic.add("interesttype");
        sic.add("interestsettledplan");
        sic.add("repayplan_entry.seq");
        sic.add("repayplan_entry.exdrawamount");
        sic.add("repayplan_entry.erepayamount");
        sic.add("repayplan_entry.exrepaymentdate");
        sic.add("repayplan_entry.repaystate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject loanBillDO = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBillDO.getString("datasource"));
            this.checkRepayAmount(dataEntity, loanBillDO, bizResource);
            this.checkIntSchema(dataEntity, loanBillDO, bizResource);
        }
    }

    private void checkIntSchema(ExtendedDataEntity dataEntity, DynamicObject loanBill, AbstractBizResource bizResource) {
        boolean isDqhx;
        String repaymentWay = loanBill.getString("repaymentway");
        BigDecimal startLoanRate = loanBill.getBigDecimal("startloanrate");
        String interestType = loanBill.getString("interesttype");
        boolean isNot0Rate = InterestTypeEnum.isFloat((String)interestType) || !InterestTypeEnum.isFloat((String)interestType) && BigDecimal.ZERO.compareTo(startLoanRate) != 0;
        boolean bl = isDqhx = RepaymentWayEnum.isDqhbdqhx((String)repaymentWay) || RepaymentWayEnum.isBqhbdqhx((String)repaymentWay);
        if (isNot0Rate && isDqhx && loanBill.getDynamicObject("interestsettledplan") == null) {
            this.addErrorMessage(dataEntity, bizResource.getInterestSettledPlanNotNull());
        }
    }

    private void checkRepayAmount(ExtendedDataEntity dataEntity, DynamicObject loanBillDO, AbstractBizResource bizResource) {
        DynamicObjectCollection loanBillScheduleDC = loanBillDO.getDynamicObjectCollection("repayplan_entry");
        BigDecimal exdrawamount = BigDecimal.ZERO;
        HashSet<Date> dateSet = new HashSet<Date>();
        for (int i = 0; i < loanBillScheduleDC.size(); ++i) {
            Date exrepaymentdate;
            DynamicObject rowLoanBill = (DynamicObject)loanBillScheduleDC.get(i);
            BigDecimal exDrawAmount = rowLoanBill.getBigDecimal("exdrawamount");
            BigDecimal repayAmount = rowLoanBill.getBigDecimal("erepayamount");
            if (EmptyUtil.isEmpty((BigDecimal)exDrawAmount)) {
                this.addErrorMessage(dataEntity, bizResource.getLbPreAmtIsNotnull());
            }
            DynamicObject currency = loanBillDO.getDynamicObject("currency");
            if (EmptyUtil.isNoEmpty((BigDecimal)repayAmount) && repayAmount.compareTo(exDrawAmount) > 0 && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                BigDecimal newRepayAmount = repayAmount.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreAmtIsLessYetAmt(), i + 1, newRepayAmount));
            }
            exdrawamount = exdrawamount.add(exDrawAmount);
            if (RepayStateEnum.isPayed((String)rowLoanBill.getString("repaystate")) || dateSet.add(exrepaymentdate = rowLoanBill.getDate("exrepaymentdate"))) continue;
            this.addErrorMessage(dataEntity, bizResource.getLbExrepaymentdateCheck());
        }
        if (exdrawamount.compareTo(loanBillDO.getBigDecimal("drawamount")) != 0) {
            this.addErrorMessage(dataEntity, bizResource.getLbExdrawamountCheck());
        }
    }
}

