/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.business.validate.loanbill.LoanBillSaveValidator;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.repository.RateAdjustBillRepository;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillSubmitValidator
extends LoanBillSaveValidator {
    @Override
    public List<String> getSelector() {
        return super.getSelector();
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        super.validate(dataEntitys);
        List<ExtendedDataEntity> dataEntityList = this.validateBillHead(dataEntitys);
        dataEntityList = this.validateCreditLimit(dataEntityList);
        dataEntityList = this.validateAuditDateLargeCreateTime(dataEntityList);
        dataEntityList = this.validatorBankCateEntry(dataEntityList);
    }

    private List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBillDO = dataEntity.getDataEntity();
            DynamicObject contractF7 = loanBillDO.getDynamicObject("loancontractbill");
            if (EmptyUtil.isEmpty((DynamicObject)contractF7)) {
                dataEntityList.add(dataEntity);
                continue;
            }
            if (LoanContractStatusEnum.isClosed((String)contractF7.getString("contractstatus"))) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getLoanStatusNotClose());
                continue;
            }
            String dataSource = loanBillDO.getString("datasource");
            if (DataSourceEnum.isInvest((String)dataSource)) {
                if (loanBillDO.getString("loantype").isEmpty()) {
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getLoantypeNotNull());
                    continue;
                }
                DynamicObject loanerAcctBank = loanBillDO.getDynamicObject("loaneracctbank");
                if (EmptyUtil.isEmpty((DynamicObject)loanerAcctBank)) {
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getLoanerAcctBankNotNull());
                    continue;
                }
            } else {
                DynamicObject accountBank = loanBillDO.getDynamicObject("accountbank");
                if (EmptyUtil.isEmpty((DynamicObject)accountBank)) {
                    if (LoanTypeEnum.isBond((String)loanBillDO.getString("loantype"))) {
                        this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getBondAcctBankNotNull());
                        continue;
                    }
                    if (DataSourceEnum.isIfm((String)dataSource)) {
                        this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getLoanAcctBankNotNull());
                        continue;
                    }
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getAcctBankNotNull());
                    continue;
                }
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validatorBankCateEntry(List<ExtendedDataEntity> dataEntitys) {
        if (EmptyUtil.isEmpty(dataEntitys)) {
            return dataEntitys;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        ArrayList<ExtendedDataEntity> dataEntities = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObjectCollection bankCateEntrys;
            BigDecimal totalAmount;
            DynamicObject loanBill = dataEntity.getDataEntity();
            if (!BizTypeEnum.isSL((String)loanBill.getString("loantype"))) {
                dataEntityList.add(dataEntity);
                continue;
            }
            BigDecimal drawAmount = loanBill.getBigDecimal("drawamount");
            if (drawAmount.compareTo(totalAmount = (bankCateEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry")).stream().filter(o -> EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("e_shareamount"))).map(o -> o.getBigDecimal("e_shareamount")).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                String defaultStr = ResManager.loadKDString((String)"\u63d0\u6b3e\u91d1\u989d", (String)"LoanBillSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]);
                LocaleString drawAmountLoacl = ((IDataEntityProperty)loanBill.getDataEntityType().getProperties().get((Object)"drawamount")).getDisplayName();
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillSubmitValidator_1.loadKDString(drawAmountLoacl != null ? drawAmountLoacl.getLocaleValue() : defaultStr));
                continue;
            }
            dataEntities.add(dataEntity);
        }
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntityList;
        }
        Map<Long, List<ExtendedDataEntity>> loanBillGroupMap = dataEntities.stream().collect(Collectors.groupingBy(d -> d.getDataEntity().getLong("loancontractbill.id")));
        Map contractDrawAmountMap = LoanBillHelper.getSlBankNotdrawamount(loanBillGroupMap.keySet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            long contractId = loanBill.getLong("loancontractbill.id");
            Map slBankNotdrawamountMap = (Map)contractDrawAmountMap.get(contractId);
            if (EmptyUtil.isEmpty((Object)slBankNotdrawamountMap)) {
                dataEntityList.add(dataEntity);
                continue;
            }
            boolean isBreak = false;
            DynamicObjectCollection bankCateEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
            for (int i = 0; i < bankCateEntrys.size(); ++i) {
                DynamicObject bankCateEntry = (DynamicObject)bankCateEntrys.get(i);
                BigDecimal shareAmount = bankCateEntry.getBigDecimal("e_shareamount");
                BigDecimal conAmount = bankCateEntry.getBigDecimal("e_contractamount");
                if (shareAmount != null && conAmount.compareTo(shareAmount) < 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillSubmitValidator_2.loadKDString(i + 1));
                    isBreak = true;
                    break;
                }
                DynamicObject bank = bankCateEntry.getDynamicObject("e_bank");
                if (bank == null) continue;
                BigDecimal bankNotDrawAmount = slBankNotdrawamountMap.getOrDefault(bank.getLong("id"), BigDecimal.ZERO);
                if (shareAmount == null || shareAmount.compareTo(bankNotDrawAmount) <= 0) continue;
                DynamicObject currency = loanBill.getDynamicObject("currency");
                int amtPrecision = currency != null ? currency.getInt("amtprecision") : 2;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillSubmitValidator_3.loadKDString(i + 1, bankNotDrawAmount.setScale(amtPrecision)));
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateCreditLimit(List<ExtendedDataEntity> dataEntitys) {
        if (EmptyUtil.isEmpty(dataEntitys) || LoanBillHelper.isBond((DynamicObject)dataEntitys.get(0).getDataEntity())) {
            return dataEntitys;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            boolean isCreditLimit;
            DynamicObject loanBillDO = dataEntity.getDataEntity();
            DynamicObject productFactory = loanBillDO.getDynamicObject("productfactory");
            DynamicObject contractbill = loanBillDO.getDynamicObject("loancontractbill");
            boolean bl = isCreditLimit = EmptyUtil.isEmpty((DynamicObject)productFactory) || productFactory.getBoolean("iscreditlimit");
            if (isCreditLimit && EmptyUtil.isEmpty((DynamicObject)contractbill.getDynamicObject("creditlimit")) && "bd_finorginfo".equals(loanBillDO.getString("creditortype"))) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getLbSubmitCreditLimitNotNull());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateAuditDateLargeCreateTime(List<ExtendedDataEntity> dataEntitys) {
        if (EmptyUtil.isEmpty(dataEntitys) || LoanBillHelper.isBond((DynamicObject)dataEntitys.get(0).getDataEntity())) {
            return dataEntitys;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        List loanBills = dataEntitys.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map map = RateAdjustBillRepository.getAuditDateLargeCreateTime(loanBills);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject loanBillDO = dataEntity.getDataEntity();
            if (((Boolean)map.get(loanBillDO.getLong("id"))).booleanValue()) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBillDO).getLbSubmitHaveRateAdjustBill());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }
}

