/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanFeeShareValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("org");
        sel.add("currency");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            boolean isHasCost;
            DynamicObject bill = dataEntity.getDataEntity();
            BigDecimal feeTotalAmt = CostShareServiceHelper.getFeeAmount((Long)bill.getLong("id"), (Long)bill.getDynamicObject("org").getLong("id"), (Long)bill.getDynamicObject("currency").getLong("id"), (String)"cfm");
            if (EmptyUtil.isEmpty((BigDecimal)feeTotalAmt)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u63d0\u6b3e\u5904\u7406\u644a\u9500\u603b\u989d\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (!(isHasCost = TmcDataServiceHelper.exists((String)"cfm_loanfeeshare", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", bill.getPkValue())}))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u63d0\u6b3e\u5904\u7406\u5df2\u5b58\u5728\u94f6\u884c\u63d0\u6b3e\u8d39\u7528\u644a\u9500\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

