/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanPush2RecValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("isrelcash");
        sel.add("billstatus");
        sel.add("confirmstatus");
        sel.add("isinit");
        sel.add("eassrcid");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isRelCash = bill.getBoolean("isrelcash");
            if (!isRelCash) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_1.loadKDString());
            }
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_3.loadKDString());
            }
            if (!ConfirmStatusEnum.isYetconfirm((String)bill.getString("confirmstatus"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_4.loadKDString());
            }
            if (bill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_2.loadKDString());
            }
            if (!EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) continue;
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.Push2RecValidator_6.loadKDString());
        }
    }
}

