/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;

public class ScheduleRateResetValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("datasource");
        selector.add("id");
        selector.add("sourcebillid");
        selector.add("drawtype");
        selector.add("interesttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(data.getString("datasource"));
            if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus"))) {
                this.addErrorMessage(entity, bizResource.getUnRateAdjustByStatusOp());
            }
            if (DrawTypeEnum.isCloseout((String)data.getString("drawtype"))) {
                this.addErrorMessage(entity, bizResource.getUnRateAdjustByDrawTypeOp());
            }
            if (InterestTypeEnum.isFloat((String)data.getString("interesttype"))) continue;
            this.addErrorMessage(entity, bizResource.getUnRateAdjustByInterestTypeOp());
        }
    }
}

