/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.business.validate.loanbill.LoanBillUnAuditOrComfirmValidator;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class loanBillUnAuditValidator
extends LoanBillUnAuditOrComfirmValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("contractbillno");
        sic.add("loancontractbill");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("renewalinterestrate");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("interesttype");
        sic.add("referencerate");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("ratetype");
        sic.add("renewalinteresttype");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("ratehistory_entry");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("confirmstatus");
        sic.add("renewalexpiredate");
        sic.add("isnofixedterm");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<ExtendedDataEntity> dataEntityList = this.validateBillHead(dataEntities);
        dataEntityList = this.validateUseByUnifyLoan(dataEntityList);
        dataEntityList = this.validateHasTargetBill(dataEntityList);
    }

    @Override
    protected List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        List<ExtendedDataEntity> dataEntitys = super.validateBillHead(dataEntities);
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanBill.getDynamicObjectCollection("ratehistory_entry"))) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getHaveRateAdjustBillCannotDO());
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)loanBill.getDate("renewalexpiredate")) && !loanBill.getBoolean("isnofixedterm")) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getHasExtendBillCannotDO());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateUseByUnifyLoan(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List billIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("unifyloanfrom_entry.e_loanbillid", "in", billIds);
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"unifyloanfrom_entry.e_loanbillid,billno", (QFilter[])qFilter.toArray());
        if (loanBills.isEmpty()) {
            return dataEntities;
        }
        Map loanBillMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("unifyloanfrom_entry.e_loanbillid"), Collectors.mapping(d -> d.getString("billno"), Collectors.toList())));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            List billNos = loanBillMap.get(loanBill.getLong("id"));
            if (EmptyUtil.isNoEmpty(billNos)) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.loanBillUnAuditValidator_0.loadKDString(String.join((CharSequence)",", billNos)));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateHasTargetBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        dataEntityList.addAll(this.validateForSettleCenter(dataEntities));
        dataEntityList.addAll(this.validateForNotSettleCenter(dataEntities));
        return dataEntityList;
    }

    private boolean isSettleCenter(DynamicObject loanBill) {
        return CreditorTypeEnum.SETTLECENTER.getValue().equals(loanBill.getString("creditortype"));
    }

    private List<ExtendedDataEntity> validateForSettleCenter(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List<ExtendedDataEntity> settleCenterDataEntitys = dataEntities.stream().filter(d -> this.isSettleCenter(d.getDataEntity())).collect(Collectors.toList());
        if (settleCenterDataEntitys.isEmpty()) {
            return settleCenterDataEntitys;
        }
        for (ExtendedDataEntity dataEntity : settleCenterDataEntitys) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            if (DataSourceEnum.isIfm((String)loanBill.getString("datasource")) && "cfm_loanbill".equals(loanBill.getDataEntityType().getName())) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getBillGenTypeMsg());
                continue;
            }
            dataEntitys.add(dataEntity);
        }
        if (EmptyUtil.isEmpty(dataEntitys)) {
            return dataEntitys;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List loanBills = BusinessHelper.getBills(dataEntitys);
        Map checkMap = BusinessHelper.checkTargetBillForInnerLoan((List)loanBills, this.getFilterMap(loanBills));
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            String msg = (String)checkMap.get(BusinessHelper.getBillId((ExtendedDataEntity)dataEntity));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private Map<String, QFilter> getFilterMap(List<DynamicObject> loanBills) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(2);
        filterMap.put(CfmEntityEnum.CAS_PAYBILL.getValue(), new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
        QFilter intFilter = new QFilter("instbillctg", "!=", (Object)InterestbillctgEnum.PREPAYINT.getValue());
        Pair intBotpPair = BatchIntBillHelper.getBatchIntBotpPair((String)loanBills.get(0).getString("datasource"));
        filterMap.put((String)intBotpPair.getValue(), intFilter);
        return filterMap;
    }

    private List<ExtendedDataEntity> validateForNotSettleCenter(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List<ExtendedDataEntity> checkDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List<ExtendedDataEntity> noSettleCenterDataEntitys = dataEntities.stream().filter(d -> !this.isSettleCenter(d.getDataEntity())).collect(Collectors.toList());
        if (noSettleCenterDataEntitys.isEmpty()) {
            return noSettleCenterDataEntitys;
        }
        for (ExtendedDataEntity dataEntity : noSettleCenterDataEntitys) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            if (!BusinessHelper.isOutGroup((DynamicObject)loanBill)) {
                if (!ConfirmStatusEnum.isWaitconfirm((String)loanBill.getString("confirmstatus"))) {
                    this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getUnauditConfirmStatus());
                    continue;
                }
                dataEntityList.add(dataEntity);
                continue;
            }
            if (!DrawTypeEnum.isDrawed((String)loanBill.getString("drawtype"))) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getCbUnauditLoanDrawType());
                continue;
            }
            checkDataEntitys.add(dataEntity);
        }
        if (EmptyUtil.isEmpty(checkDataEntitys)) {
            return dataEntityList;
        }
        checkDataEntitys = this.validateHasApplyLoanBill(checkDataEntitys);
        if (EmptyUtil.isNoEmpty(checkDataEntitys = this.validateHasRepayApplyBill(checkDataEntitys))) {
            List loanBills = BusinessHelper.getBills(checkDataEntitys);
            Map checkMap = BusinessHelper.checkTargetBillForNotInnerLoan((List)loanBills, this.getFilterMap(loanBills));
            for (ExtendedDataEntity dataEntity : checkDataEntitys) {
                String msg = (String)checkMap.get(dataEntity.getDataEntity().getLong("id"));
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.addErrorMessage(dataEntity, msg);
                    continue;
                }
                dataEntityList.add(dataEntity);
            }
        }
        return dataEntityList;
    }
}

