/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbillapply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(8);
        sic.add("applydate");
        sic.add("startintdate");
        sic.add("expiredate");
        sic.add("loanbillno");
        sic.add("loanbill");
        sic.add("datasource");
        sic.add("loancontractbill");
        sic.add("currency");
        sic.add("drawamount");
        sic.add("bizdate");
        sic.add("expiredate");
        sic.add("renewalexpiredate");
        sic.add("term");
        sic.add("repayplan_entry");
        sic.add("exrepaymentdate");
        sic.add("exdrawamount");
        sic.add("erepayamount");
        sic.add("repaystate");
        sic.add("seq");
        sic.add("interest_entry");
        sic.add("intstate");
        sic.add("interesdate");
        sic.add("interestcalamount");
        sic.add("intaccount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject onWayExtend;
            DynamicObject onWayAdjust;
            DynamicObject onWayRepay;
            DynamicObject onWayPreInt;
            DynamicObject onWayPreIntBatch;
            DynamicObject onWayPayInt;
            DynamicObject onWayPayIntBatch;
            DynamicObject onWayApply;
            DynamicObject applyBill = dataEntity.getDataEntity();
            DynamicObject loanContractBill = applyBill.getDynamicObject("loancontractbill");
            DynamicObject loanBill = applyBill.getDynamicObject("loanbill");
            if (EmptyUtil.isEmpty((DynamicObject)loanContractBill) || EmptyUtil.isEmpty((DynamicObject)loanBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u5355\u3002", (String)"LoanBillApplySubmitValidator_15", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            Date startIntDate = applyBill.getDate("startintdate");
            Date bizDate = applyBill.getDate("bizdate");
            String term = applyBill.getString("term");
            if (EmptyUtil.isEmpty((Object)startIntDate) || EmptyUtil.isEmpty((Object)bizDate) || EmptyUtil.isEmpty((String)term)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u671f\u3001\u5230\u671f\u65e5\u671f\u3001\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillApplySubmitValidator_18", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            Date startDate = loanContractBill.getDate("startdate");
            Date endDate = loanContractBill.getDate("enddate");
            if (startIntDate.compareTo(startDate) < 0 || startIntDate.compareTo(endDate) >= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\uff0c\u5c0f\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"LoanBillApplySubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            String loanBillNo = applyBill.getString("loanbillno");
            Long loanBillId = loanBill.getLong("id");
            if (!ConfirmStatusEnum.isYetconfirm((String)(loanBill = LoanBillRepository.getLoanBillById((Long)loanBillId)).getString("confirmstatus")) || !BillStatusEnum.isAudit((String)loanBill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LoanBillApplySubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo}));
            }
            String dateSource = loanBill.getString("datasource");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dateSource);
            if (!DrawTypeEnum.isDrawed((String)loanBill.getString("drawtype")) && !DrawTypeEnum.isPartpayment((String)loanBill.getString("drawtype"))) {
                this.addErrorMessage(dataEntity, bizResource.getLoanStatusByApply());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayApply = LoanBillApplyHelper.queryOnWayApplyById(loanBillId, applyBill.getLong("id"))))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u6216\u975e\u5df2\u529e\u7406\u7684\u53d8\u66f4\u5355\u636e%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayApply.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayPayIntBatch = LoanBillApplyHelper.queryOnWayPayIntBatch(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayPayIntBatch.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayPayInt = LoanBillApplyHelper.queryOnWayPayInt(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u4ed8\u606f/\u6536\u606f\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayPayInt.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayPreIntBatch = LoanBillApplyHelper.queryOnWayPreIntBatch(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u9884\u63d0\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_5", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayPreIntBatch.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayPreInt = LoanBillApplyHelper.queryOnWayPreInt(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u4ed8\u606f/\u6536\u606f\u9884\u63d0\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_6", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayPreInt.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayRepay = LoanBillApplyHelper.queryOnWayRepay(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_7", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayRepay.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayAdjust = LoanBillApplyHelper.queryOnWayAdjust(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5229\u7387\u8c03\u6574\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_8", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayAdjust.getString("billno")}));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(onWayExtend = LoanBillApplyHelper.queryOnWayExtend(loanBillId)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%1$s\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u5c55\u671f\u5355%2$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillApplySubmitValidator_9", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo, onWayExtend.getString("billno")}));
            }
            this.checkDateChange(dataEntity, loanBill, applyBill, loanBillNo);
            this.checkRepayPlanEntry(dataEntity, applyBill, bizResource);
            this.checkInstPlanEntry(dataEntity, applyBill, bizResource, dateSource);
            this.checkApplyDate(dataEntity, applyBill, loanBillNo);
        }
    }

    private void checkDateChange(ExtendedDataEntity dataEntity, DynamicObject loanBill, DynamicObject applyBill, String loanBillNo) {
        if (this.isDateChange(loanBill, applyBill)) {
            if (loanBill.getBoolean("isvoucher")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u8d77\u606f\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u3002", (String)"LoanBillApplySubmitValidator_10", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo}));
            }
            if (!EmptyUtil.isEmpty((Object)loanBill.getDate("lastrepaydate"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u7ecf\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u8d77\u606f\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u3002", (String)"LoanBillApplySubmitValidator_11", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo}));
            }
            if (!EmptyUtil.isEmpty((Object)loanBill.getDate("endinstdate"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u7ecf\u4ed8\u606f/\u6536\u606f\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u8d77\u606f\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u3002", (String)"LoanBillApplySubmitValidator_12", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo}));
            } else if (!EmptyUtil.isEmpty((Object)loanBill.getDate("endpreinstdate"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u7ecf\u9884\u63d0\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u8d77\u606f\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u3002", (String)"LoanBillApplySubmitValidator_13", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo}));
            }
            if (EmptyUtil.isNoEmpty((Object)loanBill.getDate("renewalexpiredate"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u7ecf\u5c55\u671f\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u8d77\u606f\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u3002", (String)"LoanBillApplySubmitValidator_14", (String)"tmc-cfm-business", (Object[])new Object[]{loanBillNo}));
            }
        }
    }

    private boolean isDateChange(DynamicObject loanBill, DynamicObject applyBill) {
        Date startIntDate = loanBill.getDate("startintdate");
        Date expireDate = loanBill.getDate("expiredate");
        Date startIntDate_a = applyBill.getDate("startintdate");
        Date expireDate_a = applyBill.getDate("expiredate");
        return startIntDate.compareTo(startIntDate_a) != 0 || expireDate.compareTo(expireDate_a) != 0;
    }

    private void checkRepayPlanEntry(ExtendedDataEntity dataEntity, DynamicObject applyBill, AbstractBizResource bizResource) {
        DynamicObjectCollection repayPlans = applyBill.getDynamicObjectCollection("repayplan_entry");
        Date bizDate = applyBill.getDate("bizdate");
        Date expireDate = applyBill.getDate("expiredate");
        Date extendDate = applyBill.getDate("renewalexpiredate");
        DynamicObject loanBill = applyBill.getDynamicObject("loanbill");
        Date lastRepayDate = loanBill.getDate("lastrepaydate");
        if (EmptyUtil.isNoEmpty((Object)extendDate)) {
            expireDate = extendDate;
        }
        BigDecimal exdrawamount = BigDecimal.ZERO;
        for (int i = 0; i < repayPlans.size(); ++i) {
            DynamicObject repayPlan = (DynamicObject)repayPlans.get(i);
            Date exRepaymentDate = repayPlan.getDate("exrepaymentdate");
            if (EmptyUtil.isEmpty((Object)exRepaymentDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getExRepaymentDateNull(), i + 1));
                return;
            }
            BigDecimal exDrawAmount = repayPlan.getBigDecimal("exdrawamount");
            BigDecimal repayAmount = repayPlan.getBigDecimal("erepayamount");
            if (EmptyUtil.isEmpty((BigDecimal)exDrawAmount)) {
                this.addErrorMessage(dataEntity, bizResource.getLbPreAmtIsNotnull());
            }
            DynamicObject currency = applyBill.getDynamicObject("currency");
            if (EmptyUtil.isNoEmpty((BigDecimal)repayAmount) && repayAmount.compareTo(exDrawAmount) > 0 && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                BigDecimal newRepayAmount = repayAmount.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreAmtIsLessYetAmt(), i + 1, newRepayAmount));
            }
            exdrawamount = exdrawamount.add(exDrawAmount);
            if (RepayStateEnum.isPayed((String)repayPlan.getString("repaystate"))) continue;
            if (exRepaymentDate.compareTo(bizDate) <= 0 || exRepaymentDate.compareTo(expireDate) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u653e\u6b3e\u65e5\u671f:%1$s\uff0c\u5c0f\u4e8e\u7b49\u4e8e\u5230\u671f\u65e5\u671f:%2$s\u3002", (String)"LoanBillApplySubmitValidator_16", (String)"tmc-cfm-business", (Object[])new Object[]{DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd")}));
            }
            if (!EmptyUtil.isNoEmpty((Object)lastRepayDate) || exRepaymentDate.compareTo(lastRepayDate) >= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u8fd1\u8fd8\u6b3e\u65e5:%1$s\u3002", (String)"LoanBillApplySubmitValidator_19", (String)"tmc-cfm-business", (Object[])new Object[]{DateUtils.formatString((Date)lastRepayDate, (String)"yyyy-MM-dd")}));
        }
        if (exdrawamount.compareTo(applyBill.getBigDecimal("drawamount")) != 0) {
            this.addErrorMessage(dataEntity, bizResource.getLbExdrawamountCheck());
        }
    }

    private void checkInstPlanEntry(ExtendedDataEntity dataEntity, DynamicObject applyBill, AbstractBizResource bizResource, String dateSource) {
        DynamicObjectCollection instPlans = applyBill.getDynamicObjectCollection("interest_entry");
        Date bizDate = applyBill.getDate("bizdate");
        HashSet<Date> dateSet = new HashSet<Date>(16);
        for (int i = 0; i < instPlans.size(); ++i) {
            BigDecimal calInstAmount;
            DynamicObject rowLoanBill = (DynamicObject)instPlans.get(i);
            if (rowLoanBill.getInt("intstate") == 1) continue;
            Date interesDate = rowLoanBill.getDate("interesdate");
            if (EmptyUtil.isEmpty((Object)interesDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreInstDateIsNotnull(), i + 1));
                continue;
            }
            if (interesDate.compareTo(bizDate) < 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8/\u6536\u606f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u653e\u6b3e\u65e5\u671f:%s\u3002", (String)"LoanBillInstPlanSaveValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]), DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd")));
            }
            if (!dateSet.add(interesDate)) {
                this.addErrorMessage(dataEntity, bizResource.getLbExInstdateCheck());
            }
            if (EmptyUtil.isEmpty((BigDecimal)(calInstAmount = rowLoanBill.getBigDecimal("interestcalamount")))) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreInstAmtIsNotnull(), i + 1));
            } else if (calInstAmount.compareTo(new BigDecimal("9999999999999.9999")) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91d1\u989d\u6570\u503c\u4e0d\u80fd\u5927\u4e8e9999999999999.9999\u3002", (String)"LoanBillInstPlanSaveValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            DynamicObject intAccount = rowLoanBill.getDynamicObject("intaccount");
            if (!EmptyUtil.isEmpty((DynamicObject)intAccount) || DataSourceEnum.isInvest((String)dateSource)) continue;
            this.addErrorMessage(dataEntity, String.format(bizResource.getLbPreInstAccountIsNotnull(), i + 1));
        }
    }

    private void checkApplyDate(ExtendedDataEntity dataEntity, DynamicObject applyBill, String loanBillNo) {
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"cfm_apply_loanbill", (String)"applydate", (QFilter[])new QFilter[]{new QFilter("loanbillno", "=", (Object)loanBillNo).and("bizstatus", "=", (Object)ApplyBusinessStatusEnum.HANDED.getValue())}, (String)"modifytime desc", (int)1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)applyBills)) {
            return;
        }
        Date applyDate = applyBill.getDate("applydate");
        Date LastApplyDate = ((DynamicObject)applyBills.get(0)).getDate("applydate");
        if (EmptyUtil.isEmpty((Object)applyDate) || EmptyUtil.isEmpty((Object)LastApplyDate)) {
            return;
        }
        if (applyDate.compareTo(LastApplyDate) <= 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u6b21\u7533\u8bf7\u65e5\u671f:%1$s\u3002", (String)"LoanBillApplySubmitValidator_17", (String)"tmc-cfm-business", (Object[])new Object[]{DateUtils.formatString((Date)LastApplyDate, (String)"yyyy-MM-dd")}));
        }
    }
}

