/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbillapply;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoanBillApplyUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("loanbillno");
        sl.add("loanbill");
        sl.add("bizstatus");
        sl.add("modifytime");
        sl.add("creditortype");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            String loanBillNo = applyBill.getString("loanbillno");
            DynamicObject loanBill = applyBill.getDynamicObject("loanbill");
            Long loanBillId = loanBill.getLong("id");
            if (this.checkTargetBills(dataEntity, applyBill)) continue;
            DynamicObject onWayApply = LoanBillApplyHelper.queryOnWayApplyById(loanBillId, applyBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)onWayApply)) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_2.loadKDString(loanBillNo));
                continue;
            }
            DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"cfm_apply_loanbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("loanbillno", "=", (Object)loanBillNo)}, (String)"modifytime desc", (int)1);
            if (!applyBill.get("id").equals(((DynamicObject)applyBills.get(0)).get("id"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_1.loadKDString(loanBillNo));
            }
            this.checkAfterChgBill(dataEntity, applyBill, loanBillId, loanBillNo);
        }
    }

    private boolean checkTargetBills(ExtendedDataEntity dataEntity, DynamicObject applyBill) {
        String checkTargetBillsMsg;
        String creditorType = applyBill.getString("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType) && StringUtils.isNotBlank((CharSequence)(checkTargetBillsMsg = BusinessHelper.checkTargetBills((String)applyBill.getDataEntityType().getName(), (Long)applyBill.getLong("id"), null)))) {
            this.addErrorMessage(dataEntity, checkTargetBillsMsg);
            return true;
        }
        return false;
    }

    private void checkAfterChgBill(ExtendedDataEntity dataEntity, DynamicObject applyBill, Long loanBillId, String loanBillNo) {
        DynamicObject afterChgAdjust;
        DynamicObject afterChgExtend;
        DynamicObject afterChgPreInt;
        DynamicObject afterChgPreIntBatch;
        DynamicObject afterChgPayInt;
        DynamicObject afterChgPayIntBatch;
        Date modifyTime = applyBill.getDate("modifytime");
        DynamicObject repaymentBill = RepaymentBillRepository.getAfterChgRepaymentBill((Long)loanBillId, (Date)modifyTime);
        if (EmptyUtil.isNoEmpty((DynamicObject)repaymentBill)) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_3.loadKDString(loanBillNo, repaymentBill.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPayIntBatch = LoanBillApplyHelper.queryAfterChgPayIntBatch(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_4.loadKDString(loanBillNo, afterChgPayIntBatch.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPayInt = LoanBillApplyHelper.queryAfterChgPayInt(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_5.loadKDString(loanBillNo, afterChgPayInt.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPreIntBatch = LoanBillApplyHelper.queryAfterChgPreIntBatch(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_6.loadKDString(loanBillNo, afterChgPreIntBatch.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPreInt = LoanBillApplyHelper.queryAfterChgPreInt(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_7.loadKDString(loanBillNo, afterChgPreInt.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgExtend = LoanBillApplyHelper.queryAfterChgExtend(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_8.loadKDString(loanBillNo, afterChgExtend.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgAdjust = LoanBillApplyHelper.queryAfterChgAdjust(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanBillApplyUnAuditValidator_9.loadKDString(loanBillNo, afterChgAdjust.getString("billno")));
        }
    }
}

