/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BillTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillEndValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("billno");
        sl.add("contractstatus");
        sl.add("datasource");
        sl.add("ishandend");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject contractBill = dataEntity.getDataEntity();
            String cDataSource = contractBill.getString("datasource");
            BizResourceFactory factory = new BizResourceFactory();
            AbstractBizResource cBizResource = factory.getBizResource(cDataSource);
            String contractStatus = contractBill.getString("contractstatus");
            List<String> contractStatusList = Arrays.asList(LoanContractStatusEnum.EXECUTING.getValue(), LoanContractStatusEnum.REGISTERED.getValue());
            if (!contractStatusList.contains(contractStatus)) {
                this.addErrorMessage(dataEntity, String.format(cBizResource.checkContractBillsConfirmStatus(), contractBill.getString("billno")));
                continue;
            }
            String contractBillFormId = (String)this.getOption().getVariables().get("CONTRACTBILL_FORMID");
            if (EmptyUtil.isEmpty((String)contractBillFormId)) {
                contractBillFormId = contractBill.getDataEntityType().getName();
            }
            if (!CfmContractBillHelper.isCanOpContract((String)cDataSource, (String)contractBillFormId)) {
                this.addErrorMessage(dataEntity, String.format(cBizResource.checkContractBillsOpSite(), DataSourceEnum.getName((String)cDataSource)));
                continue;
            }
            QFilter idQFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
            DynamicObjectCollection allextBills = QueryServiceHelper.query((String)"cfm_contractextendbill", (String)"id,datasource,billno,confirmstatus,billstatus", (QFilter[])new QFilter[]{idQFilter});
            for (DynamicObject allextBill : allextBills) {
                AbstractBizResource bizResource = factory.getBizResource(allextBill.getString("datasource"));
                if (BillStatusEnum.AUDIT.getValue().equals(allextBill.getString("billstatus")) && allextBill.getString("confirmstatus").equals(ConfirmStatusEnum.YETCONFIRM.getValue())) continue;
                this.addErrorMessage(dataEntity, String.format(bizResource.checkExtBillsConfirmStatus(), allextBill.getString("billno")));
            }
            DynamicObjectCollection allLoanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,datasource,billno,confirmstatus,billstatus", (QFilter[])new QFilter[]{idQFilter});
            HashSet<Long> loanIds = new HashSet<Long>(allLoanBills.size());
            for (DynamicObject loanBill : allLoanBills) {
                loanIds.add(loanBill.getLong("id"));
                AbstractBizResource bizResource = factory.getBizResource(loanBill.getString("datasource"));
                if (BillStatusEnum.AUDIT.getValue().equals(loanBill.getString("billstatus")) && loanBill.getString("confirmstatus").equals(ConfirmStatusEnum.YETCONFIRM.getValue())) continue;
                this.addErrorMessage(dataEntity, String.format(bizResource.checkLoanBillsConfirmStatus(), loanBill.getString("billno")));
            }
            QFilter repayQFilter = new QFilter("loans.e_loanbill", "in", loanIds).and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())));
            DynamicObjectCollection repayBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id,datasource,billno,confirmstatus,billstatus", (QFilter[])new QFilter[]{repayQFilter});
            for (DynamicObject repayBill : repayBills) {
                AbstractBizResource bizResource = factory.getBizResource(repayBill.getString("datasource"));
                this.addErrorMessage(dataEntity, String.format(bizResource.checkRepayBillsConfirmStatus(), repayBill.getString("billno")));
            }
            QFilter instQFilter = new QFilter("sourcebillid", "in", loanIds).and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())));
            DynamicObjectCollection instBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,datasource,billno,confirmstatus,billstatus", (QFilter[])new QFilter[]{instQFilter});
            for (DynamicObject instBill : instBills) {
                AbstractBizResource bizResource = factory.getBizResource(instBill.getString("datasource"));
                this.addErrorMessage(dataEntity, String.format(bizResource.checkInstBillsConfirmStatus(), instBill.getString("billno")));
            }
            QFilter batchInstQFilter = new QFilter("entry.loanbillid", "in", loanIds).and(new QFilter("biztype", "=", (Object)BillTypeEnum.LOAN.getValue())).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            DynamicObjectCollection batchInstBills = QueryServiceHelper.query((String)"cfm_intbill_batch_loan", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{batchInstQFilter});
            for (DynamicObject batchInstBill : batchInstBills) {
                AbstractBizResource bizResource = factory.getBizResource("");
                this.addErrorMessage(dataEntity, String.format(bizResource.checkBatchInstBillsConfirmStatus(), batchInstBill.getString("billno")));
            }
            QFilter batchPreInstQFilter = new QFilter("entry.loanbillid", "in", loanIds).and(new QFilter("biztype", "=", (Object)BillTypeEnum.PREINT.getValue())).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            DynamicObjectCollection batchPreInstBills = QueryServiceHelper.query((String)"cfm_intbill_batch_pre", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{batchPreInstQFilter});
            for (DynamicObject batchPreInstBill : batchPreInstBills) {
                AbstractBizResource bizResource = factory.getBizResource("");
                this.addErrorMessage(dataEntity, String.format(bizResource.checkBatchPreInstBillsConfirmStatus(), batchPreInstBill.getString("billno")));
            }
        }
    }
}

