/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loancontractbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoanContractBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("billstatus");
        sic.add("contractstatus");
        sic.add("creditorg");
        sic.add("org");
        sic.add("productfactory");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("loantype");
        sic.add("rateadjustcycletype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String checkTargetBillsMsg;
            DynamicObject loanContractBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanContractBill.getString("datasource"));
            String billStatus = loanContractBill.getString("billstatus");
            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)billStatus)) continue;
            if (loanContractBill.getBoolean("isinit") && !"fl_leasecontractbill_init".equals(loanContractBill.getDataEntityType().getName())) {
                this.addErrorMessage(dataEntity, bizResource.getCbUnauditContractInit());
                continue;
            }
            String entityName = loanContractBill.getDataEntityType().getName();
            String creditorType = loanContractBill.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType) && "cfm_loancontractbill".equals(entityName)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u5408\u540c\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u3002", (String)"LoanContractBillUnAuditValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            boolean isFinLeaseType = this.isFinLeaseType(loanContractBill);
            HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>();
            if (isFinLeaseType) {
                filterMap.put("fl_receiptbill", new QFilter("id", "=", (Object)0));
            }
            if (StringUtils.isNotBlank((CharSequence)(checkTargetBillsMsg = BusinessHelper.checkTargetBills((String)loanContractBill.getDataEntityType().getName(), (Long)loanContractBill.getLong("id"), filterMap)))) {
                this.addErrorMessage(dataEntity, checkTargetBillsMsg);
                continue;
            }
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType) || BusinessHelper.isOutGroup((DynamicObject)loanContractBill)) {
                String contractStatus = loanContractBill.getString("contractstatus");
                if (!isFinLeaseType && !StringUtils.equals((CharSequence)LoanContractStatusEnum.REGISTERED.getValue(), (CharSequence)contractStatus)) {
                    this.addErrorMessage(dataEntity, bizResource.getCbUnauditContractStatus());
                }
            } else {
                String confirmStatus = loanContractBill.getString("confirmstatus");
                if (!ConfirmStatusEnum.WAITCONFIRM.getValue().equals(confirmStatus)) {
                    this.addErrorMessage(dataEntity, bizResource.getUnauditConfirmStatus());
                }
            }
            this.validateDrawApply(dataEntity);
        }
    }

    private boolean isFinLeaseType(DynamicObject loanContractBill) {
        String entityName = loanContractBill.getDynamicObjectType().getName();
        String loanType = loanContractBill.getString("loantype");
        if (("fl_leasecontractbill".equals(entityName) || "fl_leasecontractbill_init".equals(entityName)) && LoanTypeEnum.isFinLease((String)loanType)) {
            DynamicObject contract = QueryServiceHelper.queryOne((String)"fl_leasecontractbill", (String)"finproduct.financeleasetype as type,isinit", (QFilter[])new QFilter("id", "=", loanContractBill.getPkValue()).toArray());
            String finLeaseType = contract.getString("type");
            return StringUtils.equals((CharSequence)finLeaseType, (CharSequence)"financelease") || contract.getBoolean("isinit");
        }
        return false;
    }

    private void validateDrawApply(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        QFilter applyFilter = new QFilter("loancontractbill", "=", contractBill.getPkValue());
        DynamicObjectCollection drawApplyBills = QueryServiceHelper.query((String)"cfm_draw_apply", (String)"billno", (QFilter[])applyFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)drawApplyBills)) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanContractBillUnAuditValidator_2.loadKDString(((DynamicObject)drawApplyBills.get(0)).getString("billno")));
        }
    }
}

