/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("contractbillno");
        sic.add("loanbillno");
        sic.add("billstatus");
        sic.add("prestenddate");
        sic.add("operatetype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource("");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preInterestBill = dataEntity.getDataEntity();
            if (LoanBillHelper.isCorrectPreIntBill((DynamicObject)preInterestBill)) continue;
            String billstatus = preInterestBill.getString("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billstatus)) {
                return;
            }
            String contractBillNo = preInterestBill.getString("contractbillno");
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"id,billno,ishandend,contractstatus", (QFilter[])new QFilter("billno", "=", (Object)contractBillNo).toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBill) && contractBill.getBoolean("ishandend") && LoanContractStatusEnum.CLOSED.getValue().equals(contractBill.getString("contractstatus"))) {
                String contractNum = contractBill.getString("billno");
                this.addErrorMessage(dataEntity, String.format(bizResource.getIbUnOpContractByHandEnd(), contractNum));
            }
            String loanbillno = preInterestBill.getString("loanbillno");
            QFilter loanbillnoFilter = new QFilter("loanbillno", "=", (Object)loanbillno);
            loanbillnoFilter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue()));
            CharSequence[] preInterestBillSelectProps = new String[]{"id", "prestartdate"};
            DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)String.join((CharSequence)",", preInterestBillSelectProps), (QFilter[])new QFilter[]{loanbillnoFilter}, (String)"prestartdate  desc, createtime  desc");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)preInterestBills) || ((DynamicObject)preInterestBills.get(0)).get("id").equals(preInterestBill.getPkValue())) continue;
            this.addErrorMessage(dataEntity, bizResource.getPbDeleteCheckprelast());
        }
    }
}

