/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("actpreinstamt");
        sic.add("expiredate");
        sic.add("afterexpiredate");
        sic.add("creditortype");
        sic.add("datasource");
        sic.add("org");
        sic.add("sourcebillid");
        sic.add("loanbillno");
        sic.add("id");
        sic.add("bizdate");
        sic.add("operatetype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preInterestEntity = dataEntity.getDataEntity();
            AbstractBizResource cfmBizResource = new BizResourceFactory().getBizResource(preInterestEntity.getString("datasource"));
            Date prestartdate = preInterestEntity.getDate("prestartdate");
            Date prestenddate = preInterestEntity.getDate("prestenddate");
            if (EmptyUtil.isNoEmpty((Object)prestartdate) && EmptyUtil.isNoEmpty((Object)prestenddate) && prestartdate.compareTo(prestenddate) >= 0) {
                this.addErrorMessage(dataEntity, cfmBizResource.getPbSaveEndmoreStartValidator());
            }
            this.validateActPreInstAmt(dataEntity);
            this.validatePreIntSource(dataEntity);
            long loanBillId = preInterestEntity.getLong("sourcebillid");
            long preintpk = preInterestEntity.getLong("id");
            String loanBillno = preInterestEntity.getString("loanbillno");
            boolean autoRedWriteOff = LoanBillHelper.isNeedAutoRedWriteOff((DynamicObject)preInterestEntity);
            List result = InterestValidateHelper.preIntValidate((Date)prestartdate, (Date)prestenddate, (Long)loanBillId, (boolean)autoRedWriteOff, (Long)preintpk, (String)loanBillno, (AbstractBizResource)cfmBizResource);
            for (ValidateBean p : result) {
                this.addMessage(dataEntity, p.getErrorInfo(), p.isError() ? ErrorLevel.Error : ErrorLevel.Warning);
            }
        }
    }

    protected void validateActPreInstAmt(ExtendedDataEntity dataEntity) {
        DynamicObject preInstData = dataEntity.getDataEntity();
        String operateType = preInstData.getString("operatetype");
        BigDecimal actPreInstAmt = preInstData.getBigDecimal("actpreinstamt");
        if (!StringUtils.equals((CharSequence)PreIntOperateTypeEnum.REVERSEINT.getValue(), (CharSequence)operateType) && null != actPreInstAmt && actPreInstAmt.compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u9645\u9884\u63d0\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"PreInstBillSaveValidator_1", (String)"", (Object[])new Object[0]));
        }
    }

    private void validatePreIntSource(ExtendedDataEntity dataEntity) {
        DynamicObject preInterest = dataEntity.getDataEntity();
        String creditorType = preInterest.getString("creditortype");
        String dataSource = preInterest.getString("datasource");
        if (StringUtils.equals((CharSequence)CreditorTypeEnum.SETTLECENTER.getValue(), (CharSequence)creditorType) && StringUtils.equals((CharSequence)DataSourceEnum.CFM.getValue(), (CharSequence)dataSource)) {
            DynamicObject org = preInterest.getDynamicObject("org");
            if (EmptyUtil.isEmpty((DynamicObject)org)) {
                return;
            }
            if (CfmSysParamHelper.getAppBoolParameter((long)org.getLong("id"), (String)"cfm003")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7531\u7ed3\u7b97\u4e2d\u5fc3\u53d1\u8d77\u9884\u63d0\u3002", (String)"PreInstBillSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }
}

