/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.validate.preinterestbill.PreInstBillSaveValidator;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillSubmitValidator
extends PreInstBillSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("sourcebillid");
        sic.add("id");
        sic.add("bizdate");
        sic.add("org");
        sic.add("creditorg");
        sic.add("predictpreinstamt");
        sic.add("actpreinstamt");
        return sic;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Map opMap = this.getOption().getVariables();
        if (opMap.containsKey("redwriteoffop")) {
            return;
        }
        String currBillAppId = Optional.ofNullable(opMap.get("appid")).orElse("");
        Map repeatLoanMap = InterestValidateHelper.valiRepeatSubmit((ExtendedDataEntity[])dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long orgId;
            boolean isPayIntControl;
            long loanBillId;
            DynamicObject preInterestEntity = dataEntity.getDataEntity();
            AbstractBizResource cfmBizResource = new BizResourceFactory().getBizResource(preInterestEntity.getString("datasource"));
            Date startinstdate = preInterestEntity.getDate("prestartdate");
            Date endinstdate = preInterestEntity.getDate("bizdate");
            BigDecimal actualInstAmt = preInterestEntity.getBigDecimal("actpreinstamt");
            if (EmptyUtil.isEmpty((BigDecimal)actualInstAmt)) {
                this.addErrorMessage(dataEntity, cfmBizResource.getPbActpreinstamtMustmorezore());
            }
            if (repeatLoanMap.containsKey(loanBillId = preInterestEntity.getLong("sourcebillid"))) {
                this.addErrorMessage(dataEntity, cfmBizResource.getPbRepeatloanbillSumbit());
            }
            this.validateActPreInstAmt(dataEntity);
            String loanBillno = preInterestEntity.getString("loanbillno");
            long preintpk = preInterestEntity.getLong("id");
            boolean autoRedWriteOff = LoanBillHelper.isNeedAutoRedWriteOff((DynamicObject)preInterestEntity);
            if (TmcAppEnum.CIM.getValue().equals(currBillAppId) || "ifm_depositpreint".equals(preInterestEntity.getDynamicObjectType().getName())) {
                String param = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.CIM.getId(), (long)preInterestEntity.getLong("org_id"), (String)"autoredwriteoff");
                autoRedWriteOff = EmptyUtil.isNoEmpty((String)param) && StringUtils.equals((CharSequence)param, (CharSequence)"true");
            }
            List result = InterestValidateHelper.preIntValidate((Date)startinstdate, (Date)endinstdate, (Long)loanBillId, (boolean)autoRedWriteOff, (Long)preintpk, (String)loanBillno, (AbstractBizResource)cfmBizResource);
            for (ValidateBean p : result) {
                this.addMessage(dataEntity, p.getErrorInfo(), p.isError() ? ErrorLevel.Error : ErrorLevel.Warning);
            }
            DynamicObject org = preInterestEntity.getDynamicObject("org");
            if (DataSourceEnum.isInvest((String)preInterestEntity.getString("datasource"))) {
                org = preInterestEntity.getDynamicObject("creditorg");
            }
            if (EmptyUtil.isEmpty((DynamicObject)org) || !(isPayIntControl = CfmSysParamHelper.getAppBoolParameter((long)(orgId = org.getLong("id")), (String)"cfm007"))) continue;
            BigDecimal controlAmt = CfmSysParamHelper.getAppBigDecimalParameter((long)orgId, (String)"cfm008");
            BigDecimal predictInstAmt = preInterestEntity.getBigDecimal("predictpreinstamt");
            BigDecimal convertIntAmt = preInterestEntity.getBigDecimal("actpreinstamt");
            BigDecimal abs = convertIntAmt.subtract(predictInstAmt).abs().setScale(2, RoundingMode.HALF_UP);
            if (abs.compareTo(controlAmt) <= 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u9884\u63d0\u5229\u606f\u4e0e\u6d4b\u7b97\u9884\u63d0\u5229\u606f\u4e4b\u5dee\u7edd\u5bf9\u503c%1$s\u4e0d\u80fd\u5927\u4e8e\u53c2\u6570\u8bbe\u7f6e\u7684\u5141\u8bb8\u504f\u5dee\u91d1\u989d%2$s\uff0c\u8bf7\u4fee\u6539\u5b9e\u9645\u9884\u63d0\u5229\u606f\u3002", (String)"PreInstBillSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), abs, controlAmt));
            return;
        }
    }
}

