/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillUnSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("loanbillno");
        sic.add("billstatus");
        sic.add("prestenddate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        AbstractBizResource cfmBizResource = new BizResourceFactory().getBizResource("");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preInterestEntity = dataEntity.getDataEntity();
            String billstatus = preInterestEntity.getString("billstatus");
            if (!BillStatusEnum.SUBMIT.getValue().equals(billstatus)) {
                return;
            }
            CharSequence[] preInterestBillSelectProps = new String[]{"id", "prestartdate"};
            String loanbillno = preInterestEntity.getString("loanbillno");
            QFilter loanbillnoFilter = new QFilter("loanbillno", "=", (Object)loanbillno);
            loanbillnoFilter.and(new QFilter("operatetype", "!=", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue()));
            DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)String.join((CharSequence)",", preInterestBillSelectProps), (QFilter[])new QFilter[]{loanbillnoFilter}, (String)"prestartdate  desc, createtime  desc");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)preInterestBills) || ((DynamicObject)preInterestBills.get(0)).get("id").equals(preInterestEntity.getPkValue())) continue;
            this.addErrorMessage(dataEntity, cfmBizResource.getPbUnsumbitCheckprelast());
        }
    }
}

