/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.preinterestbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class PreIntBillBathPushValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("intdetail_tag");
        selector.add("entry");
        selector.add("inttype");
        selector.add("bizdate");
        selector.add("inneracct");
        selector.add("currency");
        selector.add("rate");
        selector.add("settlecenter");
        selector.add("sourceentryid");
        selector.add("operateType");
        selector.add("startdate");
        selector.add("intbillid");
        selector.add("intdetailnum");
        selector.add("actualinstamt");
        selector.add("enddate");
        selector.add("loanbillid");
        selector.add("settlecenter");
        selector.add("intcomment");
        selector.add("loannum");
        selector.add("interestamt");
        selector.add("preintdate");
        selector.add("status");
        selector.add("datasource");
        selector.add("loantype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (dataEntity.length > 1) {
            this.addErrorMessage(dataEntity[0], ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PreIntBillBathPushValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        DynamicObject preIntBill = dataEntity[0].getDataEntity();
        if (!BillStatusEnum.AUDIT.getValue().equals(preIntBill.getString("billstatus"))) {
            this.addErrorMessage(dataEntity[0], ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u4e0b\u63a8\u3002", (String)"PreIntBillBathPushValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = preIntBill.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> canPushEntrys = new ArrayList<DynamicObject>(entrys.size());
        for (DynamicObject entry : entrys) {
            String status = entry.getString("status");
            if (!"fail".equals(status)) continue;
            canPushEntrys.add(entry);
        }
        if (canPushEntrys.size() == 0) {
            this.addErrorMessage(dataEntity[0], ResManager.loadKDString((String)"\u6240\u6709\u7684\u5185\u90e8\u5b58\u6b3e\u9884\u63d0\u5904\u7406\u5355\u5df2\u6210\u529f\u4e0b\u63a8\u6216\u672a\u63d0\u4ea4\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PreIntBillBathPushValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

