/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.productfactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ProductFactorySaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("currencyrule");
        selector.add("currency");
        selector.add("number");
        selector.add("repaymentmode");
        selector.add("isrepayplan");
        selector.add("settleintmode");
        selector.add("biztype");
        selector.add("creditortype");
        selector.add("isloancommit");
        selector.add("iscycleloan");
        selector.add("islkbizprop");
        selector.add("isslinfo");
        selector.add("istradefininfo");
        selector.add("isscminfo");
        selector.add("isprojectinfo");
        selector.add("ratetype");
        selector.add("rateadjustmethod");
        selector.add("rateresetdays");
        selector.add("iscandefer");
        selector.add("defermaxcount");
        selector.add("iscanoverterm");
        selector.add("finproduct");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource("");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String settleMode;
            Integer days;
            String adjustMethod;
            String rateType;
            String creditorType;
            String bizType;
            DynamicObjectCollection currencys;
            String rule;
            Boolean isRef;
            DynamicObject data = dataEntity.getDataEntity();
            QFilter notMeFilter = new QFilter("id", "!=", data.getPkValue()).and(new QFilter("number", "=", (Object)data.getString("number")));
            String entryName = data.getDataEntityType().getName();
            if (!"cfm_productfactory".equals(entryName)) {
                notMeFilter.and(new QFilter("biztype", "=", (Object)BizTypeEnum.BOND.getValue()));
            } else {
                notMeFilter.and(new QFilter("biztype", "!=", (Object)BizTypeEnum.BOND.getValue()));
            }
            boolean existCompCreditType = TmcDataServiceHelper.exists((String)entryName, (QFilter[])new QFilter[]{notMeFilter});
            if (existCompCreditType) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u578b\u4ee3\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((Object)data.getPkValue()) && 0L != (Long)data.getPkValue() && (isRef = Boolean.valueOf(BaseDataRefrenceHelper.isRefrenced((String)"cfm_productfactory", (Object)data.getPkValue()))).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u91cd\u590d\u5bfc\u5165\u3002", (String)"ProductFactorySaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if ("assigncurrency".equals(rule = data.getString("currencyrule")) && ((currencys = data.getDynamicObjectCollection("currency")) == null || currencys.size() == 0)) {
                this.addErrorMessage(dataEntity, bizResource.getProductFactorySaveVolidError());
            }
            String repayMode = data.getString("repaymentmode");
            if ((RepaymentWayEnum.debx.getValue().equals(repayMode) || RepaymentWayEnum.debj.getValue().equals(repayMode) || RepaymentWayEnum.dbdx.getValue().equals(repayMode)) && !data.getBoolean("isrepayplan")) {
                this.addErrorMessage(dataEntity, bizResource.getProductFactoryPayPlanVolidError());
            }
            if (ProductFactorySaveValidator.checkCreditorType(bizType = data.getString("biztype"), creditorType = data.getString("creditortype")).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u3010\u4e1a\u52a1\u5206\u7c7b\u3011\u4e0e\u3010\u503a\u6743\u4eba\u7c7b\u578b\u3011\u5173\u8054\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (ProductFactorySaveValidator.checkRateResetDays(rateType = data.getString("ratetype"), adjustMethod = data.getString("rateadjustmethod"), days = Integer.valueOf(data.getInt("rateresetdays"))).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u5229\u7387\u7c7b\u578b\u3011\u4e3a\u6d6e\u52a8\u5229\u7387\u5e76\u4e14\u3010\u5229\u7387\u91cd\u7f6e\u65b9\u5f0f\u3011\u4e3a\u5468\u671f\u6027\u91cd\u7f6e\u65f6\uff0c\u3010\u5229\u7387\u91cd\u7f6e\u504f\u79fb\uff08d\uff09\u3011\u8f93\u5165\u503c\u624d\u80fd\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            Boolean isCanDefer = data.getBoolean("iscandefer");
            Integer deferMaxCount = data.getInt("defermaxcount");
            Boolean isCanOver = data.getBoolean("iscanoverterm");
            if (!isCanDefer.booleanValue() && deferMaxCount > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u5141\u8bb8\u5c55\u671f\u3011\u4e3a\u662f\u65f6\uff0c\u3010\u5c55\u671f\u6700\u5927\u6b21\u6570\u3011\u8f93\u5165\u503c\u624d\u80fd\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (!isCanDefer.booleanValue() && isCanOver.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u5141\u8bb8\u5c55\u671f\u3011\u4e3a\u662f\u65f6\uff0c\u3010\u5141\u8bb8\u5c55\u671f\u671f\u9650\u8d85\u8fc7\u8d37\u6b3e\u671f\u9650\u3011\u624d\u80fd\u4e3a\u662f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (ProductFactorySaveValidator.checkSettleMode(repayMode, settleMode = data.getString("settleintmode")).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u3010\u7ed3\u606f\u65b9\u5f0f\u3011\u4e0e\u3010\u8fd8\u6b3e\u65b9\u5f0f\u3011\u5173\u8054\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            Boolean isLkbiz = data.getBoolean("islkbizprop");
            Boolean isSlInfo = data.getBoolean("isslinfo");
            Boolean isTradeFinInfo = data.getBoolean("istradefininfo");
            Boolean isScmInfo = data.getBoolean("isscminfo");
            Boolean isProjectInfo = data.getBoolean("isprojectinfo");
            if (isLkbiz.booleanValue() || !isSlInfo.booleanValue() && !isTradeFinInfo.booleanValue() && !isScmInfo.booleanValue() && !isProjectInfo.booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u3010\u5173\u8054\u4e1a\u52a1\u4fe1\u606f\u3011\u4e3a\u5426\u65f6\uff0c\u3010\u94f6\u56e2\u4fe1\u606f\u3011\u3001\u3010\u8d38\u878d\u4fe1\u606f\u3011\u3001\u3010\u4f9b\u5e94\u94fe\u4fe1\u606f\u3011\u3001\u3010\u9879\u76ee\u4fe1\u606f\u3011\u5747\u4e3a\u5426\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductFactorySaveValidator_10", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private static Boolean checkCreditorType(String bizType, String creditorType) {
        if (EmptyUtil.isEmpty((String)creditorType)) {
            return false;
        }
        List<String> finOrges = Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue());
        List<String> noFinOrges = Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue());
        if (BizTypeEnum.LOAN.getValue().equals(bizType) || BizTypeEnum.SL.getValue().equals(bizType)) {
            return !finOrges.contains(creditorType);
        }
        if (BizTypeEnum.ENTRUST.getValue().equals(bizType) || BizTypeEnum.EC.getValue().equals(bizType)) {
            return !noFinOrges.contains(creditorType);
        }
        return false;
    }

    private static Boolean checkSettleMode(String repaymentMode, String settleMode) {
        ArrayList<String> lsbqList = new ArrayList<String>(Arrays.asList(RepaymentWayEnum.bqhblsbq.getValue(), RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue()));
        if (lsbqList.contains(repaymentMode) && !SettleIntModeEnum.lsbq.getValue().equals(settleMode)) {
            return true;
        }
        ArrayList<String> fixedList = new ArrayList<String>(Arrays.asList(RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue()));
        if (fixedList.contains(repaymentMode) && !SettleIntModeEnum.gdpljx.getValue().equals(settleMode)) {
            return true;
        }
        return false;
    }

    private static Boolean checkRateResetDays(String rateType, String adjustMethod, Integer days) {
        if (days > 0) {
            List<String> resetDayStyles = Arrays.asList(RateAdjustStyleEnum.CYCLE.getValue(), RateAdjustStyleEnum.AFTERINT.getValue());
            return InterestTypeEnum.FIXED.getValue().equals(rateType) || !resetDayStyles.contains(adjustMethod);
        }
        return false;
    }
}

