/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.rateadjust;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("billstatus");
        sic.add("loancontractbill");
        sic.add("adjustele");
        sic.add("refrate");
        sic.add("rateadjustkey");
        sic.add("rateadjustval");
        sic.add("ratesign");
        sic.add("interestrate");
        sic.add("ratefloatpoint");
        sic.add("afterrefrate");
        sic.add("afterrateadjustkey");
        sic.add("afterrateadjustval");
        sic.add("afterratesign");
        sic.add("afterinterestrate");
        sic.add("afterratefloatpoint");
        sic.add("adjusteffectdate");
        sic.add("datasource");
        sic.add("isadjusttofloat");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("settleintmode");
        sic.add("interestsettledplan");
        sic.add("entry");
        sic.add("entry.lloanrate");
        sic.add("entry.lratesign");
        sic.add("entry.lratefloatpoint");
        sic.add("entry.afterlloanrate");
        sic.add("entry.afterlratesign");
        sic.add("entry.afterlratefloatpoint");
        sic.add("entry.ldrawbill");
        sic.add("entry.lisadjust");
        sic.add("entry.lsettleintmode");
        sic.add("entry.linterestsettledplan");
        sic.add("entry.lrateadjustdate");
        sic.add("entry.lissofrrate");
        sic.add("entry.loanrateadjuststyle");
        sic.add("entry.lrefrate");
        sic.add("entry.afterlrefrate");
        sic.add("entry.lrateadjustkey");
        sic.add("entry.lrateadjustval");
        sic.add("entry.afterlrateadjustkey");
        sic.add("entry.afterlrateadjustval");
        sic.add("entry.ladjusteffectdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        String dateStr;
        String loanNo;
        HashMap<String, ExtendedDataEntity> loanNoEntityMap = new HashMap<String, ExtendedDataEntity>(16);
        HashMap<Long, String> loanIdNoMap = new HashMap<Long, String>(16);
        ArrayList<Long> loanIds = new ArrayList<Long>(16);
        ArrayList<String> loanNos = new ArrayList<String>(16);
        HashMap<String, Date> loanNoAdjustDateMap = new HashMap<String, Date>(16);
        String dataSource = DataSourceEnum.CFM.getValue();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject adjustBill = dataEntity.getDataEntity();
            dataSource = adjustBill.getString("datasource");
            DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("entry");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObjectCollection onWayApplys;
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (!dynamicObject.getBoolean("lisadjust")) continue;
                DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("ldrawbill");
                long l = dynamicObject2.getLong("id");
                String loanNo3 = dynamicObject2.getString("number");
                Date adjustDate = dynamicObject.getDate("ladjusteffectdate");
                String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)dataSource);
                if (EmptyUtil.isEmpty((Object)adjustDate)) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_1.loadKDString(loanName, loanNo3));
                    continue;
                }
                boolean isAdjustToFloat = adjustBill.getBoolean("isadjusttofloat");
                if (this.checkRateAdjustDate(dataEntity, dynamicObject, isAdjustToFloat)) continue;
                if (InterestTypeEnum.isFloat((String)dynamicObject2.getString("interesttype")) || isAdjustToFloat) {
                    if (EmptyUtil.isEmpty((DynamicObject)dynamicObject.getDynamicObject("afterlrefrate"))) {
                        this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_11.loadKDString(loanName, loanNo3));
                        continue;
                    }
                    if (RateAdjustStyleEnum.isCycle((String)dynamicObject2.getString("rateadjuststyle"))) {
                        if (EmptyUtil.isEmpty((String)dynamicObject.getString("afterlrateadjustkey"))) {
                            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_12.loadKDString(loanName, loanNo3));
                            continue;
                        }
                        if (EmptyUtil.isEmpty((Integer)dynamicObject.getInt("afterlrateadjustval"))) {
                            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_13.loadKDString(loanName, loanNo3));
                            continue;
                        }
                    }
                } else if (isAdjustToFloat) {
                    this.validateMustInput(dataEntity);
                }
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
                if (RateAdjustHelper.validateLoanBillHasInDoingRepay((DynamicObject)adjustBill)) {
                    this.addErrorMessage(dataEntity, bizResource.checkExtLoanBillHasInDoingRepay());
                }
                if (RateAdjustHelper.validateLoanBillHasInDoingInt((DynamicObject)adjustBill)) {
                    this.addErrorMessage(dataEntity, bizResource.checkExtLoanBillHasInDoingInt());
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(onWayApplys = RateAdjustHelper.validateOnWayApply((DynamicObject)adjustBill)))) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.checkExtOnWayLoanBillApply(), ((DynamicObject)onWayApplys.get(0)).getString("billno")));
                }
                loanNoEntityMap.put(loanNo3, dataEntity);
                loanIdNoMap.put(l, loanNo3);
                loanIds.add(l);
                loanNos.add(loanNo3);
                loanNoAdjustDateMap.put(loanNo3, adjustDate);
            }
            this.isAdjustToFloatValidate(dataEntity, adjustBill);
            this.checkInterestSettledPlan(dataEntity, adjustBill);
        }
        DynamicObjectCollection rateAdjustBills = RateAdjustHelper.getRateAdjustBills(loanIds);
        DynamicObjectCollection extendBills = RateAdjustHelper.getExtendBills(loanNos, (String)dataSource);
        DynamicObjectCollection loanBills = LoanBillRepository.getLoanBillByIds(loanIds);
        String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)dataSource);
        Map loanIdDateMap = RateAdjustHelper.getLoanIdDateMap((DynamicObjectCollection)rateAdjustBills);
        for (Map.Entry entry : loanIdDateMap.entrySet()) {
            Long l = (Long)entry.getKey();
            String string = (String)loanIdNoMap.get(l);
            if (((Date)loanNoAdjustDateMap.get(string)).compareTo((Date)entry.getValue()) > 0) continue;
            String string2 = DateUtils.formatString((Date)((Date)entry.getValue()), (String)"yyyy-MM-dd");
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(string), CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_2.loadKDString(loanName, string, string2));
        }
        Map loanNoDateMap = RateAdjustHelper.getLoanNoDateMap((DynamicObjectCollection)extendBills);
        for (Map.Entry entry : loanNoDateMap.entrySet()) {
            String string = (String)entry.getKey();
            if (((Date)loanNoAdjustDateMap.get(string)).compareTo((Date)entry.getValue()) > 0) continue;
            String string3 = DateUtils.formatString((Date)((Date)entry.getValue()), (String)"yyyy-MM-dd");
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(string), CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_3.loadKDString(loanName, string, string3));
        }
        HashMap hashMap = RateAdjustHelper.getLoanIdPayIntDateMap((DynamicObjectCollection)loanBills);
        for (Map.Entry entry : hashMap.entrySet()) {
            Long l = (Long)entry.getKey();
            loanNo = (String)loanIdNoMap.get(l);
            if (((Date)loanNoAdjustDateMap.get(loanNo)).compareTo((Date)entry.getValue()) > 0) continue;
            dateStr = DateUtils.formatString((Date)((Date)entry.getValue()), (String)"yyyy-MM-dd");
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(loanNo), CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_4.loadKDString(loanName, loanNo, loanName, dateStr));
        }
        HashMap<String, Date> hashMap2 = this.getLoanNoStartIntDateMap(loanBills);
        for (Map.Entry entry : hashMap2.entrySet()) {
            loanNo = (String)entry.getKey();
            if (((Date)loanNoAdjustDateMap.get(loanNo)).compareTo((Date)entry.getValue()) >= 0) continue;
            dateStr = DateUtils.formatString((Date)((Date)entry.getValue()), (String)"yyyy-MM-dd");
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(loanNo), CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_5.loadKDString(loanName, loanNo, loanName, dateStr));
        }
        HashMap<String, Date> hashMap3 = this.getLoanNoExpireDateMap(loanBills);
        for (Map.Entry entry : hashMap3.entrySet()) {
            String loanNo2 = (String)entry.getKey();
            if (((Date)loanNoAdjustDateMap.get(loanNo2)).compareTo((Date)entry.getValue()) < 0) continue;
            String dateStr4 = DateUtils.formatString((Date)((Date)entry.getValue()), (String)"yyyy-MM-dd");
            this.addErrorMessage((ExtendedDataEntity)loanNoEntityMap.get(loanNo2), CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_6.loadKDString(loanName, loanNo2, loanName, dateStr4));
        }
    }

    private void isAdjustToFloatValidate(ExtendedDataEntity dataEntity, DynamicObject adjustBill) {
        if (!adjustBill.getBoolean("isadjusttofloat")) {
            return;
        }
        DynamicObject loanContractBill = adjustBill.getDynamicObject("loancontractbill");
        Date adjustEffectDate = adjustBill.getDate("adjusteffectdate");
        Date endDate = loanContractBill.getDate("enddate");
        Date renewalExpireDate = loanContractBill.getDate("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpireDate)) {
            endDate = renewalExpireDate;
        }
        if (EmptyUtil.isNoEmpty((Object)endDate) && adjustEffectDate.compareTo(endDate) >= 0 && !this.getIsNoTerm(loanContractBill)) {
            String contractName = CfmBillCommonHelper.getContractNameByDataSource((String)adjustBill.getString("datasource"));
            String dateStr = DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd");
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_7.loadKDString(contractName, dateStr));
        }
    }

    private boolean getIsNoTerm(DynamicObject loanContractBill) {
        boolean isNoTerm = false;
        DataEntityPropertyCollection properties = loanContractBill.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"isnofixedterm")) {
            isNoTerm = loanContractBill.getBoolean("isnofixedterm");
        }
        return isNoTerm;
    }

    private HashMap<String, Date> getLoanNoStartIntDateMap(DynamicObjectCollection loanBills) {
        HashMap<String, Date> loanNoStartIntDateMap = new HashMap<String, Date>(16);
        for (DynamicObject loanBill : loanBills) {
            String loanNo = loanBill.getString("billno");
            Date startIntDate = loanBill.getDate("startintdate");
            loanNoStartIntDateMap.put(loanNo, startIntDate);
        }
        return loanNoStartIntDateMap;
    }

    private HashMap<String, Date> getLoanNoExpireDateMap(DynamicObjectCollection loanBills) {
        HashMap<String, Date> loanNoExpireDateMap = new HashMap<String, Date>(16);
        for (DynamicObject loanBill : loanBills) {
            String loanNo = loanBill.getString("billno");
            Date expireDate = loanBill.getDate("expiredate");
            Date reExpireDate = loanBill.getDate("renewalexpiredate");
            expireDate = EmptyUtil.isEmpty((Object)reExpireDate) ? expireDate : reExpireDate;
            if (!EmptyUtil.isNoEmpty((Object)expireDate)) continue;
            loanNoExpireDateMap.put(loanNo, expireDate);
        }
        return loanNoExpireDateMap;
    }

    private void checkInterestSettledPlan(ExtendedDataEntity dataEntity, DynamicObject adjustBill) {
        boolean isAdjustToFloat = adjustBill.getBoolean("isadjusttofloat");
        String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)adjustBill.getString("datasource"));
        DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject loanBill = entry.getDynamicObject("ldrawbill");
            String loanNo = loanBill.getString("number");
            BigDecimal afterLLoanRate = entry.getBigDecimal("afterlloanrate");
            BigDecimal startInterestRate = loanBill.getBigDecimal("startloanrate");
            BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
            String settleIntMode = entry.getString("lsettleintmode");
            String repaymentWay = loanBill.getString("repaymentway");
            String interestType = loanBill.getString("interesttype");
            DynamicObject interestSettledPlan = entry.getDynamicObject("linterestsettledplan");
            ArrayList intPlanWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.zdyhk.getValue()});
            boolean isAdjust = entry.getBoolean("lisadjust");
            boolean isNotFloat = InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType);
            boolean isNot0Rate = BigDecimal.ZERO.compareTo(startInterestRate) == 0 && BigDecimal.ZERO.compareTo(loanRate) == 0;
            boolean isGdpljx = intPlanWays.contains(repaymentWay) && SettleIntModeEnum.isGdpljx((String)settleIntMode);
            boolean isEmpty = EmptyUtil.isEmpty((DynamicObject)interestSettledPlan);
            if (isAdjustToFloat) {
                if (!isAdjust || !isNotFloat || !isNot0Rate || !isGdpljx || !isEmpty) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_8.loadKDString(loanName, loanNo));
                continue;
            }
            if (!isAdjust || !isNotFloat || !isNot0Rate || !isGdpljx || !isEmpty || BigDecimal.ZERO.compareTo(afterLLoanRate) == 0) continue;
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_8.loadKDString(loanName, loanNo));
        }
    }

    private boolean checkRateAdjustDate(ExtendedDataEntity dataEntity, DynamicObject entry, boolean isAdjustToFloat) {
        DynamicObject loanBill = entry.getDynamicObject("ldrawbill");
        if (!RateAdjustStyleEnum.isCycle((String)entry.getString("loanrateadjuststyle")) || !InterestTypeEnum.isFloat((String)loanBill.getString("interesttype")) && !isAdjustToFloat) {
            return false;
        }
        Date rateAdjustDate = entry.getDate("lrateadjustdate");
        if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
            return false;
        }
        Date adjustEffectDate = entry.getDate("ladjusteffectdate");
        Date expireDate = loanBill.getDate("expiredate");
        Date renewalExpireDate = loanBill.getDate("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpireDate)) {
            expireDate = renewalExpireDate;
        }
        rateAdjustDate = DateUtils.getDataFormat((Date)rateAdjustDate, (boolean)true);
        adjustEffectDate = DateUtils.getDataFormat((Date)adjustEffectDate, (boolean)true);
        expireDate = DateUtils.getDataFormat((Date)expireDate, (boolean)true);
        String loanNo = loanBill.getString("number");
        String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)loanBill.getString("datasource"));
        if (rateAdjustDate.compareTo(adjustEffectDate) < 0) {
            String dateStr = DateUtils.formatString((Date)adjustEffectDate, (String)"yyyy-MM-dd");
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_9.loadKDString(loanName, loanNo, dateStr));
            return true;
        }
        if (rateAdjustDate.compareTo(expireDate) >= 0) {
            String dateStr = DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd");
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_10.loadKDString(loanName, loanNo, dateStr));
            return true;
        }
        return false;
    }

    private void validateMustInput(ExtendedDataEntity entity) {
        DynamicObject adjustBill = entity.getDataEntity();
        DynamicObject afterRefRate = adjustBill.getDynamicObject("afterrefrate");
        String rateAdjustStyle = adjustBill.getString("rateadjuststyle");
        String afterRateAdjustKey = adjustBill.getString("afterrateadjustkey");
        int afterRateAdjustVal = adjustBill.getInt("afterrateadjustval");
        Date rateAdjustDate = adjustBill.getDate("rateadjustdate");
        String afterratesign = adjustBill.getString("afterratesign");
        if (EmptyUtil.isEmpty((String)rateAdjustStyle)) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_14.loadKDString());
        } else if (RateAdjustStyleEnum.isCycle((String)rateAdjustStyle) && (EmptyUtil.isEmpty((String)afterRateAdjustKey) || EmptyUtil.isEmpty((Integer)afterRateAdjustVal) || EmptyUtil.isEmpty((Object)rateAdjustDate))) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_16.loadKDString());
        }
        if (EmptyUtil.isEmpty((String)afterratesign) || EmptyUtil.isEmpty((DynamicObject)afterRefRate)) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.RateAdjustBillSubmitValidator_15.loadKDString());
        }
    }
}

