/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repayapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepayApplyBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("loans.e_loanbill");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_notrepayamount");
        sic.add("loans.e_repayamount");
        sic.add("amount");
        sic.add("prerepaydate");
        sic.add("datasource");
        sic.add("productfactory");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        BizResourceFactory bizResourceFactory = new BizResourceFactory();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayApplyBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = bizResourceFactory.getBizResource(repayApplyBill.getString("datasource"));
            Date repayDate = repayApplyBill.getDate("prerepaydate");
            String checkLastRepayDate = RepaymentbillHelper.checkRepayDate((DynamicObject)repayApplyBill, (Date)repayDate, (String)"lastrepaydate");
            if (EmptyUtil.isNoEmpty((String)checkLastRepayDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getRepaydateCompare(), checkLastRepayDate));
                continue;
            }
            ArrayList<Long> loanIds = new ArrayList<Long>(10);
            for (DynamicObject entry : repayApplyBill.getDynamicObjectCollection("loans")) {
                DynamicObject loanBillF7 = entry.getDynamicObject("e_loanbill");
                loanIds.add(loanBillF7.getLong("id"));
                if (EmptyUtil.isEmpty((DynamicObject)loanBillF7)) {
                    this.addErrorMessage(dataEntity, bizResource.checkEntryNoData());
                    continue;
                }
                Date loanDate = loanBillF7.getDate("bizdate");
                if (repayDate.compareTo(loanDate) <= 0) {
                    this.addErrorMessage(dataEntity, bizResource.getRbRepaydateMin());
                    continue;
                }
                String error = LoanBillHelper.verifyLastEntIntDate((DynamicObject)loanBillF7, (Date)repayDate);
                if (EmptyUtil.isNoEmpty((String)error)) {
                    this.addErrorMessage(dataEntity, error);
                    continue;
                }
                Date lastPayInstDate = loanBillF7.getDate("lastpayinstdate");
                if (lastPayInstDate != null && repayDate.compareTo(lastPayInstDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getRbPayinterestDateMin(), DateUtils.formatString((Date)lastPayInstDate, (String)"yyyy-MM-dd")));
                    continue;
                }
                if (entry.getBigDecimal("e_repayamount").compareTo(loanBillF7.getBigDecimal("notrepayamount")) > 0) {
                    this.addErrorMessage(dataEntity, bizResource.getRbAmountMore());
                    continue;
                }
                BigDecimal actinterest = entry.getBigDecimal("e_preintamt");
                if (!entry.getBoolean("e_ispayinst") || actinterest.compareTo(BigDecimal.ZERO) > 0) continue;
                this.addErrorMessage(dataEntity, bizResource.getRbPreinterestError());
            }
            QFilter qFilter = new QFilter("businessstatus", "!=", (Object)ApplyBusinessStatusEnum.HANDED.getValue()).and("loans.e_loanbill", "in", loanIds).and("id", "!=", (Object)repayApplyBill.getLong("id"));
            DynamicObject onWayApply = QueryServiceHelper.queryOne((String)"cfm_repayapplybill", (String)"id, billno, loans.e_loanbill", (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)onWayApply)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u975e\u5df2\u529e\u7406\u72b6\u6001\u7684\u8fd8\u6b3e\u7533\u8bf7\u5355%1$s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"RepayApplyBillSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{onWayApply.getString("billno")}));
        }
    }
}

