/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("e_ispayinst");
        sic.add("loancontractbill");
        sic.add("datasource");
        sic.add("productfactory");
        sic.add("creditortype");
        sic.add("bizdate");
        sic.add("loans");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_loanbill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDataEntity().getDate("bizdate"))).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : repayBills) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                String dataSource;
                String orgFieldName;
                DynamicObject org;
                String creditorType;
                DynamicObject loanBillF7 = entry.getDynamicObject("e_loanbill");
                if (!entry.getBoolean("e_ispayinst") || !"bos_org".equals(creditorType = loanBillF7.getString("creditortype")) || !EmptyUtil.isEmpty((DynamicObject)(org = loanBillF7.getDynamicObject(orgFieldName = CfmBillCommonHelper.getFundOrgFieldName((String)(dataSource = loanBillF7.getString("datasource")), (boolean)false, (String)creditorType))))) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b\u4e3a\u5185\u90e8\u5355\u4f4d\uff0c\u503a\u6743\u7ec4\u7ec7\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RepaymentBillAuditValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }
}

