/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillBuyBackSubmitValidator
extends AbstractTmcBizOppValidator {
    private static final String LOAN_BILL_PROPS = String.join((CharSequence)",", "id", "investor_entry", String.join((CharSequence)".", "investor_entry", "e_investamount"), String.join((CharSequence)".", "investor_entry", "e_investorname"), String.join((CharSequence)".", "investor_entry", "e_investorid"));
    private static final String REPAY_BILL_PROP = String.join((CharSequence)",", "id", "loans.e_loanbill", String.join((CharSequence)".", "loans", "buyback_entry", "e_investentryid"), String.join((CharSequence)".", "loans", "buyback_entry", "e_buybackamt"));

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("buyback_entry");
        sic.add("loans");
        sic.add("isbuyback");
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investorid"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_buybackamt"));
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        HashMap<String, BigDecimal> investorBuyBackAmtMap = new HashMap<String, BigDecimal>(16);
        for (ExtendedDataEntity extendedData : dataEntity) {
            if (!extendedData.getDataEntity().getBoolean("isbuyback")) continue;
            this.checkBuyBackAmt(extendedData);
            RepaymentBillBuyBackSubmitValidator.getRepayBuyBackAmt(investorBuyBackAmtMap, extendedData);
        }
        this.checkSumBuyBackAmt(dataEntity, investorBuyBackAmtMap);
    }

    private void checkSumBuyBackAmt(ExtendedDataEntity[] dataEntity, Map<String, BigDecimal> investorBuyBackAmtMap) {
        if (investorBuyBackAmtMap.size() < 1) {
            return;
        }
        Set<Long> bondIds = RepaymentBillBuyBackSubmitValidator.getBondIds(investorBuyBackAmtMap);
        DynamicObjectCollection bondBills = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)LOAN_BILL_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", RepaymentBillBuyBackSubmitValidator.getBondIds(investorBuyBackAmtMap))});
        Map<String, BigDecimal> bondBuyBackAmt = RepaymentBillBuyBackSubmitValidator.getBondBuyBackAmt(bondIds);
        Map<Long, List<DynamicObject>> loanBillDbMap = bondBills.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> bondBillInvestEntries : loanBillDbMap.entrySet()) {
            for (DynamicObject bondBillInvestEntry : bondBillInvestEntries.getValue()) {
                BigDecimal investAmt;
                String key = bondBillInvestEntries.getKey() + "," + bondBillInvestEntry.getString("investor_entry");
                BigDecimal buybackAmt = investorBuyBackAmtMap.get(key);
                BigDecimal allBuybackAmt = bondBuyBackAmt.get(key);
                if (EmptyUtil.isEmpty((BigDecimal)allBuybackAmt)) {
                    allBuybackAmt = BigDecimal.ZERO;
                }
                if (buybackAmt.compareTo((investAmt = bondBillInvestEntry.getBigDecimal(String.join((CharSequence)".", "investor_entry", "e_investamount"))).subtract(allBuybackAmt)) <= 0) continue;
                this.addErrorMessage(dataEntity[0], ResManager.loadKDString((String)"\u56de\u552e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6295\u8d44\u4eba\u7684\u5269\u4f59\u53ef\u6295\u8d44\u91d1\u989d\u3002", (String)"RepaymentBillBuyBackSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return;
            }
        }
    }

    private static Set<Long> getBondIds(Map<String, BigDecimal> investorBuyBackAmtMap) {
        HashSet<Long> bondIds = new HashSet<Long>(investorBuyBackAmtMap.size());
        for (Map.Entry<String, BigDecimal> investorBuyBackAmtEntry : investorBuyBackAmtMap.entrySet()) {
            String bondId = investorBuyBackAmtEntry.getKey().split(",")[0];
            bondIds.add(Long.valueOf(bondId));
        }
        return bondIds;
    }

    private static void getRepayBuyBackAmt(Map<String, BigDecimal> investorBuyBackAmtMap, ExtendedDataEntity extendedData) {
        DynamicObject repayBill = extendedData.getDataEntity();
        if (!repayBill.getBoolean("isbuyback")) {
            return;
        }
        DynamicObjectCollection bondBills = repayBill.getDynamicObjectCollection("loans");
        for (DynamicObject bondBill : bondBills) {
            DynamicObjectCollection buyBackEntries = bondBill.getDynamicObjectCollection("buyback_entry");
            for (DynamicObject buyBackEntry : buyBackEntries) {
                String bondBillId = bondBill.getDynamicObject("e_loanbill").getString("id");
                String key = bondBillId + "," + buyBackEntry.getString("e_investentryid");
                if (investorBuyBackAmtMap.containsKey(key)) {
                    investorBuyBackAmtMap.put(key, investorBuyBackAmtMap.get(key).add(buyBackEntry.getBigDecimal("e_buybackamt")));
                    continue;
                }
                investorBuyBackAmtMap.put(key, buyBackEntry.getBigDecimal("e_buybackamt"));
            }
        }
    }

    private void checkBuyBackAmt(ExtendedDataEntity dataEntity) {
        this.checkSumBuyBackAmt(dataEntity);
    }

    private static Map<String, BigDecimal> getBondBuyBackAmt(Set<Long> bondId) {
        QFilter filter = new QFilter("loans.e_loanbill", "in", bondId).and("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection repaymentBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)REPAY_BILL_PROP, (QFilter[])new QFilter[]{filter});
        HashMap<String, BigDecimal> investIdAndBkAmtMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject repaymentBill : repaymentBills) {
            String key = repaymentBill.getString("loans.e_loanbill") + "," + repaymentBill.getString(String.join((CharSequence)".", "loans", "buyback_entry", "e_investentryid"));
            BigDecimal buybackAmt = repaymentBill.getBigDecimal(String.join((CharSequence)".", "loans", "buyback_entry", "e_buybackamt"));
            if (investIdAndBkAmtMap.containsKey(key)) {
                investIdAndBkAmtMap.put(key, ((BigDecimal)investIdAndBkAmtMap.get(key)).add(buybackAmt));
                continue;
            }
            investIdAndBkAmtMap.put(key, buybackAmt);
        }
        return investIdAndBkAmtMap;
    }

    private static Map<Long, DynamicObjectCollection> getLoanIdAndBuyBackCols(DynamicObject repayBill) {
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        HashMap<Long, DynamicObjectCollection> loanIdAndBbCols = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject loan : loans) {
            DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
            if (!EmptyUtil.isNoEmpty((DynamicObject)loanBill)) continue;
            loanIdAndBbCols.put(loanBill.getLong("id"), loan.getDynamicObjectCollection("buyback_entry"));
        }
        return loanIdAndBbCols;
    }

    private void checkSumBuyBackAmt(ExtendedDataEntity dataEntity) {
        DynamicObject repayBill = dataEntity.getDataEntity();
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        for (DynamicObject loan : loans) {
            DynamicObjectCollection buyBckEntry = loan.getDynamicObjectCollection("buyback_entry");
            BigDecimal sumBuyBackAmt = buyBckEntry.stream().map(d -> d.getBigDecimal("e_buybackamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sumBuyBackAmt.compareTo(loan.getBigDecimal("e_repayamount")) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56de\u552e\u91d1\u989d\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u8fd8\u6b3e\u91d1\u989d\u3002", (String)"RepaymentBillBuyBackSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return;
        }
    }
}

