/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillValidatorHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class RepaymentBillSaveOrSubmitValidator
extends AbstractTmcBizOppValidator {
    protected List<DynamicObject> getRepayBills(List<ExtendedDataEntity> dataEntityList) {
        return dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
    }

    protected List<ExtendedDataEntity> validateRepaymentHead(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = this.getBizResource(repayBill);
            Date repayDate = repayBill.getDate("bizdate");
            String checkLastRepayDate = RepaymentbillHelper.checkRepayDate((DynamicObject)repayBill, (Date)repayDate, (String)"lastrepaydate");
            if (EmptyUtil.isNoEmpty((String)checkLastRepayDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getRepaydateCompare(), checkLastRepayDate));
                continue;
            }
            if (repayBill.getDynamicObjectCollection("loans").size() == 0) {
                this.addErrorMessage(dataEntity, bizResource.getLoansEntrysNotNull());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected List<ExtendedDataEntity> validateIsOnSameContractBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map<Long, Set<Long>> loanBillIdMap = RepaymentBillValidatorHelper.getLoanBillIdMap(this.getRepayBills(dataEntities));
        HashSet loanBillIds = new HashSet(10);
        loanBillIdMap.values().forEach(loanBillIds::addAll);
        DynamicObjectCollection loanBills = LoanBillRepository.queryLoanBillByIds(loanBillIds, (String)"id, loancontractbill");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            Set<Long> loanBillIdSet = loanBillIdMap.get(repayBill.getLong("id"));
            long contractCount = loanBills.stream().filter(d -> loanBillIdSet.contains(d.getLong("id"))).map(d -> d.getLong("loancontractbill")).distinct().count();
            if (contractCount > 1L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u5408\u540c\u4e0b\u7684\u5355\u636e\u8fdb\u884c\u8fd8\u6b3e\uff0c\u8bf7\u91cd\u65b0\u9009\u5355\u3002", (String)"RepaymentBillSubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected List<ExtendedDataEntity> validateLoanEntrys(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            boolean isBreak = false;
            Date repayDate = repayBill.getDate("bizdate");
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                DynamicObject loanBillF7 = entry.getDynamicObject("e_loanbill");
                if (EmptyUtil.isEmpty((DynamicObject)loanBillF7)) {
                    this.addErrorMessage(dataEntity, this.getBizResource(repayBill).checkEntryNoData());
                    isBreak = true;
                    break;
                }
                if (repayDate.compareTo(loanBillF7.getDate("bizdate")) <= 0) {
                    this.addErrorMessage(dataEntity, this.getBizResource(repayBill).getRbRepaydateMin());
                    isBreak = true;
                    break;
                }
                if (entry.getBoolean("e_ispayinst") && entry.getBigDecimal("e_actintamt").compareTo(BigDecimal.ZERO) <= 0 && !this.getOption().containsVariable("RepayApplyBillPush2Repay")) {
                    if ("fl_rentpaybill".equals(repayBill.getDataEntityType().getName())) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u4ed8\u5229\u606f\u91d1\u989d\u4e3a0", (String)"RepaymentBillSaveOrSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(dataEntity, this.getBizResource(repayBill).getRbActinterestError());
                    }
                    isBreak = true;
                    break;
                }
                String error = LoanBillHelper.verifyLastEntIntDate((DynamicObject)loanBillF7, (Date)repayDate);
                if (EmptyUtil.isNoEmpty((String)error)) {
                    this.addErrorMessage(dataEntity, error);
                    isBreak = true;
                    break;
                }
                Date lastPayInstDate = loanBillF7.getDate("lastpayinstdate");
                if (lastPayInstDate == null || repayDate.compareTo(lastPayInstDate) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(this.getBizResource(repayBill).getRbPayinterestDateMin(), DateUtils.formatString((Date)lastPayInstDate, (String)"yyyy-MM-dd")));
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected AbstractBizResource getBizResource(DynamicObject repayBill) {
        return RepaymentBillValidatorHelper.getBizResource(repayBill);
    }
}

