/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSlValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sels = super.getSelector();
        sels.add("slentryentity");
        sels.add("s_bank");
        sels.add("s_loanamount");
        sels.add("s_repayamount");
        sels.add("s_repayinst");
        sels.add("currency");
        sels.add("loans");
        return sels;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        HashSet<Long> loanBillIds = new HashSet<Long>();
        List dataEntityList = Arrays.stream(dataEntitys).filter(d -> LoanTypeEnum.isBanksLoan((String)d.getDataEntity().getString("loantype"))).collect(Collectors.toList());
        if (dataEntityList.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            Set loanIds = dataEntity.getDataEntity().getDynamicObjectCollection("loans").stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_loanbill"))).map(o -> o.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toSet());
            loanBillIds.addAll(loanIds);
        }
        Map<String, BigDecimal> slloanBankMap = this.getSlloanBankMap(loanBillIds);
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            DynamicObject repayment = dataEntity.getDataEntity();
            DynamicObject currency = repayment.getDynamicObject("currency");
            int amtPrecision = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 2;
            DynamicObjectCollection slEntrys = repayment.getDynamicObjectCollection("slentryentity");
            Map<Long, List<DynamicObject>> slLoanMap = slEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.groupingBy(o -> o.getDynamicObject("s_loanbillno").getLong("id")));
            Map<Long, BigDecimal> repayAmountMap = slLoanMap.entrySet().stream().collect(Collectors.toMap(o -> (Long)o.getKey(), o -> ((List)o.getValue()).stream().map(e -> e.getBigDecimal("s_repayamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            Map<Long, BigDecimal> instAmountMap = slLoanMap.entrySet().stream().collect(Collectors.toMap(o -> (Long)o.getKey(), o -> ((List)o.getValue()).stream().map(e -> e.getBigDecimal("s_repayinst")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            DynamicObjectCollection loans = repayment.getDynamicObjectCollection("loans");
            for (DynamicObject loan : loans) {
                BigDecimal instAmt;
                DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
                BigDecimal repayAmt = repayAmountMap.getOrDefault(loanBill.getLong("id"), BigDecimal.ZERO);
                if (repayAmt.compareTo(loan.getBigDecimal("e_repayamount")) != 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillSlValidator_1.loadKDString(loanBill.getString("number"), repayAmt.setScale(amtPrecision), loan.getBigDecimal("e_repayamount").setScale(amtPrecision, RoundingMode.HALF_UP)));
                }
                if ((instAmt = instAmountMap.getOrDefault(loanBill.getLong("id"), BigDecimal.ZERO)).compareTo(loan.getBigDecimal("e_actintamt")) == 0) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillSlValidator_2.loadKDString(loanBill.getString("number"), instAmt.setScale(amtPrecision), loan.getBigDecimal("e_actintamt").setScale(amtPrecision, RoundingMode.HALF_UP)));
            }
            Set loansIds = loans.stream().map(o -> o.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toSet());
            for (DynamicObject slEntry : slEntrys) {
                BigDecimal slRepayAmount;
                String key;
                BigDecimal canRepayAmount;
                DynamicObject loanBill = slEntry.getDynamicObject("s_loanbillno");
                if (!loansIds.contains(loanBill.getLong("id"))) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillSlValidator_3.loadKDString(loanBill.getString("number")));
                }
                DynamicObject bank = slEntry.getDynamicObject("s_bank");
                BigDecimal loanAmount = slEntry.getBigDecimal("s_loanamount");
                if (EmptyUtil.isEmpty((BigDecimal)loanAmount) && (EmptyUtil.isNoEmpty((BigDecimal)slEntry.getBigDecimal("s_repayamount")) || EmptyUtil.isNoEmpty((BigDecimal)slEntry.getBigDecimal("s_repayinst")))) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillSlValidator_4.loadKDString(loanBill.getString("number"), bank != null ? bank.getString("name") : ""));
                }
                if ((canRepayAmount = slloanBankMap.getOrDefault(key = loanBill.getString("id") + (bank != null ? bank.getString("id") : ""), BigDecimal.ZERO)).compareTo(slRepayAmount = slEntry.getBigDecimal("s_repayamount")) < 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillSlValidator_0.loadKDString(loanBill.getString("number"), bank != null ? bank.getString("name") : "", slRepayAmount.setScale(amtPrecision), canRepayAmount.setScale(amtPrecision, RoundingMode.HALF_UP)));
                    continue;
                }
                slloanBankMap.put(key, slloanBankMap.getOrDefault(key, BigDecimal.ZERO).subtract(slRepayAmount));
            }
        }
    }

    private Map<String, BigDecimal> getSlloanBankMap(Set<Long> loanBillIds) {
        HashMap<String, BigDecimal> slloanBankMap = new HashMap<String, BigDecimal>();
        if (loanBillIds.size() == 0) {
            return slloanBankMap;
        }
        DataSet repaySlBankDs = RepaymentbillHelper.getRepaySlBankDs(loanBillIds);
        Map slBankRepayMap = RepaymentbillHelper.getRepaySlBanks((DataSet)repaySlBankDs, (boolean)false);
        DynamicObjectCollection loanBanks = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,banksyndicate_entry.e_bank bank,banksyndicate_entry.e_shareamount amount", (QFilter[])new QFilter[]{new QFilter("id", "in", loanBillIds)});
        for (DynamicObject loanBank : loanBanks) {
            String key = loanBank.getString("id") + loanBank.getString("bank");
            slloanBankMap.put(key, loanBank.getBigDecimal("amount").subtract(slBankRepayMap.getOrDefault(key, BigDecimal.ZERO)));
        }
        return slloanBankMap;
    }
}

