/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillSaveOrSubmitValidator;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillValidatorHelper;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSubmitValidator
extends RepaymentBillSaveOrSubmitValidator {
    private static final String FLAG_ISMUSTPAYINST = "flag_ismustpayinst";

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_loanbill");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_actintamt");
        sic.add("loans.e_notrepayamount");
        sic.add("loans.e_repayamount");
        sic.add("loans.e_calintamt");
        sic.add("loans.e_combineinst");
        sic.add("amount");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("productfactory");
        sic.add("auto");
        sic.add("org");
        sic.add("creditorg");
        sic.add("loans.seq");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<ExtendedDataEntity> dataEntityList = this.validateRepaymentHead(dataEntities);
        dataEntityList = this.validateIsOnSameContractBill(dataEntityList);
        dataEntityList = this.validateLoanEntrys(dataEntityList);
        dataEntityList = this.validateIngInterest(dataEntityList);
        dataEntityList = this.validateLoanRepayAmount(dataEntityList);
        dataEntityList = this.validateIsPayInterest(dataEntityList);
        dataEntityList = this.validateRepayAmountScale(dataEntityList);
        dataEntityList = this.validateIsOnWayApply(dataEntityList);
        dataEntityList = this.validateLoanBillStatus(dataEntityList);
    }

    private List<ExtendedDataEntity> validateLoanBillStatus(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map<Long, Set<DynamicObject>> loanBillMap = RepaymentBillValidatorHelper.getLoanBillMap(this.getRepayBills(dataEntities));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            Set<DynamicObject> loanBillSet = loanBillMap.get(repayBill.getLong("id"));
            String billNos = loanBillSet.stream().filter(d -> !BillStatusEnum.isAudit((String)d.getString("status")) || !ConfirmStatusEnum.isYetconfirm((String)d.getString("confirmstatus"))).map(d -> d.getString("number")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)billNos)) {
                String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)repayBill.getString("datasource"));
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_12.loadKDString(loanName, billNos));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateIsOnWayApply(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map<Long, Set<Long>> loanBillIdMap = RepaymentBillValidatorHelper.getLoanBillIdMap(this.getRepayBills(dataEntities));
        HashSet<Long> loanBillIds = new HashSet<Long>(10);
        loanBillIdMap.values().forEach(loanBillIds::addAll);
        DynamicObjectCollection onWayApplys = LoanBillApplyHelper.queryOnWayApplyByIds(loanBillIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            Set<Long> loanBillIdSet = loanBillIdMap.get(repayBill.getLong("id"));
            String billNos = onWayApplys.stream().filter(d -> loanBillIdSet.contains(d.getLong("loanbill"))).map(d -> d.getString("billno")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)billNos)) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_11.loadKDString(billNos));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateIsPayInterest(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        HashMap<Long, Date> loanBillDateMap = new HashMap<Long, Date>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            Date repayDate = repayBill.getDate("bizdate");
            List loanEntrys = repayBill.getDynamicObjectCollection("loans").stream().filter(d -> d.getBoolean("e_ispayinst")).collect(Collectors.toList());
            for (DynamicObject loanEntry : loanEntrys) {
                loanBillDateMap.put(loanEntry.getLong("e_loanbill.id"), repayDate);
            }
        }
        if (loanBillDateMap.isEmpty()) {
            return dataEntities;
        }
        Map validateBeanMap = InterestValidateHelper.validateOnSubmit(loanBillDateMap, (AbstractBizResource)this.getBizResource(dataEntities.get(0).getDataEntity()));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            boolean isBreak = false;
            List loanEntrys = repayBill.getDynamicObjectCollection("loans").stream().filter(d -> d.getBoolean("e_ispayinst")).collect(Collectors.toList());
            for (DynamicObject loanEntry : loanEntrys) {
                long loanBillId = loanEntry.getLong("e_loanbill.id");
                ValidateBean bean = (ValidateBean)validateBeanMap.get(loanBillId);
                if (bean == null) continue;
                this.addMessage(dataEntity, bean.getErrorInfo(), bean.isError() ? ErrorLevel.Error : ErrorLevel.Warning);
                isBreak = true;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateRepayAmountScale(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            DynamicObject org = repayBill.getDynamicObject("org");
            if (DataSourceEnum.isInvest((String)repayBill.getString("datasource"))) {
                org = repayBill.getDynamicObject("creditorg");
            }
            if (EmptyUtil.isEmpty((DynamicObject)org)) {
                dataEntityList.add(dataEntity);
                continue;
            }
            long orgId = org.getLong("id");
            if (!CfmSysParamHelper.getAppBoolParameter((long)orgId, (String)"cfm007")) {
                dataEntityList.add(dataEntity);
                continue;
            }
            boolean isBreak = false;
            BigDecimal controlAmt = CfmSysParamHelper.getAppBigDecimalParameter((long)orgId, (String)"cfm008");
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                BigDecimal calIntAmt = entry.getBigDecimal("e_calintamt");
                BigDecimal actIntAmt = entry.getBigDecimal("e_actintamt");
                BigDecimal abs = actIntAmt.subtract(calIntAmt).abs().setScale(2, RoundingMode.HALF_UP);
                String entityName = repayBill.getDynamicObjectType().getName();
                if (StringUtils.equals((CharSequence)entityName, (CharSequence)"fl_rentpaybill") || abs.compareTo(controlAmt) <= 0) continue;
                String dataSource = repayBill.getString("datasource");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4e0e\u6d4b\u7b97\u5229\u606f\u4e4b\u5dee\u7edd\u5bf9\u503c%3$s\u4e0d\u80fd\u5927\u4e8e\u53c2\u6570\u8bbe\u7f6e\u7684\u5141\u8bb8\u504f\u5dee\u91d1\u989d%4$s\uff0c\u8bf7\u4fee\u6539%5$s\u3002", (String)"RepaymentBillSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), entry.get("seq"), InterestValidateHelper.getPayIntName((String)dataSource), abs, controlAmt, InterestValidateHelper.getPayIntName((String)dataSource)));
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateIngInterest(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map validIngInterestMap = InterestValidateHelper.validIngInterest(this.getRepayBills(dataEntities));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            long repayBillId = repayBill.getLong("id");
            String intIntInfo = (String)validIngInterestMap.get(repayBillId);
            if (EmptyUtil.isNoEmpty((String)intIntInfo)) {
                this.addErrorMessage(dataEntity, intIntInfo);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateLoanRepayAmount(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Set<Long> loanBillIds = RepaymentBillValidatorHelper.getLoanBillIds(dataEntities);
        Map loanRepayAmtMap = RepaymentBillRepository.getLockInAmout(loanBillIds);
        HashMap<Long, BigDecimal> amtByBill = new HashMap<Long, BigDecimal>(loanBillIds.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            boolean isBreak = false;
            AbstractBizResource bizResource = this.getBizResource(repayBill);
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                BigDecimal loanRate;
                DynamicObject product;
                DynamicObject loanBillF7 = entry.getDynamicObject("e_loanbill");
                Long loanBillpkid = loanBillF7.getLong("id");
                Date loanEndInstDate = loanBillF7.getDate("endinstdate");
                BigDecimal lockinamount = (BigDecimal)loanRepayAmtMap.get(loanBillpkid);
                BigDecimal repayableamount = loanBillF7.getBigDecimal("drawamount").subtract(lockinamount);
                BigDecimal repayamount = entry.getBigDecimal("e_repayamount");
                if (amtByBill.containsKey(loanBillpkid)) {
                    amtByBill.put(loanBillpkid, ((BigDecimal)amtByBill.get(loanBillpkid)).add(repayamount));
                } else {
                    amtByBill.put(loanBillpkid, repayamount);
                }
                if (((BigDecimal)amtByBill.get(loanBillpkid)).compareTo(repayableamount) > 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillSubmitValidator_0.loadKDString(dataEntity.getValue("billno"), repayableamount.toPlainString()));
                    isBreak = true;
                    break;
                }
                if (entry.getBoolean("e_ispayinst") || ((BigDecimal)amtByBill.get(loanBillpkid)).compareTo(repayableamount) != 0 || (product = repayBill.getDynamicObject("productfactory")) != null && !product.getBoolean("iscallint") || loanEndInstDate != null && DateUtils.getDiffDays((Date)loanEndInstDate, (Date)repayBill.getDate("bizdate")) <= 2 || null == (loanRate = loanBillF7.getBigDecimal("loanrate")) || loanRate.compareTo(BigDecimal.ZERO) == 0 || repayBill.getBoolean("auto") || !"true".equals(this.getOption().getVariableValue(FLAG_ISMUSTPAYINST, "true"))) continue;
                this.addWarningMessage(dataEntity, bizResource.getRbLastRepayInst());
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }
}

