/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSuretyRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("entry_surety");
        sic.add("suretyrepayamt");
        sic.add("suretybill");
        sic.add("totalamt");
        sic.add("amount");
        sic.add("loans");
        sic.add("loancontractbill");
        sic.add(String.join((CharSequence)".", "loans", "e_ispayinst"));
        sic.add(String.join((CharSequence)".", "loans", "e_combineinst"));
        sic.add(String.join((CharSequence)".", "loans", "e_actintamt"));
        sic.add(String.join((CharSequence)".", "suretybill", "surplusamount"));
        return sic;
    }

    public void validate(ExtendedDataEntity[] repayBills) throws KDBizException {
        for (ExtendedDataEntity dataEntity : repayBills) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            this.checkSuretyRepay(dataEntity, repayBill);
        }
    }

    private void checkSuretyRepay(ExtendedDataEntity dataEntity, DynamicObject repayBill) {
        if (!repayBill.getBoolean("issuretyrepay")) {
            return;
        }
        DynamicObjectCollection sureties = repayBill.getDynamicObjectCollection("entry_surety");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)sureties)) {
            DynamicObject surety = (DynamicObject)sureties.get(0);
            BigDecimal suretyRepayAmt = surety.getBigDecimal("suretyrepayamt");
            DynamicObject suretyBill = surety.getDynamicObject("suretybill");
            if (EmptyUtil.isEmpty((DynamicObject)suretyBill) && EmptyUtil.isNoEmpty((DynamicObject)repayBill.getDynamicObject("loancontractbill"))) {
                suretyBill = SuretyHelper.loadSuretyBillByDebit((Long)repayBill.getDynamicObject("loancontractbill").getLong("id"));
            }
            if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
                return;
            }
            BigDecimal surplusAmount = suretyBill.getBigDecimal("surplusamount");
            BigDecimal payAmt = repayBill.getDataEntityType().getName().equals("fl_rentpaybill") ? repayBill.getBigDecimal("totalamt") : repayBill.getBigDecimal("amount");
            if (suretyRepayAmt.compareTo(surplusAmount) > 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u62b5\u6263\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4fdd\u8bc1\u91d1\u5269\u4f59\u91d1\u989d\u3002", (String)"RepaymentBillSuretyRepayValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            BizResourceFactory bizResourceFactory = new BizResourceFactory();
            AbstractBizResource bizResource = bizResourceFactory.getBizResource(repayBill.getString("datasource"));
            if (suretyRepayAmt.compareTo(payAmt) > 0) {
                this.addMessage(dataEntity, bizResource.getSuretyRepayAmtLessAndEqualsRepayAmt());
            }
            if (repayBill.getBoolean("issuretyrepay") && EmptyUtil.isEmpty((BigDecimal)suretyRepayAmt)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"RepaymentBillSuretyRepayValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }
}

