/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.repaymentbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillUnAuditOrConfirmValidator;
import kd.tmc.cfm.business.validate.repaymentbill.RepaymentBillValidatorHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillUnAuditValidator
extends RepaymentBillUnAuditOrConfirmValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loancontractbill");
        sic.add("loans");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_loanbill");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("billstatus");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("bizdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<ExtendedDataEntity> dataEntityList = Arrays.stream(dataEntities).collect(Collectors.toList());
        dataEntityList = this.validateBillHead(dataEntityList);
        dataEntityList = this.validateLoanEntrys(dataEntityList);
        dataEntityList = this.validateIngInterest(dataEntityList);
        dataEntityList = this.validateTargetBill(dataEntityList);
        dataEntityList = this.validateLimitRepayAmount(dataEntityList);
        dataEntityList = this.validateIsPayInt(dataEntityList);
    }

    private List<ExtendedDataEntity> validateIsPayInt(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Object[] interestBills = this.getInterestBills(dataEntities = dataEntities.stream().filter(d -> !this.isSettleCenterBill(d.getDataEntity())).collect(Collectors.toList()), null);
        if (EmptyUtil.isEmpty((Object[])interestBills)) {
            return dataEntities;
        }
        Map validateBeanMap = InterestValidateHelper.validateOnUnAudit(Arrays.asList(interestBills));
        if (EmptyUtil.isEmpty((Object)validateBeanMap)) {
            return dataEntities;
        }
        dataEntityList.addAll(this.checkValidateIntBillResult(dataEntities, (DynamicObject[])interestBills, validateBeanMap));
        return dataEntityList;
    }

    private boolean isSettleCenterBill(DynamicObject repayBill) {
        return CreditorTypeEnum.SETTLECENTER.getValue().equals(repayBill.getString("creditortype")) && DataSourceEnum.isCfm((String)repayBill.getString("datasource")) && "cfm_repaymentbill".equals(repayBill.getDataEntityType().getName());
    }

    private List<ExtendedDataEntity> validateLoanEntrys(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            boolean isBreak = false;
            Date repayDate = repayBill.getDate("bizdate");
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                DynamicObject loanBillF7 = entry.getDynamicObject("e_loanbill");
                Date loanEndInstDate = loanBillF7.getDate("endinstdate");
                if (!LoanBillHelper.isYkx((DynamicObject)loanBillF7) && loanEndInstDate != null && repayDate.compareTo(loanEndInstDate) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(this.getBizResource(repayBill).getRbEndinstdateMinNew(), DateUtils.formatString((Date)loanEndInstDate, (String)"yyyy-MM-dd")));
                    isBreak = true;
                    break;
                }
                Date lastRepayDate = loanBillF7.getDate("lastrepaydate");
                if (lastRepayDate == null || repayDate.compareTo(lastRepayDate) >= 0) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.RepaymentBillUnAuditValidator_2.loadKDString());
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateIngInterest(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List repayBills = BusinessHelper.getBills(dataEntities);
        Map validIngInterestMap = InterestValidateHelper.validIngInterest((List)repayBills);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long repayBillId = BusinessHelper.getBillId((ExtendedDataEntity)dataEntity);
            String intIntInfo = (String)validIngInterestMap.get(repayBillId);
            if (EmptyUtil.isNoEmpty((String)intIntInfo)) {
                this.addErrorMessage(dataEntity, intIntInfo);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateTargetBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Map<String, List<ExtendedDataEntity>> creditorTypeMap = dataEntities.stream().collect(Collectors.groupingBy(d -> d.getDataEntity().getString("creditortype")));
        for (Map.Entry<String, List<ExtendedDataEntity>> entry : creditorTypeMap.entrySet()) {
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(entry.getKey())) {
                dataEntityList.addAll(this.validateForSettleCenter(entry.getValue()));
                continue;
            }
            dataEntityList.addAll(this.validateForNotSettleCenter(entry.getValue()));
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateForNotSettleCenter(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        AbstractBizResource bizResource = RepaymentBillValidatorHelper.getBizResource(dataEntities.get(0).getDataEntity());
        ArrayList<ExtendedDataEntity> outGroupDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            if (BusinessHelper.isOutGroup((DynamicObject)repayBill)) {
                outGroupDataEntitys.add(dataEntity);
                continue;
            }
            if (ConfirmStatusEnum.isWaitconfirm((String)repayBill.getString("confirmstatus"))) continue;
            this.addErrorMessage(dataEntity, bizResource.getUnauditConfirmStatus());
        }
        if (!outGroupDataEntitys.isEmpty()) {
            List settleRepayBills = outGroupDataEntitys.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Map validateMap = BusinessHelper.checkTargetBillForNotInnerLoan(settleRepayBills, null);
            this.checkValidateResult(outGroupDataEntitys, validateMap, dataEntityList);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateForSettleCenter(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        AbstractBizResource bizResource = RepaymentBillValidatorHelper.getBizResource(dataEntities.get(0).getDataEntity());
        ArrayList<ExtendedDataEntity> settleCenterDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject repayBill = dataEntity.getDataEntity();
            if (this.isInnerIfm(repayBill)) {
                this.addErrorMessage(dataEntity, bizResource.getRepayBillGenTypeMsg());
                continue;
            }
            settleCenterDataEntitys.add(dataEntity);
        }
        if (!settleCenterDataEntitys.isEmpty()) {
            List settleRepayBills = settleCenterDataEntitys.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Map validateMap = BusinessHelper.checkTargetBillForInnerLoan(settleRepayBills, null);
            this.checkValidateResult(settleCenterDataEntitys, validateMap, dataEntityList);
        }
        return dataEntityList;
    }

    private boolean isInnerIfm(DynamicObject repayBill) {
        return DataSourceEnum.isIfm((String)repayBill.getString("datasource")) && "cfm_repaymentbill".equals(repayBill.getDataEntityType().getName());
    }

    private List<ExtendedDataEntity> validateLimitRepayAmount(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        ArrayList<ExtendedDataEntity> bondDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (LoanTypeEnum.isBond((String)dataEntity.getDataEntity().getString("loantype"))) {
                bondDataEntitys.add(dataEntity);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        if (bondDataEntitys.isEmpty()) {
            return dataEntityList;
        }
        Set<Long> loanBillIds = RepaymentBillValidatorHelper.getLoanBillIds(bondDataEntitys);
        QFilter qFilter = new QFilter("id", "in", loanBillIds).and(QFilter.isNotNull((String)"occupybondlimit"));
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"id,occupybondlimit,billno,drawamount", (QFilter[])qFilter.toArray());
        Map<Long, DynamicObject> loanBillMap = loanBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        for (ExtendedDataEntity dataEntity : bondDataEntitys) {
            HashMap<Long, BigDecimal> limitRepayAmountMap = new HashMap<Long, BigDecimal>(10);
            DynamicObject repayBill = dataEntity.getDataEntity();
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                Long occupyBondLimitId;
                Long loanBillId = entry.getLong("e_loanbill.id");
                BigDecimal repayamount = entry.getBigDecimal("e_repayamount");
                DynamicObject loanBill = loanBillMap.get(loanBillId);
                if (loanBill == null || !EmptyUtil.isNoEmpty((Long)(occupyBondLimitId = Long.valueOf(loanBill.getLong("occupybondlimit"))))) continue;
                if (limitRepayAmountMap.containsKey(occupyBondLimitId)) {
                    BigDecimal amount = (BigDecimal)limitRepayAmountMap.get(occupyBondLimitId);
                    limitRepayAmountMap.put(occupyBondLimitId, amount.add(repayamount));
                    continue;
                }
                limitRepayAmountMap.put(occupyBondLimitId, repayamount);
            }
            if (!this.validateLimitRepayAmount(dataEntity, limitRepayAmountMap)) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean validateLimitRepayAmount(ExtendedDataEntity dataEntity, Map<Long, BigDecimal> limitRepayAmountMap) {
        if (limitRepayAmountMap.isEmpty()) {
            return true;
        }
        boolean isSuccess = true;
        DynamicObjectCollection limits = QueryServiceHelper.query((String)"bdim_bond_limit", (String)"id, number,limittype,availamt", (QFilter[])new QFilter("id", "in", limitRepayAmountMap.keySet()).toArray());
        Map<Long, DynamicObject> limitMap = limits.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        HashMap<Long, BigDecimal> limitAvaliamtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, BigDecimal> entry : limitRepayAmountMap.entrySet()) {
            BigDecimal availamt;
            Long id = entry.getKey();
            BigDecimal amount = entry.getValue();
            DynamicObject limit = limitMap.get(id);
            String limittype = limit.getString("limittype");
            if (!"loop".equals(limittype)) continue;
            if (limitAvaliamtMap.containsKey(id)) {
                availamt = (BigDecimal)limitAvaliamtMap.get(id);
                if (availamt.compareTo(amount) < 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u53d1\u884c\u989d\u5ea6%1$s\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u91cd\u65b0\u5360\u7528\u5931\u8d25\u3002", (String)"RepaymentBillUnAuditValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), limit.getString("number")));
                    isSuccess = false;
                    continue;
                }
                limitAvaliamtMap.put(id, availamt.subtract(amount));
                continue;
            }
            availamt = limit.getBigDecimal("availamt");
            if (availamt.compareTo(amount) < 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u53d1\u884c\u989d\u5ea6%1$s\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u91cd\u65b0\u5360\u7528\u5931\u8d25\u3002", (String)"RepaymentBillUnAuditValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), limit.getString("number")));
                isSuccess = false;
                continue;
            }
            limitAvaliamtMap.put(id, availamt.subtract(amount));
        }
        return isSuccess;
    }
}

