/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.unifyloanreturn;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UnifyLoanRepaySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isunifyloanreturn");
        selector.add("amount");
        selector.add("drawamount");
        selector.add("unifyloanfrom_entry");
        selector.add("unifyloanfrom_entry.e_loanbill");
        selector.add("unifyloanfrom_entry.e_useamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject loanBill = extData.getDataEntity();
            if (!loanBill.getBoolean("isunifyloanreturn")) continue;
            DynamicObjectCollection unifyLoanReturnEntry = loanBill.getDynamicObjectCollection("unifyloanfrom_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)unifyLoanReturnEntry)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7edf\u501f\u7edf\u8fd8\u4fe1\u606f\u3002", (String)"UnifyLoanReturnSaveOrSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal totalUseAmt = unifyLoanReturnEntry.stream().filter(o -> !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{o.getString("e_loanbill"), o.getBigDecimal("e_useamt")})).map(o -> o.getBigDecimal("e_useamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (totalUseAmt.compareTo(loanBill.getBigDecimal("drawamount")) <= 0) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7528\u6b3e\u91d1\u989d\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u653e\u6b3e/\u53d1\u884c\u91d1\u989d\u3002", (String)"UnifyLoanReturnSaveOrSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

