/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class DepositDetailDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String selectOriDepositProp = "id,finorginfo.name as finorginfo,finorginfo.number as finorginfonumber,org.name as org,org.number as orgnumber,billno,investvarieties.name as investvarieties,investvarieties.number as investvarietiesnumber,currency,currency.name as currencyname,currency.number as currencynamenumber,amount,bizdate,intdate,expiredate,interestrate,demandrate,planamount,finaccount,settleaccount,interesttype,tradechannel,basis,deadline,term";
    private static final String selectDepositProp = "id,finorginfo,finorginfonumber,org,orgnumber,billno,investvarieties,investvarietiesnumber,currency,currencyname,currencynamenumber,amount,bizdate,intdate,expiredate,interestrate,demandrate,planamount,finaccount,settleaccount,interesttype,tradechannel,basis,term,redeemamount,totalamount";
    private static final String selectReleaseProp = "finbillno,amount";
    private static final String selectRevenueProp = "loanbillno, actpreinstamt as realrevenue";
    private List<String> groupFields;
    private List<String> orderByFields;
    private String sumNameField;
    private String subNameField;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        List<QFilter> commonfilter = this.buildCommonFilter(queryParam);
        List<QFilter> depositFilter = this.buildDepositQueryFilter(commonfilter, queryParam);
        DataSet depositDs = QueryServiceHelper.queryDataSet((String)"DepositDetailDataPlugin_QueryDeposit", (String)"cim_deposit", (String)selectOriDepositProp, (QFilter[])depositFilter.toArray(new QFilter[0]), (String)"");
        depositDs = depositDs.updateField("term", this.getUpdateTermStr());
        List<QFilter> releaseFilter = this.buildReleaseQueryFilter(commonfilter, queryParam, depositDs.copy());
        DataSet releaseDs = QueryServiceHelper.queryDataSet((String)"DepositDetailDataPlugin_QueryRelease", (String)"cim_release", (String)selectReleaseProp, (QFilter[])releaseFilter.toArray(new QFilter[0]), (String)"");
        DataSet releaseMidDs = releaseDs.groupBy(new String[]{"finbillno"}).sum("amount", "redeemamount").finish().select("finbillno,redeemamount");
        List<QFilter> revenueFilter = this.buildRevenueQueryFilter(queryParam, depositDs.copy());
        DataSet revenueDs = QueryServiceHelper.queryDataSet((String)"DepositDetailDataPlugin_QueryRevenue", (String)"cim_dptrevenue", (String)selectRevenueProp, (QFilter[])revenueFilter.toArray(new QFilter[0]), (String)"");
        DataSet revenueMidDs = revenueDs.groupBy(new String[]{"loanbillno"}).sum("realrevenue", "totalamount").finish().select("loanbillno,totalamount");
        DataSet joinDs = depositDs.leftJoin(releaseMidDs).on("id", "finbillno").select(depositDs.getRowMeta().getFieldNames(), releaseMidDs.getRowMeta().getFieldNames()).finish();
        joinDs = joinDs.leftJoin(revenueMidDs).on("billno", "loanbillno").select(joinDs.getRowMeta().getFieldNames(), revenueMidDs.getRowMeta().getFieldNames()).finish();
        DataSet dealSurpAmtDs = joinDs.select("id,finorginfo,finorginfonumber,org,orgnumber,billno,investvarieties,investvarietiesnumber,currency,currencyname,currencynamenumber,amount,bizdate,intdate,expiredate,interestrate,demandrate,planamount,finaccount,settleaccount,interesttype,tradechannel,basis,term,redeemamount,totalamount,amount- case when redeemamount is null then 0 else redeemamount end as surplusamount");
        this.buildCalAllDadaParam(queryParam);
        return dealSurpAmtDs;
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("amount_report", "redeemamount_report", "surplusamount_report");
    }

    public List<String> groupFields() {
        return this.groupFields;
    }

    public String sumNameField() {
        return this.sumNameField;
    }

    public String subNameField() {
        return this.subNameField;
    }

    public List<String> orderByFields() {
        return this.orderByFields;
    }

    public List<String> orinalAmountField() {
        return Arrays.asList("amount", "planamount", "redeemamount", "totalamount", "surplusamount");
    }

    private void buildCalAllDadaParam(ReportQueryParam queryParam) {
        boolean isLineTotal = queryParam.getFilter().getBoolean("filter_islinetotal");
        queryParam.getFilter().getFilterItem("filter_isshowsubtotal").setValue((Object)isLineTotal);
        queryParam.getFilter().getFilterItem("filter_isshowtotal").setValue((Object)isLineTotal);
        String statdim = queryParam.getFilter().getString("filter_statdim");
        this.groupFields = new ArrayList<String>(3);
        this.groupFields.add("statcurrency");
        this.orderByFields = new ArrayList<String>(2);
        switch (statdim) {
            case "f": {
                this.groupFields.add("finorginfo");
                this.groupFields.add("finorginfonumber");
                this.orderByFields.add("finorginfonumber");
                this.subNameField = "org";
                this.sumNameField = "finorginfo";
                break;
            }
            case "o": {
                this.groupFields.add("org");
                this.groupFields.add("orgnumber");
                this.orderByFields.add("orgnumber");
                this.subNameField = "finorginfo";
                this.sumNameField = "org";
                break;
            }
            case "v": {
                this.groupFields.add("investvarieties");
                this.groupFields.add("investvarietiesnumber");
                this.orderByFields.add("investvarietiesnumber");
                this.subNameField = "finorginfo";
                this.sumNameField = "investvarieties";
                break;
            }
            case "c": {
                this.groupFields.add("currencyname");
                this.groupFields.add("currencynamenumber");
                this.orderByFields.add("currencynamenumber");
                this.subNameField = "finorginfo";
                this.sumNameField = "currencyname";
                break;
            }
        }
    }

    private List<QFilter> buildCommonFilter(ReportQueryParam queryParam) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        FilterInfo filter = queryParam.getFilter();
        filterList.add(new QFilter("org", "in", (Object)this.getQueryOrgIds(queryParam)));
        this.buildQFilter(filterList, filter, "filter_finorginfo", "finorginfo");
        this.buildQFilter(filterList, filter, "filter_investvarieties", "investvarieties");
        this.buildQFilter(filterList, filter, "filter_currency", "currency");
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter offTradeChannelFilter = new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue());
        QFilter onlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        onlineTradeChannelFilter.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
        QFilter tradeChannelFilter = offTradeChannelFilter.or(onlineTradeChannelFilter);
        filterList.add(tradeChannelFilter);
        return filterList;
    }

    private List<QFilter> buildDepositQueryFilter(List<QFilter> commonList, ReportQueryParam queryParam) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonList);
        FilterInfo filter = queryParam.getFilter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("filter_querycutoffdate", filter.getString("filter_querycutoffdate"));
        paramMap.put("filter_enddate", filter.getDate("filter_enddate"));
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        filterList.add(new QFilter("intdate", "<=", (Object)endDate));
        boolean isInclude = filter.getBoolean("filter_isinclude");
        if (!isInclude) {
            QFilter bizStatusFilter = new QFilter("bizstatus", "!=", (Object)FinServiceStatusEnum.subscribe_end.getValue());
            bizStatusFilter.or("lastredeemdate", ">", (Object)endDate);
            filterList.add(bizStatusFilter);
        }
        this.addIntStartFilter(filterList, filter);
        return filterList;
    }

    private List<QFilter> buildReleaseQueryFilter(List<QFilter> commonList, ReportQueryParam queryParam, DataSet depositDs) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonList);
        FilterInfo filter = queryParam.getFilter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("filter_querycutoffdate", filter.getString("filter_querycutoffdate"));
        paramMap.put("filter_enddate", filter.getDate("filter_enddate"));
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        filterList.add(new QFilter("redeemdate", "<=", (Object)endDate));
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        Iterator iterator = depositDs.iterator();
        ArrayList<Long> depositIds = new ArrayList<Long>(16);
        while (iterator.hasNext()) {
            depositIds.add(((Row)iterator.next()).getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(depositIds)) {
            filterList.add(new QFilter("finbillno.id", "in", depositIds));
        }
        return filterList;
    }

    private List<QFilter> buildRevenueQueryFilter(ReportQueryParam queryParam, DataSet depositDs) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        FilterInfo filter = queryParam.getFilter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("filter_querycutoffdate", filter.getString("filter_querycutoffdate"));
        paramMap.put("filter_enddate", filter.getDate("filter_enddate"));
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        filterList.add(new QFilter("bizdate", "<=", (Object)endDate));
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        Iterator iterator = depositDs.iterator();
        ArrayList<String> depNumbers = new ArrayList<String>(16);
        while (iterator.hasNext()) {
            depNumbers.add(((Row)iterator.next()).getString("billno"));
        }
        if (EmptyUtil.isNoEmpty(depNumbers)) {
            filterList.add(new QFilter("loanbillno", "in", depNumbers));
        }
        return filterList;
    }

    private void buildQFilter(List<QFilter> filterList, FilterInfo filter, String filterColumn, String prop) {
        List investVarsIfm;
        DynamicObjectCollection cols = filter.getDynamicObjectCollection(filterColumn);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cols)) {
            List idList = cols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            filterList.add(new QFilter(prop, "in", idList));
        } else if (StringUtils.equals((CharSequence)"filter_finorginfo", (CharSequence)filterColumn)) {
            List finorginfoIfm = (List)filter.getValue("filter_finorginfo_ifm");
            if (EmptyUtil.isNoEmpty((Object)finorginfoIfm)) {
                filterList.add(new QFilter(prop, "in", (Object)finorginfoIfm));
            }
        } else if (StringUtils.equals((CharSequence)"filter_investvarieties", (CharSequence)filterColumn) && EmptyUtil.isNoEmpty((Object)(investVarsIfm = (List)filter.getValue("filter_investvarieties_ifm")))) {
            filterList.add(new QFilter(prop, "in", (Object)investVarsIfm));
        }
    }

    private String getUpdateTermStr() {
        String termStr = "case when tradechannel='online' and deadline='1' then '" + this.getOneMonth() + "' when tradechannel='online' and deadline='3' then '" + this.getThreeMonth() + "' when tradechannel='online' and deadline='6' then '" + this.getSixMonth() + "' when tradechannel='online' and deadline='12' then '" + this.getOneYear() + "' when tradechannel='online' and deadline='24' then '" + this.getTwoYear() + "' when tradechannel='online' and deadline='36' then '" + this.getThreeYear() + "' when tradechannel='online' and deadline='50' then '" + this.getFiveYear() + "' else term end as term";
        return termStr;
    }

    private String getOneMonth() {
        return ResManager.loadKDString((String)"\u4e00\u4e2a\u6708", (String)"DepositDetailDataPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private String getThreeMonth() {
        return ResManager.loadKDString((String)"\u4e09\u4e2a\u6708", (String)"DepositDetailDataPlugin_2", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private String getSixMonth() {
        return ResManager.loadKDString((String)"\u516d\u4e2a\u6708", (String)"DepositDetailDataPlugin_3", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private String getOneYear() {
        return ResManager.loadKDString((String)"\u4e00\u5e74", (String)"DepositDetailDataPlugin_4", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private String getTwoYear() {
        return ResManager.loadKDString((String)"\u4e24\u5e74", (String)"DepositDetailDataPlugin_5", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private String getThreeYear() {
        return ResManager.loadKDString((String)"\u4e09\u5e74", (String)"DepositDetailDataPlugin_6", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private String getFiveYear() {
        return ResManager.loadKDString((String)"\u4e94\u5e74", (String)"DepositDetailDataPlugin_7", (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private void addIntStartFilter(List<QFilter> filterList, FilterInfo filter) {
        Date intEndDate;
        Date intStartDate;
        String intStart = filter.getString("filter_intstart");
        if (EmptyUtil.isEmpty((String)intStart)) {
            return;
        }
        Date currentDate = DateUtils.getCurrentDate();
        switch (intStart) {
            case "thismonth": {
                intStartDate = DateUtils.getFirstDayOfMonth((Date)currentDate);
                intEndDate = DateUtils.getFirstDateOfNextMonth((Date)currentDate);
                break;
            }
            case "thisweek": {
                intStartDate = DateUtils.getFirstDayOfWeek((Date)currentDate);
                intEndDate = DateUtils.getNextWeekMonday((Date)currentDate);
                break;
            }
            case "thisday": {
                intStartDate = currentDate;
                intEndDate = DateUtils.getNextDay((Date)currentDate, (int)1);
                break;
            }
            default: {
                intStartDate = filter.getDate("selfdefine_startdate");
                intEndDate = DateUtils.getNextDay((Date)filter.getDate("selfdefine_enddate"), (int)1);
            }
        }
        filterList.add(new QFilter("intdate", ">=", (Object)intStartDate));
        filterList.add(new QFilter("intdate", "<", (Object)intEndDate));
    }
}

