/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DepositSumRptDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String DPT_QUERY_FIELDS = "id,0 as pid,org,org.name as orgname,finorginfo,finorginfo.name as finorginfoname,finorginfo.finorgtype.type as finorgtype,investvarieties,investvarieties.name as investvarietiesname,currency,currency.name as currencyname,amount,planamount,billno";
    private static final String REL_QUERY_FIELDS = "id,0 as pid,org,org.name as orgname,finorginfo,finorginfo.name as finorginfoname,finorginfo.finorgtype.type as finorgtype,investvarieties,investvarieties.name as investvarietiesname,currency,currency.name as currencyname,amount as relamount";
    private static final String REV_QUERY_FIELDS = "id,0 as pid,org,org.name as orgname,finorginfo,finorginfo.name as finorginfoname,finorginfo.finorgtype.type as finorgtype,investvarieties,investvarieties.name as investvarietiesname,currency,currency.name as currencyname,actpreinstamt as realrevenue";
    private static final List<String> TREE_LIST_FILTER = Arrays.asList("rowid", "pid", "isgroupnode", "level", "sumlevel");
    private final Map<String, Object> fieldsMap = new HashMap<String, Object>(16);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = queryParam.getCustomParam();
        paramMap.put("filter_statcurrency", ((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue());
        DataSet depositBillDS = this.queryDepositBillDS(paramMap);
        if (ReportHelper.isEmpty(depositBillDS)) {
            return ReportHelper.createEmptyDS();
        }
        DataSet releaseBillDS = this.queryReleaseBillDS(paramMap);
        DataSet resultDS = ReportHelper.isEmpty(releaseBillDS) ? depositBillDS.addFields(new String[]{"0"}, new String[]{"relamount"}) : this.joinResult(depositBillDS, releaseBillDS, this.getStatDimArr(paramMap), false);
        DataSet reveneBillDS = this.queryRevenueBillDS(paramMap);
        resultDS = ReportHelper.isEmpty(reveneBillDS) ? resultDS.addFields(new String[]{"0"}, new String[]{"realrevenue"}) : this.joinResult(resultDS, reveneBillDS, this.getStatDimArr(paramMap), true);
        this.initFields(paramMap);
        resultDS = this.addExtFields(resultDS, paramMap);
        return this.dealBankLevel(resultDS, paramMap);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        Map customParam = queryParam.getCustomParam();
        String statDimStr = (String)customParam.get("filter_statdimstr");
        if ("finorginfo".equals(statDimStr)) {
            dataSet = this.dealFinOrgInfoTreeSet(dataSet, customParam);
        }
        String lvalue = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"DepositSumRptDataListPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]);
        return dataSet.addField("case when sumlevel = 0 then '" + lvalue + "' else '' end as detail", "detail");
    }

    protected DataSet addExchangeRateAndCurrencyUnit(DataSet bizDataSet, Map<String, Object> paramMap) {
        bizDataSet = super.addExchangeRateAndCurrencyUnit(bizDataSet, paramMap);
        Map customParam = this.getQueryParam().getCustomParam();
        String statDimStr = (String)customParam.get("filter_statdimstr");
        String showType = (String)customParam.get("filter_showttype");
        if ("org".equals(statDimStr) && "tile".equals(showType) || "finorginfo".equals(statDimStr)) {
            String[] statDimArr = (String[])customParam.get("filter_statdim");
            bizDataSet = this.groupDs(bizDataSet, statDimArr);
        }
        return bizDataSet;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Map customParam = this.getQueryParam().getCustomParam();
        boolean isLineTotal = (Boolean)customParam.get("filter_islinetotal");
        if (!isLineTotal || EmptyUtil.isEmpty((Object)this.fieldsMap.get("groupFields"))) {
            return bizDs;
        }
        List<String> sumAmountFields = this.sumAmountFields();
        List sGroupByFields = (List)this.fieldsMap.get("sGroupByFields");
        String sumNameField = (String)this.fieldsMap.get("sumNameField");
        String sSumNameField = (String)this.fieldsMap.get("sSumNameField");
        List groupFields = (List)this.fieldsMap.get("groupFields");
        List orderFeilds = (List)this.fieldsMap.get("orderFeilds");
        DataSet smallCalDs = this.addSubTotalDataSet(bizDs, groupFields, sumAmountFields, sumNameField);
        String uniqueRow = this.getUniqueRow(groupFields);
        smallCalDs = smallCalDs.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{uniqueRow, "'0'", "'0'"});
        if (EmptyUtil.isNoEmpty((Object)sGroupByFields)) {
            DataSet smallCalDss = this.addSubTotalDataSet(bizDs.copy(), sGroupByFields, sumAmountFields, sSumNameField);
            uniqueRow = this.getUniqueRow(sGroupByFields);
            smallCalDss = smallCalDss.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{uniqueRow, "'0'", "'0'"});
            smallCalDs = smallCalDs.union(smallCalDss);
        }
        return bizDs.union(smallCalDs).orderBy(orderFeilds.toArray(new String[0]));
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Map customParam = this.getQueryParam().getCustomParam();
        boolean isLineTotal = (Boolean)customParam.get("filter_islinetotal");
        String statDimStr = (String)customParam.get("filter_statdimstr");
        if (!isLineTotal || "finorginfo".equals(statDimStr)) {
            return bizDs;
        }
        return super.addSumRowDataSet(bizDs, paramMap);
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("amount", "relamount", "realrevenue", "surplusamount", "planamount");
    }

    protected String getReportField(String field) {
        return "stat_" + field;
    }

    public String sumNameField() {
        return (String)this.fieldsMap.get("allSumField");
    }

    public List<String> groupFields() {
        List groupFields = (List)this.fieldsMap.get("statDimFields");
        Map customParam = this.getQueryParam().getCustomParam();
        String statDimStr = (String)customParam.get("filter_statdimstr");
        String showType = (String)customParam.get("filter_showttype");
        if ("org".equals(statDimStr) && "tile".equals(showType) || "finorginfo".equals(statDimStr)) {
            groupFields.remove("currency");
        }
        return groupFields;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgname");
    }

    protected boolean isNeedOrgTree() {
        Map customParam = this.getQueryParam().getCustomParam();
        String statDim = (String)customParam.get("filter_statdimstr");
        return "org".equals(statDim);
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("stat_amount", "stat_relamount", "stat_planamount", "stat_realrevenue", "stat_surplusamount");
    }

    public String getBizSelectFields(DataSet bizDs) {
        String[] fields;
        ArrayList<String> selectFields = new ArrayList<String>();
        for (String field : fields = bizDs.getRowMeta().getFieldNames()) {
            if (this.sumAmountFields().contains(field) || TREE_LIST_FILTER.contains(field) || selectFields.contains(field)) continue;
            selectFields.add(field);
        }
        return String.join((CharSequence)",", selectFields.toArray(new String[selectFields.size()]));
    }

    private DataSet groupDs(DataSet dataSet, String[] statDimArr) {
        return dataSet.groupBy(statDimArr).sum("amount").sum("planamount").sum("relamount").sum("realrevenue").sum("surplusamount").sum("stat_amount").sum("stat_planamount").sum("stat_relamount").sum("stat_realrevenue").sum("stat_surplusamount").finish();
    }

    private DataSet queryDepositBillDS(Map<String, Object> paramMap) {
        QFilter queryFilter = this.transQFilter(paramMap, "deposit");
        DataSet depositBillDS = QueryServiceHelper.queryDataSet((String)"depositSumRptQuery", (String)"ifm_deposit", (String)DPT_QUERY_FIELDS, (QFilter[])new QFilter[]{queryFilter}, null);
        if (ReportHelper.isEmpty(depositBillDS)) {
            return ReportHelper.createEmptyDS();
        }
        depositBillDS = depositBillDS.addField("org", "rowid");
        this.addDepositData(depositBillDS, paramMap);
        depositBillDS = depositBillDS.copy().groupBy(this.getStatDimArr(paramMap)).sum("amount").sum("planamount").finish();
        return depositBillDS;
    }

    private String getUniqueRow(List<String> groupFields) {
        StringBuilder uniqueRow = new StringBuilder(this.sumField);
        uniqueRow.append("+'_'");
        for (String groupField : groupFields) {
            uniqueRow.append("+'_'+").append(groupField);
        }
        return uniqueRow.toString();
    }

    private DataSet queryReleaseBillDS(Map<String, Object> paramMap) {
        QFilter queryFilter = this.transQFilter(paramMap, "release");
        DataSet releaseBillDS = QueryServiceHelper.queryDataSet((String)"depositSumRptQuery", (String)"ifm_release", (String)"billno,id,0 as pid,org,org.name as orgname,finorginfo,finorginfo.name as finorginfoname,finorginfo.finorgtype.type as finorgtype,investvarieties,investvarieties.name as investvarietiesname,currency,currency.name as currencyname,amount as relamount", (QFilter[])new QFilter[]{queryFilter}, null);
        if (ReportHelper.isEmpty(releaseBillDS)) {
            return ReportHelper.createEmptyDS();
        }
        releaseBillDS = releaseBillDS.addField("org", "rowid");
        releaseBillDS = releaseBillDS.copy().groupBy(this.getStatDimArr(paramMap)).sum("relamount").finish();
        return releaseBillDS;
    }

    private DataSet queryRevenueBillDS(Map<String, Object> paramMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List depNumbers = (List)paramMap.get("loanbillno");
        filterList.add(new QFilter("loanbillno", "in", (Object)depNumbers));
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        filterList.add(new QFilter("bizdate", "<=", (Object)endDate));
        DataSet dptRevDs = QueryServiceHelper.queryDataSet((String)"depositSumRptQueryRevenue", (String)"ifm_dptrevenue", (String)"billno,id,0 as pid,org,org.name as orgname,finorginfo,finorginfo.name as finorginfoname,finorginfo.finorgtype.type as finorgtype,investvarieties,investvarieties.name as investvarietiesname,currency,currency.name as currencyname,actpreinstamt as realrevenue", (QFilter[])filterList.toArray(new QFilter[0]), null);
        if (ReportHelper.isEmpty(dptRevDs)) {
            return ReportHelper.createEmptyDS();
        }
        dptRevDs = dptRevDs.addField("org", "rowid");
        dptRevDs = dptRevDs.copy().groupBy(this.getStatDimArr(paramMap)).sum("realrevenue").finish();
        return dptRevDs;
    }

    private QFilter transQFilter(Map<String, Object> paramMap, String billType) {
        List productIds;
        List investVarieties;
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        List orgIds = this.getQueryOrgIds(this.getQueryParam());
        qfilter.and(new QFilter("org", "in", (Object)orgIds));
        List finOrgInfoList = (List)paramMap.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoList)) {
            qfilter.and(new QFilter("finorginfo", "in", (Object)finOrgInfoList));
        }
        if (EmptyUtil.isNoEmpty((Object)(investVarieties = (List)paramMap.get("filter_investvarieties")))) {
            qfilter.and(new QFilter("investvarieties", "in", (Object)investVarieties));
        }
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        if (StringUtils.equals((CharSequence)billType, (CharSequence)"deposit")) {
            qfilter.and(new QFilter("intdate", "<=", (Object)endDate));
            Boolean isInclude = (Boolean)paramMap.get("filter_isinclude");
            if (!isInclude.booleanValue()) {
                qfilter.and(new QFilter("bizstatus", "!=", (Object)"subscribe_end").or(new QFilter("lastredeemdate", ">", (Object)endDate)));
            }
            this.addIntStartFilter(paramMap, qfilter);
        } else {
            List depositIds = (List)paramMap.get("finbillno");
            qfilter.and(new QFilter("finbillno", "in", (Object)depositIds));
            qfilter.and(new QFilter("redeemdate", "<=", (Object)endDate));
        }
        qfilter.and(new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue()).or(new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and(new QFilter("bebankstatus", "=", (Object)BebankStatusEnum.TS.getValue()))));
        List currencyIds = (List)paramMap.get("filter_currency");
        if (EmptyUtil.isNoEmpty((Object)currencyIds)) {
            qfilter.and(new QFilter("currency", "in", (Object)currencyIds));
        }
        if (EmptyUtil.isNoEmpty((Object)(productIds = (List)paramMap.get("filter_product")))) {
            qfilter.and(new QFilter("product", "in", (Object)productIds));
        }
        qfilter.and(new QFilter("currency", "!=", (Object)0));
        return qfilter;
    }

    private DataSet joinResult(DataSet depositBillDS, DataSet releaseBillDS, String[] statDimArr, boolean isRevenue) {
        if (ReportHelper.isEmpty(depositBillDS)) {
            return ReportHelper.createEmptyDS();
        }
        if (ReportHelper.isEmpty(releaseBillDS)) {
            return depositBillDS;
        }
        JoinDataSet jds = depositBillDS.join(releaseBillDS, JoinType.LEFT);
        for (String statDim : statDimArr) {
            jds = jds.on(statDim, statDim);
        }
        ArrayList<String> selectFields = new ArrayList<String>(16);
        selectFields.addAll(Arrays.asList(statDimArr));
        if (isRevenue) {
            selectFields.addAll(Arrays.asList("amount", "relamount", "planamount", "realrevenue"));
        } else {
            selectFields.addAll(Arrays.asList("amount", "relamount", "planamount"));
        }
        return jds.select(selectFields.toArray(new String[0])).finish();
    }

    private DataSet addExtFields(DataSet dataSet, Map<String, Object> paramMap) {
        DataSet resultDS = dataSet.addField("case when relamount is null then amount else amount - relamount end", "surplusamount");
        resultDS = resultDS.orderBy((String[])paramMap.get("order_fields"));
        return resultDS;
    }

    private void initFields(Map<String, Object> param) {
        String statDim = (String)param.get("filter_statdimstr");
        List<Object> groupByFields = new ArrayList(10);
        List<Object> sGroupByFields = new ArrayList(10);
        List<String> orderFeilds = new ArrayList<String>(10);
        String allSumField = "";
        String sumNameField = "";
        String sSumNameField = "";
        switch (statDim) {
            case "org,finorginfo,currency": {
                groupByFields = Arrays.asList("org", "orgname", "statcurrency");
                sGroupByFields = Arrays.asList("org", "orgname", "finorginfo", "finorginfoname", "statcurrency");
                orderFeilds = Arrays.asList("org desc", "finorginfo desc", "sumlevel");
                allSumField = "orgname";
                sumNameField = "finorginfoname";
                sSumNameField = "currencyname";
                break;
            }
            case "finorginfo,org,currency": {
                groupByFields = Arrays.asList("finorginfo", "finorginfoname", "statcurrency");
                sGroupByFields = Arrays.asList("finorginfo", "finorginfoname", "org", "orgname", "statcurrency");
                orderFeilds = Arrays.asList("finorginfo desc", "org desc", "sumlevel");
                allSumField = "finorginfoname";
                sumNameField = "orgname";
                sSumNameField = "currencyname";
                break;
            }
            case "finorginfo,currency": {
                groupByFields = Arrays.asList("finorginfo", "finorginfoname", "statcurrency");
                orderFeilds.add("finorginfo");
                allSumField = "finorginfoname";
                sumNameField = "currencyname";
                break;
            }
            case "investvarieties,currency": {
                groupByFields = Arrays.asList("investvarieties", "investvarietiesname", "statcurrency");
                orderFeilds.add("investvarieties");
                allSumField = "investvarietiesname";
                sumNameField = "currencyname";
                break;
            }
            case "org,currency": {
                groupByFields = Arrays.asList("org", "orgname", "statcurrency");
                orderFeilds.add("org");
                allSumField = "orgname";
                sumNameField = "currencyname";
                break;
            }
            case "org": {
                orderFeilds.add("org");
                allSumField = "orgname";
                break;
            }
            case "currency": {
                orderFeilds.add("currency");
                allSumField = "currencyname";
                break;
            }
            case "finorginfo": {
                orderFeilds.add("finorginfo");
                allSumField = "finorginfoname";
            }
        }
        this.fieldsMap.put("statDimFields", Arrays.stream(this.getStatDimArr(param)).collect(Collectors.toList()));
        this.fieldsMap.put("groupFields", groupByFields);
        this.fieldsMap.put("allSumField", allSumField);
        this.fieldsMap.put("sumNameField", sumNameField);
        this.fieldsMap.put("sGroupByFields", sGroupByFields);
        this.fieldsMap.put("sSumNameField", sSumNameField);
        this.fieldsMap.put("orderFeilds", orderFeilds);
    }

    private List<String> getSumFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("stat_relamount");
        fields.add("stat_realrevenue");
        fields.add("stat_amount");
        fields.add("stat_planamount");
        fields.add("stat_surplusamount");
        fields.add("relamount");
        fields.add("realrevenue");
        fields.add("amount");
        fields.add("planamount");
        fields.add("surplusamount");
        return fields;
    }

    private DataSet dealFinOrgInfoTreeSet(DataSet dataSet, Map<String, Object> param) {
        Set<String> types = this.getFinOrgTypes();
        if (EmptyUtil.isEmpty(types)) {
            return dataSet;
        }
        HashMap<String, DataSet> dataMap = new HashMap<String, DataSet>(types.size());
        for (String string : types) {
            dataMap.put(string, dataSet.copy().filter(String.format("finorgtype = '%s'", string)));
        }
        DataSet result = this.dealBankTypeData((DataSet)dataMap.remove("0"));
        if (EmptyUtil.isNoEmpty(dataMap)) {
            for (Map.Entry entry : dataMap.entrySet()) {
                DataSet data = ((DataSet)entry.getValue()).select("finorginfo, finorginfoname, finorgtype, 0 as amount, stat_amount, 0 as relamount, stat_relamount, 0 as planamount, stat_planamount, 0 as realrevenue, stat_realrevenue, 0 as surplusamount, stat_surplusamount, 0 as isgroupnode, finorginfo as rowid, 0 as pid, '' as pname");
                result = result == null ? data : result.union(data);
            }
        }
        if (null == result || result.isEmpty()) {
            return ReportHelper.createEmptyDS();
        }
        result = result.addFields(new String[]{"0", this.getOrderFieldSql(), param.get("filter_statcurrency").toString()}, new String[]{"sumlevel", "orderfield", "statcurrency"}).orderBy(new String[]{"orderfield"});
        boolean bl = (Boolean)param.get("filter_islinetotal");
        if (!bl) {
            return result;
        }
        DataSet dataSet2 = this.addSubTotalDataSet(result.copy().filter("pid=0"), Arrays.asList("finorgtype", "orderfield", "statcurrency"), this.getSumFields(), "finorginfoname").select(new String[]{"finorginfo", this.getFinOrgTypeSql(), "finorgtype", "0 as amount", "stat_amount", "0 as relamount", "stat_relamount", "0 as planamount", "stat_planamount", "0 as realrevenue", "stat_realrevenue", "0 as surplusamount", "stat_surplusamount", "0 as isgroupnode", "orderfield as rowid", "0 as pid", "'' as pname", "1 as sumlevel", "orderfield", "statcurrency"});
        String allSumField = (String)this.fieldsMap.get("allSumField");
        DataSet allCalDs = this.addAllTotalDataSet(result.copy().filter("pid=0"), this.sumAmountFields(), Collections.singletonList("statcurrency"), allSumField);
        allCalDs = allCalDs.updateField("pid", "0 as pid").updateField("rowid", RandomUtils.nextInt() + "");
        return result.union(dataSet2).orderBy(new String[]{"orderfield"}).union(allCalDs);
    }

    private String getFinOrgTypeSql() {
        DynamicObjectCollection finOrgTypes = QueryServiceHelper.query((String)"bd_finorgtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        Set types = finOrgTypes.stream().map(v -> v.getString("type")).collect(Collectors.toSet());
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"bd_finorgtype").getProperty("type");
        List comboItems = property.getComboItems();
        Map<String, LocaleString> combMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
        StringBuilder sb = new StringBuilder();
        sb.append("case ");
        for (String type : types) {
            sb.append(String.format("when finorgtype = '%s' then '%s' ", type, String.format(ResManager.loadKDString((String)"%s\u5c0f\u8ba1", (String)"DepositSumRptDataListPlugin_2", (String)"tmc-cim-report", (Object[])new Object[0]), combMap.get(type))));
        }
        sb.append("end as finorginfoname");
        return sb.toString();
    }

    private String getOrderFieldSql() {
        int i = RandomUtils.nextInt();
        StringBuilder sb = new StringBuilder();
        sb.append("case ");
        int cardinal = 101;
        for (String finOrgType : this.getFinOrgTypes()) {
            sb.append(String.format("when finorgtype = '%s' then %s ", finOrgType, i + cardinal));
            ++cardinal;
        }
        sb.append("end as orderfield");
        return sb.toString();
    }

    private DataSet addBankTypeCol(DataSet allFinDataSets, DataSet dataSet, Set<Object> ids) {
        DataSet thirdsFinDataSet = allFinDataSets.copy().filter(String.format("id in (%s)", this.getIdStr(ids)));
        dataSet = dataSet.join(thirdsFinDataSet.copy(), JoinType.LEFT).on("finorginfo", "id").select(new String[]{"finorginfo", "finorginfoname", "finorgtype", "amount", "stat_amount", "relamount", "stat_relamount", "planamount", "stat_planamount", "realrevenue", "stat_realrevenue", "surplusamount", "stat_surplusamount", "0 as isgroupnode"}, new String[]{"id as rowid", "bank_cate as pid", "pcatename as pname"}).finish();
        dataSet = dataSet.union(this.getParentSumDs(dataSet));
        return dataSet;
    }

    private String getIdStr(Set<Object> banks) {
        StringJoiner stringJoiner = new StringJoiner(",");
        banks.stream().map(String::valueOf).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private DataSet getParentSumDs(DataSet bankDs) {
        DataSet pidGroupDataSet = bankDs.copy().filter("pid > 0").groupBy(new String[]{"pid", "pname"}).sum("stat_amount").sum("stat_planamount").sum("stat_realrevenue").sum("stat_surplusamount").sum("stat_relamount").finish();
        return pidGroupDataSet.select("pid as finorginfo, pname as finorginfoname, '0' as finorgtype, 0 as amount, stat_amount, 0 as relamount, stat_relamount, 0 as planamount, stat_planamount, 0 as realrevenue, stat_realrevenue, 0 as surplusamount, stat_surplusamount, 1 as isgroupnode,pid as rowid, 0 as pid, pname");
    }

    private String[] getStatDimArr(Map<String, Object> paramMap) {
        String statDimStr = (String)paramMap.get("filter_statdimstr");
        String[] statDimArr = (String[])paramMap.get("filter_statdim");
        if ("org".equals(statDimStr) || "finorginfo".equals(statDimStr)) {
            int length = statDimArr.length;
            statDimArr = Arrays.copyOf(statDimArr, length + 1);
            statDimArr[length] = "currency";
        }
        return statDimArr;
    }

    private Set<String> getFinOrgTypes() {
        DynamicObjectCollection finOrgTypes = QueryServiceHelper.query((String)"bd_finorgtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)finOrgTypes)) {
            return new HashSet<String>();
        }
        return finOrgTypes.stream().map(v -> v.getString("type")).collect(Collectors.toSet());
    }

    private DataSet dealBankTypeData(DataSet bankDS) {
        if (ReportHelper.isEmpty(bankDS)) {
            return null;
        }
        HashSet<Object> bankInfoIds = new HashSet<Object>();
        for (Row row : bankDS.copy()) {
            bankInfoIds.add(row.getLong("finorginfo"));
        }
        DataSet banInfoDataSet = QueryServiceHelper.queryDataSet((String)"bd_finorginfo_tree", (String)"bd_finorginfo", (String)"id,bank_cate,bank_cate.name pcatename ,finorgtype,finorgtype.name ptypename", (QFilter[])new QFilter("id", "in", bankInfoIds).toArray(), (String)"createtime");
        if (EmptyUtil.isNoEmpty(bankInfoIds)) {
            bankDS = this.addBankTypeCol(banInfoDataSet, bankDS, bankInfoIds);
        }
        return bankDS;
    }

    private void addDepositData(DataSet dataSet, Map<String, Object> param) {
        ArrayList<Object> depositIds = new ArrayList<Object>(16);
        ArrayList<String> depNumbers = new ArrayList<String>(16);
        for (Row row : dataSet.copy()) {
            depositIds.add(row.get("id"));
            depNumbers.add(row.getString("billno"));
        }
        param.put("finbillno", depositIds);
        param.put("loanbillno", depNumbers);
    }

    private DataSet dealBankLevel(DataSet dataSet, Map<String, Object> param) {
        String bankLevel = (String)param.get("filter_level");
        if (EmptyUtil.isEmpty((String)bankLevel) || StringUtils.equals((CharSequence)bankLevel, (CharSequence)"2")) {
            return dataSet;
        }
        ArrayList<Long> finOrgIds = new ArrayList<Long>();
        for (Row row : dataSet.copy()) {
            finOrgIds.add(row.getLong("finorginfo"));
        }
        DataSet finOrgDS = QueryServiceHelper.queryDataSet((String)"dealBankLevelQuery", (String)"bd_finorginfo", (String)"id,finorgtype.type as finorgtype, bank_cate.name ptypename,bank_cate.id as bankcateid", (QFilter[])new QFilter[]{new QFilter("id", "in", finOrgIds)}, null);
        DataSet reslutDS = dataSet.leftJoin(finOrgDS).on("finorginfo", "id").select(dataSet.getRowMeta().getFieldNames(), new String[]{"finorgtype", "ptypename", "bankcateid"}).finish();
        DataSet bankDS = reslutDS.copy().filter("finorgtype = '0'").updateFields(new String[]{"finorginfoname", "finorginfo"}, new String[]{"ptypename", "bankcateid"});
        bankDS = bankDS.orderBy(new String[]{"finorgtype"}).groupBy(this.getStatDimArr(param)).sum("amount").sum("relamount").sum("planamount").sum("realrevenue").sum("surplusamount").finish().addField("'0'", "finorgtype");
        return reslutDS.filter("finorgtype != '0'").select(bankDS.getRowMeta().getFieldNames()).union(bankDS).orderBy(new String[]{"finorgtype"});
    }

    private void addIntStartFilter(Map paramMap, QFilter qfilter) {
        Date intEndDate;
        Date intStartDate;
        String intStart = (String)paramMap.get("filter_intstart");
        if (EmptyUtil.isEmpty((String)intStart)) {
            return;
        }
        Date currentDate = DateUtils.getCurrentDate();
        switch (intStart) {
            case "thismonth": {
                intStartDate = DateUtils.getFirstDayOfMonth((Date)currentDate);
                intEndDate = DateUtils.getFirstDateOfNextMonth((Date)currentDate);
                break;
            }
            case "thisweek": {
                intStartDate = DateUtils.getFirstDayOfWeek((Date)currentDate);
                intEndDate = DateUtils.getNextWeekMonday((Date)currentDate);
                break;
            }
            case "thisday": {
                intStartDate = currentDate;
                intEndDate = DateUtils.getNextDay((Date)currentDate, (int)1);
                break;
            }
            default: {
                intStartDate = (Date)paramMap.get("selfdefine_startdate");
                intEndDate = DateUtils.getNextDay((Date)((Date)paramMap.get("selfdefine_enddate")), (int)1);
            }
        }
        qfilter.and(new QFilter("intdate", ">=", (Object)intStartDate));
        qfilter.and(new QFilter("intdate", "<", (Object)intEndDate));
    }
}

