/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class DetailReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String FINSUBSCRIBE_PROPS = "id as finid,case when finorginfo.bank_cate.name is null then finorginfo.name else finorginfo.bank_cate.name end as finorginfomain,finorginfo.name as finorgname,finorginfo.id as finorginfo,org.id as org,org.name as orgname,finaccount,investvarieties.id as investvarieties,investvarieties.name as investvarietyname,currency.id as currencyid,currency.id as currency,currency.name as currencyname, productno,productname,billno as finsubscribeno,amount,buycopies,iopv,surpluscopies,purchasedate,expiredate,basis,revenuetype,term,'0' as isbreakeven,creator,redeemway,finservicestatus,cleardate";
    private static final String REVENUE_RPOPS = "finbillno.id as finbillid,revenueamount as planamount,amount as realamount";
    private static final String REDEEM_RPOPS = "finbillno.id as finbillid,amount as totalamount,redeemdate,copies as totalcopies,iopv as reviopv,case when redeemway='copies_redeem' then realrevenue else 0 end as realrevenue ";
    private static final String[] ORDERBY_DIM_FINORG = new String[]{"finorginfomain", "sumlevel", "finorgname", "orgname"};
    private static final String[] ORDERBY_DIM_ORG = new String[]{"orgname", "sumlevel", "finorginfomain", "finorgname"};
    private static final String[] ORDERBY_DIM_INVESTVARIETIE = new String[]{"investvarietyname", "sumlevel", "finorginfomain", "finorgname", "orgname"};
    private static final String[] ORDERBY_DIM_FINACCT = new String[]{"finaccount", "sumlevel", "finorginfomain", "finorgname", "orgname"};
    private static final String[] ORDERBY_DIM_CURRENCY = new String[]{"currencyname", "sumlevel", "finorginfomain", "finorgname", "orgname"};

    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        QFilter finSubFilter = this.buildFinSubQueryFilter(paramMap, this.getQueryOrgIds(param));
        DataSet finSubscribeDS = QueryServiceHelper.queryDataSet((String)"finsubscribe", (String)"cim_finsubscribe", (String)FINSUBSCRIBE_PROPS, (QFilter[])finSubFilter.toArray(), (String)"");
        if (finSubscribeDS.isEmpty()) {
            return finSubscribeDS;
        }
        List<Long> fsIds = this.getFinSubscribeIds(finSubscribeDS);
        QFilter redeemFilter = this.buildRedeemQueryFilter(fsIds, paramMap);
        DataSet redeemDs = QueryServiceHelper.queryDataSet((String)"queryredeem", (String)"cim_redeem", (String)REDEEM_RPOPS, (QFilter[])redeemFilter.toArray(), (String)"");
        String[] finDsProps = finSubscribeDS.getRowMeta().getFieldNames();
        DataSet joinedDs = finSubscribeDS.leftJoin(redeemDs).on("finid", "finbillid").select(finDsProps, redeemDs.getRowMeta().getFieldNames()).finish();
        joinedDs = this.dealDataSetByIsInclude(joinedDs, paramMap);
        joinedDs = joinedDs.groupBy(finDsProps).sum("totalamount").sum("totalcopies").sum("realrevenue").avg("reviopv").finish();
        QFilter revenueFilter = this.buildRevenueQueryFilter(paramMap, fsIds);
        DataSet revenueDs = QueryServiceHelper.queryDataSet((String)"Query_Revenue", (String)"cim_revenue", (String)REVENUE_RPOPS, (QFilter[])new QFilter[]{revenueFilter}, null);
        revenueDs = revenueDs.groupBy(new String[]{"finbillid"}).sum("realamount").sum("planamount").finish();
        DataSet allJoinedDs = joinedDs.leftJoin(revenueDs).on("finid", "finbillid").select(joinedDs.getRowMeta().getFieldNames(), new String[]{"realamount", "planamount"}).finish();
        allJoinedDs = allJoinedDs.updateField("realamount", "case when realrevenue is null then 0 else realrevenue end + case when realamount is null then 0 else realamount end").updateField("planamount", "case when realrevenue is null then 0 else realrevenue end + case when planamount is null then 0 else planamount end").addField("amount- case when totalamount is null then 0 else totalamount end", "surplusamount").addField("finid", "id");
        return allJoinedDs;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.addField("rate", "exchrate");
        String lvalue = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"DepositSumRptDataListPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]);
        dataSet = dataSet.addField("case when sumlevel = 0 then '" + lvalue + "' else '' end as detail", "opercol");
        return dataSet;
    }

    private List<Long> getFinSubscribeIds(DataSet finSubscribeDS) {
        DataSet fsDS = finSubscribeDS.copy();
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : fsDS) {
            ids.add(row.getLong("finid"));
        }
        return ids;
    }

    private String[] getOrderbyByDim(String statdim) {
        String[] ret = ORDERBY_DIM_FINORG;
        switch (statdim) {
            case "org": {
                ret = ORDERBY_DIM_ORG;
                break;
            }
            case "investvarieties": {
                ret = ORDERBY_DIM_INVESTVARIETIE;
                break;
            }
            case "finaccount": {
                ret = ORDERBY_DIM_FINACCT;
                break;
            }
            case "currency": {
                ret = ORDERBY_DIM_CURRENCY;
                break;
            }
        }
        return ret;
    }

    private String getTotalFieldByDim(String statdim) {
        String field = "finorginfomain";
        switch (statdim) {
            case "finorginfo": {
                field = "finorginfomain";
                break;
            }
            case "org": {
                field = "orgname";
                break;
            }
            case "investvarieties": {
                field = "investvarietyname";
                break;
            }
            case "finaccount": {
                field = "finaccount";
                break;
            }
            case "currency": {
                field = "currencyname";
                break;
            }
        }
        return field;
    }

    private List<String> getGroupFieldsByDim(String statdim) {
        ArrayList<String> groupFields = new ArrayList<String>(4);
        switch (statdim) {
            case "finorginfo": {
                groupFields.add("finorginfomain");
                break;
            }
            case "org": {
                groupFields.add("orgname");
                break;
            }
            case "investvarieties": {
                groupFields.add("investvarietyname");
                break;
            }
            case "finaccount": {
                groupFields.add("finaccount");
                break;
            }
            case "currency": {
                groupFields.add("currencyname");
                break;
            }
            default: {
                groupFields.add("finorginfomain");
            }
        }
        groupFields.add("statcurrency");
        return groupFields;
    }

    private QFilter buildFinSubQueryFilter(Map<String, Object> paramMap, List<Long> queryOrgIds) {
        QFilter finSubFilter = ReportHelper.initMultiReportFilter(paramMap, queryOrgIds);
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        finSubFilter.and(new QFilter("valuedate", "<=", (Object)endDate));
        ReportQueryParam queryParam = this.getQueryParam();
        if (EmptyUtil.isNoEmpty((Object)queryParam)) {
            List tableHeadFilters = queryParam.getFilter().getTableHeadFilterItems();
            for (FilterItemInfo filterItemInfo : tableHeadFilters) {
                if (!"finsubscribeno".equals(filterItemInfo.getPropName())) continue;
                finSubFilter.and(this.filterItemInfoToQFilter("billno", filterItemInfo));
            }
        }
        this.addIntStartFilter(paramMap, finSubFilter);
        this.buildCommonFilter(paramMap, finSubFilter);
        return finSubFilter;
    }

    private QFilter buildRedeemQueryFilter(List<Long> fsIds, Map<String, Object> paramMap) {
        QFilter redeem = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        redeem.and(new QFilter("finbillno.id", "in", fsIds));
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        redeem.and(new QFilter("redeemdate", "<=", (Object)endDate));
        this.buildCommonFilter(paramMap, redeem);
        return redeem;
    }

    private QFilter buildRevenueQueryFilter(Map<String, Object> paramMap, List<Long> finSubscribeIds) {
        QFilter revenue = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("finbillno.id", "in", finSubscribeIds));
        Date endDate = ReportHelper.getCutOffDate(paramMap);
        revenue.and(new QFilter("datasource", "=", (Object)"revenue"));
        revenue.and(new QFilter("expiredate", "<=", (Object)endDate));
        return revenue;
    }

    private DataSet dealDataSetByIsInclude(DataSet afterJoinDs, Map<String, Object> paraMap) {
        boolean isInclude = (Boolean)paraMap.get("filter_isinclude");
        if (!isInclude) {
            Date endDate = ReportHelper.getCutOffDate(paraMap);
            DataSet needRemoveDs = afterJoinDs.copy().filter("finservicestatus = 'subscribe_end' and to_char(redeemdate,'yyyy-MM-dd') <='" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd") + "' and to_char(cleardate,'yyyy-MM-dd') <='" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd") + "'");
            ArrayList needRemoveFinsubIds = new ArrayList(16);
            needRemoveDs.forEach(r -> needRemoveFinsubIds.add(r.getLong("finid") + ""));
            if (EmptyUtil.isNoEmpty(needRemoveFinsubIds)) {
                afterJoinDs = afterJoinDs.filter("finid not in (" + String.join((CharSequence)",", needRemoveFinsubIds) + ")");
            }
        }
        return afterJoinDs;
    }

    private QFilter filterItemInfoToQFilter(String property, FilterItemInfo filterItemInfo) {
        String cp = filterItemInfo.getCompareType();
        QFilter qFilter = null;
        switch (cp) {
            case "LIKE": {
                qFilter = new QFilter(property, "like", (Object)("%" + filterItemInfo.getValue() + "%"));
                break;
            }
            case "NOT LIKE": {
                qFilter = new QFilter(property, "not like", (Object)("%" + filterItemInfo.getValue() + "%"));
                break;
            }
            case "=": {
                qFilter = new QFilter(property, "=", filterItemInfo.getValue());
                break;
            }
            case "<>": {
                qFilter = new QFilter(property, "!=", filterItemInfo.getValue());
                break;
            }
            case "lIKE": {
                qFilter = new QFilter(property, "like", (Object)(filterItemInfo.getValue() + "%"));
                break;
            }
            case "like": {
                qFilter = new QFilter(property, "like", (Object)("%" + filterItemInfo.getValue()));
                break;
            }
            case "ISNULL": {
                qFilter = new QFilter(property, "is null", null);
                break;
            }
            case "NOTISNULL": {
                qFilter = new QFilter(property, "is not null", null);
                break;
            }
        }
        return qFilter;
    }

    public String sumNameField() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return this.getTotalFieldByDim(statdim);
    }

    protected List<String> orinalAmountField() {
        ArrayList<String> amountFields = new ArrayList<String>(10);
        amountFields.add("amount");
        amountFields.add("surplusamount");
        amountFields.add("planamount");
        amountFields.add("realamount");
        amountFields.add("iopv");
        amountFields.add("totalamount");
        amountFields.add("reviopv");
        return amountFields;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(10);
        sumFields.add("amount_report");
        sumFields.add("surplusamount_report");
        sumFields.add("planamount_report");
        sumFields.add("realamount_report");
        sumFields.add("totalamount_report");
        return sumFields;
    }

    public List<String> groupFields() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return this.getGroupFieldsByDim(statdim);
    }

    public List<String> orderByFields() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return Arrays.stream(this.getOrderbyByDim(statdim)).collect(Collectors.toList());
    }

    private void addIntStartFilter(Map paramMap, QFilter filter) {
        Date intEndDate;
        Date intStartDate;
        String intStart = (String)paramMap.get("filter_intstart");
        if (EmptyUtil.isEmpty((String)intStart)) {
            return;
        }
        if ("custom".equals(intStart) && EmptyUtil.isEmpty(paramMap.get("selfdefine_enddate")) && EmptyUtil.isEmpty(paramMap.get("selfdefine_startdate"))) {
            return;
        }
        Date currentDate = DateUtils.getCurrentDate();
        switch (intStart) {
            case "thismonth": {
                intStartDate = DateUtils.getFirstDayOfMonth((Date)currentDate);
                intEndDate = DateUtils.getFirstDateOfNextMonth((Date)currentDate);
                break;
            }
            case "thisweek": {
                intStartDate = DateUtils.getFirstDayOfWeek((Date)currentDate);
                intEndDate = DateUtils.getNextWeekMonday((Date)currentDate);
                break;
            }
            case "thisday": {
                intStartDate = currentDate;
                intEndDate = DateUtils.getNextDay((Date)currentDate, (int)1);
                break;
            }
            default: {
                intStartDate = (Date)paramMap.get("selfdefine_startdate");
                intEndDate = DateUtils.getNextDay((Date)((Date)paramMap.get("selfdefine_enddate")), (int)1);
            }
        }
        filter.and(new QFilter("valuedate", ">=", (Object)intStartDate));
        filter.and(new QFilter("valuedate", "<", (Object)intEndDate));
    }

    private void addRedeemWayFilter(QFilter filter, Map<String, Object> paramMap) {
        String redeemWay = (String)paramMap.get("filter_redeemway1");
        if (EmptyUtil.isNoEmpty((String)redeemWay)) {
            filter.and("redeemway", "in", (Object)redeemWay.split(","));
        }
    }

    private void addTradeChannelFilter(QFilter filter) {
        QFilter offTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.OFFLINE.getValue());
        QFilter onlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        onlineTradeChannelFilter.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()).or(new QFilter("isrenewal", "=", (Object)Boolean.TRUE)));
        QFilter tradeChannelFilter = offTradeChannelFilter.or(onlineTradeChannelFilter);
        filter.and(tradeChannelFilter);
    }

    private void buildCommonFilter(Map<String, Object> paramMap, QFilter filter) {
        this.addRedeemWayFilter(filter, paramMap);
        this.addTradeChannelFilter(filter);
    }
}

