/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.report.helper.DepositReportHelper;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SumReportDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String FINSUB_SELECT = "id,org,org.name as orgname,finorginfo,finorginfo.name as finorginfoname,investvarieties as invest,investvarieties.name as investname,currency,currency.name as currencyname,amount as oriamt,buycopies,finservicestatus,iopv,cleardate";
    private static final String REDEEM_SELECT = "finbillno,amount as oriredeemamt,copies,redeemdate as lastredeemdate,case when redeemway='copies_redeem' then realrevenue else 0 end as factrevenue";
    private static final String REVENUE_SELECT = "finbillno,amount as orirealamt,revenueamount as orifutureamt";
    private static final String BANKLEVEL_SELECT = "finorginfoname,finorginfo,rowid,pid,statamt, statredeemamt, statsurpamt, statfutureamt, statrealamt, amount, redeemamount,surplusamount, futureamount, realrevenue, buycopies, copies, surpluscopies, sumlevel, secondlevel,isgroupnode,type";

    public DataSet query(ReportQueryParam queryParam) {
        Map paraMap = this.transQueryParam(queryParam);
        if ("o".equals(paraMap.get("filter_statdim")) && "step".equals(paraMap.get("filter_showttype"))) {
            DataSet abstractDataSet = super.query(queryParam);
            if (abstractDataSet == null || abstractDataSet.isEmpty()) {
                return abstractDataSet;
            }
            abstractDataSet = abstractDataSet.addField(((DynamicObject)paraMap.get("filter_statcurrency")).getPkValue() + "", "tocurrency");
            return this.addDetail(abstractDataSet);
        }
        return this.queryDataSetByTile(queryParam);
    }

    public DataSet queryDataSetByTile(ReportQueryParam queryParam) {
        Map paraMap = this.transQueryParam(queryParam);
        DataSet dataSet = this.queryDataSetCommon(queryParam);
        DataSet resultDs = this.buildCalAllDataSet(dataSet, paraMap);
        if (!"f".equals(paraMap.get("filter_statdim"))) {
            String dimField = (String)paraMap.get("stat_dimfield");
            List<String> groupList = this.buildGroupField(dimField);
            resultDs = resultDs.updateField("rowid", this.getUniqueRow(groupList));
        }
        resultDs = resultDs.addField(((DynamicObject)paraMap.get("filter_statcurrency")).getPkValue() + "L", "tocurrency");
        return this.addDetail(resultDs);
    }

    public DataSet queryDataSetCommon(ReportQueryParam queryParam) {
        Map paraMap = this.transQueryParam(queryParam);
        paraMap.put("filter_org", this.getQueryOrgIds(queryParam));
        List<QFilter> commonFilters = this.buildCommonFilter(paraMap);
        List<QFilter> finSubFilters = this.buildFinSubQueryFilter(commonFilters, paraMap);
        DataSet finSubDs = QueryServiceHelper.queryDataSet((String)"SumReportDataPlugin_QueryFinSub", (String)"cim_finsubscribe", (String)FINSUB_SELECT, (QFilter[])finSubFilters.toArray(new QFilter[0]), (String)"");
        List<QFilter> redeemFilters = this.buildRedeemQueryFilter(commonFilters, paraMap, finSubDs);
        DataSet redeemDs = QueryServiceHelper.queryDataSet((String)"SumReportDataPlugin_QueryRedeem", (String)"cim_redeem", (String)REDEEM_SELECT, (QFilter[])redeemFilters.toArray(new QFilter[0]), (String)"");
        CharSequence[] finSubProps = finSubDs.getRowMeta().getFieldNames();
        DataSet afterJoinDs = finSubDs.leftJoin(redeemDs).on("id", "finbillno").select((String[])finSubProps, redeemDs.getRowMeta().getFieldNames()).finish();
        afterJoinDs = this.dealDataSetByIsInclude(afterJoinDs, paraMap);
        DataSet distinctDs = afterJoinDs.groupBy((String[])finSubProps).sum("oriredeemamt").sum("copies").sum("factrevenue").finish().select(String.join((CharSequence)",", finSubProps) + ",oriredeemamt,copies,factrevenue");
        List<QFilter> revenueFilters = this.buildRevenueQueryFilter(distinctDs, paraMap);
        DataSet revenueDs = QueryServiceHelper.queryDataSet((String)"SumReportDataPlugin_QueryRevenue", (String)"cim_revenue", (String)REVENUE_SELECT, (QFilter[])revenueFilters.toArray(new QFilter[0]), (String)"");
        DataSet distinctRevenueDs = revenueDs.groupBy(new String[]{"finbillno"}).sum("orirealamt").sum("orifutureamt").finish();
        DataSet threeJoinedDs = distinctDs.leftJoin(distinctRevenueDs).on("id", "finbillno").select(distinctDs.getRowMeta().getFieldNames(), new String[]{"orirealamt", "orifutureamt"}).finish().select(String.join((CharSequence)",", finSubProps) + ",oriredeemamt,copies,factrevenue,case when orirealamt is not null then orirealamt else 0 end +case when factrevenue is null then 0 else factrevenue end as orirealamt,case when orifutureamt is not null then orifutureamt else 0 end +case when factrevenue is null then 0 else factrevenue end as orifutureamt");
        DataSet afterExchangedDs = this.getDsConverEx(threeJoinedDs, paraMap);
        return this.dealDataSetByStatDim(afterExchangedDs, paraMap);
    }

    private DataSet buildCalAllDataSet(DataSet dataSet, Map<String, Object> paraMap) {
        String statDim = (String)paraMap.get("filter_statdim");
        List<String> finList = Arrays.asList("ofc", "foc", "fc");
        String dimField = (String)paraMap.get("stat_dimfield");
        if (finList.contains(statDim) && "1".equals(paraMap.get("filter_banklevel"))) {
            dataSet = this.groupByBankLevelDataSet(dataSet, dimField);
        }
        List<String> sumFields = Arrays.asList("statamt", "statredeemamt", "statsurpamt", "statfutureamt", "statrealamt", "amount", "redeemamount", "surplusamount", "futureamount", "realrevenue", "buycopies", "copies", "surpluscopies");
        DataSet allCalDs = this.addAllTotalDataSet(dataSet, sumFields, null, dimField.split("\\+")[0] + "name");
        allCalDs = allCalDs.updateFields(new String[]{"rowid", "pid"}, new String[]{RandomUtils.nextInt() + "", "0"});
        DataSet resultDs = this.isTreeDataSet(paraMap) ? this.operateOrgTreeDataSet(allCalDs, dataSet, paraMap, sumFields) : (this.isFinTreeDataSet(paraMap) ? this.operateFinTreeDataSet(allCalDs, dataSet, paraMap, sumFields) : this.operateNotTreeDataSet(allCalDs, dataSet, paraMap, sumFields));
        return resultDs;
    }

    private DataSet operateNotTreeDataSet(DataSet allCalDs, DataSet dataSet, Map<String, Object> paraMap, List<String> sumFields) {
        boolean isNeedAllCal = (Boolean)paraMap.get("filter_islinetotal");
        DataSet resultDs = dataSet;
        if (isNeedAllCal) {
            DataSet baseDs = Algo.create((String)"SumReportDataPlugin_EmptyDataSet").createDataSetBuilder(dataSet.getRowMeta()).build();
            int i = 0;
            String tmpStr = (String)paraMap.get("stat_dimfield");
            String sumNameField = (String)paraMap.get("stat_sumfield");
            String orderByField = (String)paraMap.get("stat_orderfield");
            while (tmpStr.lastIndexOf("+") > 0) {
                tmpStr = tmpStr.substring(0, tmpStr.lastIndexOf("+"));
                List<String> subGroupList = this.buildGroupField(tmpStr);
                DataSet smallCalDs = this.addSubTotalDataSet(dataSet, subGroupList, sumFields, sumNameField.split(",")[i]);
                smallCalDs = smallCalDs.updateField("rowid", tmpStr + "+oriamt+copies").updateField("pid", "0");
                smallCalDs = i == sumNameField.split(",").length - 1 ? smallCalDs.updateField("secondlevel", "1") : smallCalDs.updateField("secondlevel", "0");
                baseDs = baseDs.union(smallCalDs);
                ++i;
            }
            resultDs = dataSet.union(baseDs).orderBy(orderByField.split(","));
            resultDs = resultDs.union(allCalDs);
        }
        return resultDs;
    }

    private DataSet operateFinTreeDataSet(DataSet allCalDs, DataSet dataSet, Map<String, Object> paraMap, List<String> sumFields) {
        DataSet distinctFinDs = dataSet.copy().groupBy(new String[]{"finorginfo"}).finish();
        ArrayList finOrgIdList = new ArrayList();
        distinctFinDs.forEach(r -> finOrgIdList.add(r.getLong("finorginfo")));
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)"SumReportDataPlugin_QueryFinOrgInfo", (String)"bd_finorginfo", (String)"id,bank_cate as bankcg,bank_cate.name bankcgname,finorgtype,finorgtype.name as typename,finorgtype.type as type", (QFilter[])new QFilter[]{new QFilter("id", "in", finOrgIdList)}, (String)"");
        DataSet afterJoined = dataSet.join(finOrgDs).on("finorginfo", "id").select(dataSet.getRowMeta().getFieldNames(), new String[]{"finorgtype", "typename", "type", "bankcg", "bankcgname"}).finish();
        DataSet bankDs = afterJoined.copy().filter("type='0'");
        bankDs = bankDs.select("finorginfoname,finorginfo,finorginfo as rowid,bankcg as pid,bankcgname as pname, statamt, statredeemamt, statsurpamt, statfutureamt, statrealamt, amount, redeemamount,surplusamount, futureamount, realrevenue, buycopies, copies, surpluscopies, sumlevel, secondlevel,0 as isgroupnode,type");
        GroupbyDataSet bankGroupDs = bankDs.copy().filter("pid > 0").groupBy(new String[]{"pid", "pname"});
        for (String sumField : sumFields) {
            bankGroupDs.sum(sumField);
        }
        DataSet parentDs = bankGroupDs.finish().select("pid as finorginfo, pname as finorginfoname,1 as isgroupnode,pid as rowid, 0 as pid, pname, statamt, statredeemamt,statsurpamt, statfutureamt, statrealamt, amount, redeemamount,surplusamount, futureamount, realrevenue,buycopies,copies,surpluscopies, 0 as sumlevel,0 as secondlevel,'0' as type");
        bankDs = bankDs.select(BANKLEVEL_SELECT);
        bankDs = bankDs.union(parentDs.select(BANKLEVEL_SELECT));
        DataSet notBankDs = afterJoined.copy().filter("type !='0'").addField("0", "isgroupnode");
        DataSet resultDs = bankDs.union(notBankDs.select(BANKLEVEL_SELECT));
        boolean isNeedAllCal = (Boolean)paraMap.get("filter_islinetotal");
        if (isNeedAllCal) {
            GroupbyDataSet groupbyDataSet = afterJoined.groupBy(new String[]{"finorgtype", "typename", "type"});
            for (String sumField : sumFields) {
                groupbyDataSet.sum(sumField);
            }
            DataSet smallCalDs = groupbyDataSet.finish().select(this.getBankSmallCalStr());
            resultDs = resultDs.union(smallCalDs.select(BANKLEVEL_SELECT)).orderBy(new String[]{"type", "secondlevel", "finorginfo"});
            allCalDs = allCalDs.addFields(new String[]{"'0'", "0"}, new String[]{"type", "isgroupnode"});
            resultDs = resultDs.union(allCalDs.select(BANKLEVEL_SELECT));
        }
        return resultDs;
    }

    private String getBankSmallCalStr() {
        String str = "finorgtype as finorginfo,finorgtype as rowid,typename as pname, concat(typename,'%s') as finorginfoname, statamt, statredeemamt, statsurpamt, statfutureamt, statrealamt, amount, redeemamount, surplusamount, futureamount, realrevenue,buycopies,copies,surpluscopies,0 as pid,1 as sumlevel,1 as secondlevel,0 as isgroupnode,type";
        return String.format(str, ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"SumReportDataPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]));
    }

    private DataSet operateOrgTreeDataSet(DataSet allCalDs, DataSet dataSet, Map<String, Object> paraMap, List<String> sumFields) {
        Long orgView = (Long)paraMap.get("filter_orgview");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.addAll(Arrays.asList(fieldNames));
        fieldList.remove("orgname");
        fieldList.remove("rowid");
        fieldList.remove("pid");
        DataSet baseTreeDs = orgDateSet.leftJoin(dataSet).on("rowid", "org").select(new String[]{"rowid", "orgname", "pid", "isgroupnode", "level"}, fieldList.toArray(new String[0])).finish();
        baseTreeDs = this.getSumDataSetByLevel(baseTreeDs, sumFields, "orgname");
        DataSet resultDs = this.removeNoDataTreeDs(baseTreeDs, sumFields);
        boolean isNeedAllCal = (Boolean)paraMap.get("filter_islinetotal");
        if (isNeedAllCal) {
            allCalDs = allCalDs.addField("'0'", "isgroupnode").addField("0", "level").addField("0", "parentid").select(resultDs.getRowMeta().getFieldNames());
            resultDs = resultDs.union(allCalDs);
        }
        return resultDs;
    }

    private DataSet groupByBankLevelDataSet(DataSet dataSet, String dimField) {
        String[] needSumArr;
        dataSet = this.dealDataSetByBankLevel(dataSet);
        List<String> groupList = this.buildGroupField(dimField);
        GroupbyDataSet groupByDs = dataSet.groupBy(groupList.toArray(new String[0]));
        String needSumStr = "oriamt,oriredeemamt,orisurpamt,orifutureamt,orirealamt,statamt,statredeemamt,statsurpamt,statfutureamt,statrealamt,amount,redeemamount,surplusamount,futureamount,realrevenue,buycopies,copies,surpluscopies";
        for (String s : needSumArr = needSumStr.split(",")) {
            groupByDs.sum(s);
        }
        dimField = dimField + "+oriamt+copies";
        return groupByDs.finish().addFields(new String[]{dimField, "0", "0", "0"}, new String[]{"rowid", "pid", "sumlevel", "secondlevel"});
    }

    private DataSet dealDataSetByBankLevel(DataSet dataSet) {
        DataSet bankDs = dataSet.copy().select("finorginfo").distinct();
        HashSet bankSet = new HashSet();
        bankDs.forEach(r -> bankSet.add(r.getLong("finorginfo")));
        QFilter bankQF = new QFilter("id", "in", bankSet);
        DataSet bdBankDs = QueryServiceHelper.queryDataSet((String)"SumReportDataPlugin_Finorginfo", (String)CreditorTypeEnum.BANK.getFormId(), (String)"id bankid, bank_cate.name bankcgname,bank_cate.id bankcg", (QFilter[])bankQF.toArray(), null);
        ArrayList<String> propList = new ArrayList<String>();
        List<String> oriPropList = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        propList.addAll(oriPropList);
        propList.remove("finorginfo");
        propList.remove("finorginfoname");
        return dataSet.leftJoin(bdBankDs).on("finorginfo", "bankid").select(propList.toArray(new String[0]), new String[]{"case when bankcgname !=null then bankcgname else finorginfoname end as finorginfoname", "case when bankcg>0 then bankcg else finorginfo end as finorginfo"}).finish();
    }

    private DataSet dealDataSetByStatDim(DataSet threeJoinedDs, Map<String, Object> paraMap) {
        String[] needSumArr;
        String statDimField = (String)paraMap.get("stat_dimfield");
        List<String> groupList = this.buildGroupField(statDimField);
        GroupbyDataSet groupByDs = threeJoinedDs.groupBy(groupList.toArray(new String[0]));
        String needSumStr = "statamt,statredeemamt,statfutureamt,statrealamt,amount,redeemamount,futureamount,realrevenue,buycopies,copies";
        String statdim = (String)paraMap.get("filter_statdim");
        if (statdim.contains("c")) {
            needSumStr = needSumStr + ",oriamt,oriredeemamt,orifutureamt,orirealamt";
        }
        for (String s : needSumArr = needSumStr.split(",")) {
            groupByDs.sum(s);
        }
        DataSet afterDimDs = groupByDs.finish();
        afterDimDs = afterDimDs.addFields(new String[]{"amount-case when redeemamount is null then 0 else redeemamount end", statdim.contains("c") ? "oriamt- case when oriredeemamt is null then 0 else oriredeemamt end" : "0", "statamt- case when statredeemamt is null then 0 else statredeemamt end", "buycopies- case when copies is null then 0 else copies end", statDimField, "0", "0", "0"}, new String[]{"surplusamount", "orisurpamt", "statsurpamt", "surpluscopies", "rowid", "pid", "sumlevel", "secondlevel"});
        return afterDimDs;
    }

    private DataSet dealDataSetByIsInclude(DataSet afterJoinDs, Map<String, Object> paraMap) {
        boolean isInclude = (Boolean)paraMap.get("filter_isinclude");
        if (!isInclude) {
            Date endDate = ReportHelper.getCutOffDate(paraMap);
            DataSet needRemoveDs = afterJoinDs.copy().filter("finservicestatus = 'subscribe_end' and to_char(lastredeemdate,'yyyy-MM-dd') <='" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd") + "' and to_char(cleardate,'yyyy-MM-dd') <='" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd") + "'");
            ArrayList needRemoveFinsubIds = new ArrayList(16);
            needRemoveDs.forEach(r -> needRemoveFinsubIds.add(r.getLong("id") + ""));
            if (EmptyUtil.isNoEmpty(needRemoveFinsubIds)) {
                afterJoinDs = afterJoinDs.filter("id not in (" + String.join((CharSequence)",", needRemoveFinsubIds) + ")");
            }
        }
        return afterJoinDs;
    }

    private boolean isTreeDataSet(Map<String, Object> paraMap) {
        String showtype = (String)paraMap.get("filter_showttype");
        String statDim = (String)paraMap.get("filter_statdim");
        return StringUtils.equals((CharSequence)"step", (CharSequence)showtype) && StringUtils.equals((CharSequence)"o", (CharSequence)statDim);
    }

    private boolean isFinTreeDataSet(Map<String, Object> paraMap) {
        String statDim = (String)paraMap.get("filter_statdim");
        return StringUtils.equals((CharSequence)"f", (CharSequence)statDim);
    }

    private List<String> buildGroupField(String statDimField) {
        String[] splitArr = statDimField.split("\\+");
        List<String> groupList = Arrays.stream(splitArr).map(r -> r + "name").collect(Collectors.toList());
        groupList.addAll(Arrays.asList(splitArr));
        return groupList;
    }

    private DataSet getDsConverEx(DataSet joinDs, Map<String, Object> paraMap) {
        Long tarCurrencyId = (Long)((DynamicObject)paraMap.get("filter_statcurrency")).getPkValue();
        long orgRootId = Long.parseLong(String.valueOf(paraMap.get("filter_useorg")));
        ArrayList currencyIdList = new ArrayList(10);
        joinDs.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        String queryWay = (String)paraMap.get("filter_queryway");
        DataSet exchRateDS = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)tarCurrencyId, (long)orgRootId, (Date)DateUtils.getCurrentDate(), (boolean)ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay));
        exchRateDS = exchRateDS.select("rate, tarcurrency");
        String unit = DepositReportHelper.getUnit((String)paraMap.get("filter_currencyunit"));
        DataSet exchangedDs = joinDs.leftJoin(exchRateDS).on("currency", "tarcurrency").select(joinDs.getRowMeta().getFieldNames(), new String[]{"tarcurrency", "rate"}).finish();
        return exchangedDs.select(this.getPropAfterDealUnit(unit));
    }

    private String getPropAfterDealUnit(String unit) {
        return "org,orgname,finorginfo,finorginfoname,invest,investname,currency,currencyname,buycopies,copies," + String.format("oriamt/%s", unit) + " as oriamt," + String.format("orifutureamt/%s", unit) + " as orifutureamt," + String.format("oriredeemamt/%s", unit) + " as oriredeemamt," + String.format("orirealamt/%s", unit) + " as orirealamt," + String.format("oriamt*rate/%s", unit) + " as statamt," + String.format("oriamt*rate/%s", unit) + " as amount," + String.format("oriredeemamt*rate/%s", unit) + " as statredeemamt," + String.format("oriredeemamt*rate/%s", unit) + " as redeemamount," + String.format("orifutureamt*rate/%s", unit) + " as statfutureamt," + String.format("orifutureamt*rate/%s", unit) + " as futureamount," + String.format("orirealamt*rate/%s", unit) + " as statrealamt," + String.format("orirealamt*rate/%s", unit) + " as realrevenue";
    }

    private List<QFilter> buildRevenueQueryFilter(DataSet afterJoinDs, Map<String, Object> paraMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filterList.add(new QFilter("datasource", "=", (Object)"revenue"));
        Date endDate = ReportHelper.getCutOffDate(paraMap);
        filterList.add(new QFilter("expiredate", "<=", (Object)endDate));
        ArrayList finBillIds = new ArrayList(16);
        afterJoinDs.copy().forEach(r -> finBillIds.add(r.getLong("id")));
        if (EmptyUtil.isNoEmpty(finBillIds)) {
            filterList.add(new QFilter("finbillno.id", "in", finBillIds));
        }
        return filterList;
    }

    private List<QFilter> buildRedeemQueryFilter(List<QFilter> commonList, Map<String, Object> paraMap, DataSet finSubDs) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonList);
        Date endDate = ReportHelper.getCutOffDate(paraMap);
        filterList.add(new QFilter("redeemdate", "<=", (Object)endDate));
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        Iterator iterator = finSubDs.copy().iterator();
        ArrayList<Long> finBillIds = new ArrayList<Long>(16);
        while (iterator.hasNext()) {
            finBillIds.add(((Row)iterator.next()).getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(finBillIds)) {
            filterList.add(new QFilter("finbillno.id", "in", finBillIds));
        }
        return filterList;
    }

    private List<QFilter> buildFinSubQueryFilter(List<QFilter> commonList, Map<String, Object> paraMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonList);
        filterList.add(new QFilter("valuedate", "<=", (Object)ReportHelper.getCutOffDate(paraMap)));
        this.addFilter(filterList, paraMap, "investvarieties", "filter_investvarieties");
        this.addIntStartFilter(paraMap, filterList);
        filterList.add(new QFilter("currency", ">", (Object)0));
        return filterList;
    }

    private List<QFilter> buildCommonFilter(Map<String, Object> paraMap) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(8);
        qfilters.add(new QFilter("org", "in", paraMap.get("filter_org")));
        qfilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter offTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.OFFLINE.getValue());
        QFilter onlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        onlineTradeChannelFilter.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()).or(new QFilter("isrenewal", "=", (Object)Boolean.TRUE)));
        QFilter tradeChannelFilter = offTradeChannelFilter.or(onlineTradeChannelFilter);
        qfilters.add(tradeChannelFilter);
        String redeemWay = (String)paraMap.get("filter_redeemway");
        if (EmptyUtil.isNoEmpty((String)redeemWay)) {
            qfilters.add(new QFilter("redeemway", "in", (Object)redeemWay.split(",")));
        }
        this.addFilter(qfilters, paraMap, "finorginfo", "filter_finorginfo");
        String statDim = (String)paraMap.get("filter_statdim");
        if (!StringUtils.equals((CharSequence)"o", (CharSequence)statDim) && !StringUtils.equals((CharSequence)"f", (CharSequence)statDim)) {
            this.addFilter(qfilters, paraMap, "currency", "filter_currency");
        }
        return qfilters;
    }

    private void addFilter(List<QFilter> qfilters, Map<String, Object> paraMap, String field, String filterName) {
        DynamicObjectCollection dynCols = (DynamicObjectCollection)paraMap.get(filterName);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynCols)) {
            List ids = dynCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qfilters.add(new QFilter(field, "in", ids));
        }
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected boolean isNeedOrgTree() {
        return true;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgname");
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("statamt", "statredeemamt", "statsurpamt", "statfutureamt", "statrealamt", "amount", "redeemamount", "futureamount", "realrevenue", "buycopies", "copies", "surplusamount", "surpluscopies");
    }

    public String sumNameField() {
        return "orgname";
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("oriamt", "oriredeemamt", "orifutureamt", "orirealamt");
    }

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        DataSet dataSet = this.queryDataSetCommon(queryParam);
        dataSet = dataSet.removeFields(new String[]{"sumlevel"});
        return dataSet;
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    private void addIntStartFilter(Map paramMap, List<QFilter> filterList) {
        Date intEndDate;
        Date intStartDate;
        String intStart = (String)paramMap.get("filter_intstart");
        if (EmptyUtil.isEmpty((String)intStart)) {
            return;
        }
        Date currentDate = DateUtils.getCurrentDate();
        switch (intStart) {
            case "thismonth": {
                intStartDate = DateUtils.getFirstDayOfMonth((Date)currentDate);
                intEndDate = DateUtils.getFirstDateOfNextMonth((Date)currentDate);
                break;
            }
            case "thisweek": {
                intStartDate = DateUtils.getFirstDayOfWeek((Date)currentDate);
                intEndDate = DateUtils.getNextWeekMonday((Date)currentDate);
                break;
            }
            case "thisday": {
                intStartDate = currentDate;
                intEndDate = DateUtils.getNextDay((Date)currentDate, (int)1);
                break;
            }
            default: {
                intStartDate = (Date)paramMap.get("selfdefine_startdate");
                intEndDate = DateUtils.getNextDay((Date)((Date)paramMap.get("selfdefine_enddate")), (int)1);
            }
        }
        filterList.add(new QFilter("valuedate", ">=", (Object)intStartDate));
        filterList.add(new QFilter("valuedate", "<", (Object)intEndDate));
    }

    public DataSet addDetail(DataSet resultDS) {
        String lvalue = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"SumReportDataPlugin_2", (String)"tmc-cim-report", (Object[])new Object[0]);
        resultDS = resultDS.addField("case when (sumlevel = 0 or sumlevel=null) then '" + lvalue + "' else '' end as detail", "detail");
        return resultDS;
    }

    private String getUniqueRow(List<String> groupList) {
        StringBuilder uniqueRow = new StringBuilder(this.sumField);
        uniqueRow.append("+'_'");
        for (String groupField : groupList) {
            uniqueRow.append("+'_'+").append(groupField);
        }
        return uniqueRow.toString();
    }
}

