/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.tmc.cim.report.form.AbstractCimBaseReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceReportFormListPlugin
extends AbstractCimBaseReportFormPlugin {
    public void beforeQuery(ReportQueryParam queryParam) {
        queryParam.getCustomParam().put("filter_statdim", this.getModel().getValue("filter_statdim"));
        queryParam.getCustomParam().put("filter_currency", this.getModel().getValue("filter_currency"));
        queryParam.getCustomParam().put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        queryParam.getCustomParam().put("filter_islinetotal", this.getModel().getValue("filter_islinetotal"));
        queryParam.getCustomParam().put("filter_isshowdetail", this.getModel().getValue("filter_isshowdetail"));
        super.beforeQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        ReportQueryParam queryParam = event.getQueryParam();
        boolean isDetail = (Boolean)queryParam.getCustomParam().get("filter_isshowdetail");
        List columns = event.getColumns();
        for (int i = columns.size() - 1; i >= 0; --i) {
            if (!(columns.get(i) instanceof ReportColumnGroup)) continue;
            ReportColumnGroup column = (ReportColumnGroup)columns.get(i);
            String fieldKey = column.getFieldKey();
            if (!isDetail && ("finsubscribe".equals(fieldKey) || "redeem".equals(fieldKey) || "revenue".equals(fieldKey))) {
                columns.remove(i);
            }
            this.controlColumns(column, queryParam);
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"BalanceReportFormListPlugin_2", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void controlColumns(ReportColumnGroup columnGroup, ReportQueryParam queryParam) {
        String fieldKey = columnGroup.getFieldKey();
        List childrenColumns = columnGroup.getChildren();
        String statDim = (String)queryParam.getCustomParam().get("filter_statdim");
        Iterator iterator = childrenColumns.iterator();
        while (iterator.hasNext()) {
            ReportColumn column = (ReportColumn)iterator.next();
            String field = column.getFieldKey();
            if ("accountinfo".equals(fieldKey)) {
                if ("finorginfomain".equals(field)) {
                    if ("org".equals(statDim)) {
                        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u516c\u53f8", (String)"BalanceReportFormListPlugin_0", (String)"tmc-cim-report", (Object[])new Object[0])));
                        continue;
                    }
                    if ("investvarieties".equals(statDim)) {
                        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6295\u8d44\u54c1\u79cd", (String)"BalanceReportFormListPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0])));
                        continue;
                    }
                    if (!"finaccount".equals(statDim) && !"currency".equals(statDim)) continue;
                    iterator.remove();
                    continue;
                }
                if (!"finaccount".equals(field) && !"accamount".equals(field) || !"currency".equals(statDim)) continue;
                iterator.remove();
                continue;
            }
            if (!"finsubscribe".equals(fieldKey) || !statDim.equals(field)) continue;
            iterator.remove();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "filter_islinetotal": 
            case "filter_isshowdetail": 
            case "filter_statdim": 
            case "filter_currencyunit": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                if (EmptyUtil.isEmpty((Object)rptFilter)) break;
                rptFilter.search();
            }
        }
    }
}

