/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.report.helper.DepositReportHelper;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositSumRptFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
        this.batchAddBeforeF7SelectListener(Arrays.asList("filter_org", "filter_finorginfo"));
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObjectCollection finOrgDefaultValue = ReportHelper.getFinOrgDefaultValue(appId, this.getModel().getDataEntityType().getName());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgDefaultValue)) {
            this.getModel().setValue("filter_finorginfo", (Object)finOrgDefaultValue);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map customParam = queryParam.getCustomParam();
        customParam.clear();
        this.addDimFilters(customParam);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        customParam.put("appid", parameter.getAppId());
        customParam.put("formid", parameter.getFormId());
        this.addCustomFilter(queryParam);
        this.initQueryColumn();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date intEndDate;
        Date intStartDate;
        DynamicObjectCollection finOrgInfos;
        FilterInfo filter = queryParam.getFilter();
        String entityName = this.getModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ifm_deposit_sumrpt") && EmptyUtil.isEmpty((DynamicObjectCollection)(finOrgInfos = (DynamicObjectCollection)filter.getFilterItem("filter_finorginfo").getValue()))) {
            this.getView().showTipNotification(ReportHelper.loadKDString("\u5b58\u6b3e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\u3002", "DepositSumRptFormListPlugin_1", new Object[0]));
            return false;
        }
        String queryCutOffDate = (String)filter.getFilterItem("filter_querycutoffdate").getValue();
        if (EmptyUtil.isEmpty((String)queryCutOffDate)) {
            this.getView().showTipNotification(ReportHelper.loadKDString("\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", "DepositSumRptFormListPlugin_5", new Object[0]));
            return false;
        }
        Date endDate = (Date)filter.getFilterItem("filter_enddate").getValue();
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ReportHelper.loadKDString("\u81ea\u5b9a\u4e49\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", "DepositSumRptFormListPlugin_2", new Object[0]));
            return false;
        }
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ReportHelper.loadKDString("\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", "DepositSumRptFormListPlugin_3", new Object[0]));
            return false;
        }
        String intStart = (String)this.getModel().getValue("filter_intstart");
        if ("custom".equals(intStart) && EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intStartDate = (Date)this.getModel().getValue("selfdefine_startdate"), intEndDate = (Date)this.getModel().getValue("selfdefine_enddate")})) {
            this.getView().showTipNotification(ReportHelper.loadKDString("\u5f53\u5b58\u6b3e\u8d77\u606f\u65e5\u4e3a\u81ea\u5b9a\u4e49\u65f6\uff0c\u81ea\u5b9a\u4e49\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", "DepositSumRptFormListPlugin_4", new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        List qfilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        List<Long> authOrgIds = this.getAuthOrgIds();
        String entityName = this.getModel().getDataEntityType().getName();
        switch (propName) {
            case "filter_finorginfo": {
                if (!entityName.startsWith("ifm")) break;
                qfilters.add(new QFilter("org", "in", authOrgIds));
                List<Object> finOrgTypeIds = this.getFinOrgIds();
                qfilters.add(new QFilter("finorgtype", "in", finOrgTypeIds));
                break;
            }
        }
    }

    private List<Object> getFinOrgIds() {
        QFilter finOrgFilter = new QFilter("type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorgtype", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        return finOrgTypeIds;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"detail")) {
            ReportList reportList = (ReportList)event.getSource();
            ReportShowParameter param = new ReportShowParameter();
            String entityName = this.getModel().getDataEntityType().getName();
            String formId = entityName.startsWith("ifm") ? "ifm_deposit_dtlrpt" : "cim_deposit_dtlrpt";
            param.setFormId(formId);
            param.setCustomParams(this.getHyperLinkParam(this.getHyperLinkData(reportList, event.getRowIndex())));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        if (!"custom".equals(queryCutOffDate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_enddate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_enddate"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (fieldName) {
            case "filter_statdim": 
            case "filter_islinetotal": 
            case "filter_level": {
                this.autoSearch();
                break;
            }
            case "filter_querycutoffdate": {
                if (!"custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_enddate"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_enddate"});
                break;
            }
        }
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private void batchAddBeforeF7SelectListener(List<String> props) {
        for (String prop : props) {
            BasedataEdit control = (BasedataEdit)this.getControl(prop);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void addDimFilters(Map<String, Object> customParam) {
        IDataModel model = this.getModel();
        customParam.put("filter_statdim", this.buildStatDimArr());
        String statDimStr = (String)this.getModel().getValue("filter_statdim");
        customParam.put("order_fields", statDimStr.split(","));
        customParam.put("filter_statdimstr", statDimStr);
        DynamicObject statCurrency = (DynamicObject)model.getValue("filter_statcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)statCurrency)) {
            customParam.put("filter_statcurrency", statCurrency);
        }
        customParam.put("filter_currencyunit", model.getValue("filter_currencyunit"));
        customParam.put("filter_level", model.getValue("filter_level"));
        customParam.put("filter_islinetotal", model.getValue("filter_islinetotal"));
    }

    private void addCustomFilter(ReportQueryParam queryParam) {
        Map customParam = queryParam.getCustomParam();
        int size = queryParam.getFilter().getFilterItems().size();
        if (size <= 0) {
            return;
        }
        for (FilterItemInfo filterItem : queryParam.getFilter().getFilterItems()) {
            Object filterValue = filterItem.getValue();
            if (EmptyUtil.isEmpty((Object)filterValue)) continue;
            String propName = filterItem.getPropName();
            if (StringUtils.equalsAny((String)propName, (String[])new String[]{"filter_org", "filter_orgview"})) {
                this.addOrgFilter(filterValue, propName, customParam);
                continue;
            }
            if (StringUtils.equalsAny((String)propName, (String[])new String[]{"filter_currency", "filter_finorginfo", "filter_investvarieties"})) {
                this.addMutiPropFilter(filterValue, propName, customParam);
                continue;
            }
            if (StringUtils.equals((CharSequence)propName, (CharSequence)"filter_product")) {
                this.addProductFilter(filterValue, customParam);
                continue;
            }
            customParam.put(propName, filterValue);
        }
        this.addExRateOrgParam(customParam);
    }

    private void addExRateOrgParam(Map<String, Object> customParam) {
        Long exRateOrgId;
        String orgQueryWay = (String)this.getModel().getValue("filter_queryway");
        if (StringUtils.equals((CharSequence)orgQueryWay, (CharSequence)"org")) {
            exRateOrgId = RequestContext.get().getOrgId();
        } else {
            DynamicObject companyView = (DynamicObject)this.getModel().getValue("filter_orgview");
            String orgRootId = DepositReportHelper.getOrgRootId(companyView.getString("number"));
            exRateOrgId = Long.valueOf(orgRootId);
        }
        customParam.put("exRateOrgId", exRateOrgId);
    }

    private void addMutiPropFilter(Object filterValue, String fieldName, Map<String, Object> customParam) {
        DynamicObjectCollection baseDatas = (DynamicObjectCollection)filterValue;
        List baseDataIds = baseDatas.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        customParam.put(fieldName, baseDataIds);
    }

    private void addProductFilter(Object filterValue, Map<String, Object> customParam) {
        DynamicObjectCollection products = (DynamicObjectCollection)filterValue;
        List numbers = products.stream().map(v -> v.getString("number")).collect(Collectors.toList());
        Map investMap = TmcDataServiceHelper.loadFromCache((String)"cim_investvarieties", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        if (EmptyUtil.isNoEmpty((Object)investMap)) {
            List investIds = investMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
            customParam.put("filter_investvarieties", investIds);
        }
    }

    private void addOrgFilter(Object filterValue, String fieldName, Map<String, Object> customParam) {
        List orgIds = new ArrayList(16);
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"filter_org")) {
            orgIds = (List)filterValue;
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"filter_orgview")) {
            DynamicObject companyView = (DynamicObject)this.getModel().getValue("filter_orgview");
            Long companyViewId = companyView.getLong("id");
            orgIds.addAll(TmcOrgDataHelper.getOrgIds((Long)companyViewId));
            customParam.put("filter_orgview", companyView);
        }
        customParam.put("filter_org", orgIds);
    }

    private String[] buildStatDimArr() {
        String statDimStr = (String)this.getModel().getValue("filter_statdim");
        ArrayList<String> statDims = new ArrayList<String>(8);
        for (String statDim : statDimStr.split(",")) {
            statDims.add(statDim);
            statDims.add(String.format("%sname", statDim));
        }
        if (StringUtils.equals((CharSequence)statDimStr, (CharSequence)"finorginfo")) {
            statDims.add("finorgtype");
        }
        return statDims.toArray(new String[0]);
    }

    private Map<String, Object> getHyperLinkParam(List<DynamicObject> curRowDatas) {
        HashMap<String, Object> hyperLinkParam = new HashMap<String, Object>(16);
        hyperLinkParam.put("skipfromsumrpt", "true");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        ArrayList<Object> finOrgInfos = new ArrayList<Object>();
        ArrayList<Object> investVarieties = new ArrayList<Object>();
        ArrayList<Object> currencyIds = new ArrayList<Object>();
        ArrayList<Object> productIds = new ArrayList<Object>();
        for (DynamicObject curRowData : curRowDatas) {
            this.addOrgIds(orgIds, curRowData);
            this.addFinOrgIds(finOrgInfos, curRowData);
            this.addInvestIds(investVarieties, curRowData);
            this.addCurrencyIds(currencyIds, curRowData);
            this.addProductIds(productIds);
        }
        if (EmptyUtil.isEmpty(orgIds)) {
            orgIds.addAll(this.getAuthOrgIds());
        }
        hyperLinkParam.put("filter_org", orgIds);
        hyperLinkParam.put("filter_finorginfo", finOrgInfos);
        hyperLinkParam.put("filter_investvarieties", investVarieties);
        hyperLinkParam.put("filter_currency", currencyIds);
        hyperLinkParam.put("filter_product", productIds);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        hyperLinkParam.put("filter_querycutoffdate", queryCutOffDate);
        Date endDate = (Date)this.getModel().getValue("filter_enddate");
        hyperLinkParam.put("filter_enddate", endDate);
        boolean isInclude = (Boolean)this.getModel().getValue("filter_isinclude");
        hyperLinkParam.put("filter_isinclude", isInclude);
        hyperLinkParam.put("filter_intstart", this.getModel().getValue("filter_intstart"));
        hyperLinkParam.put("selfdefine_startdate", this.getModel().getValue("selfdefine_startdate"));
        hyperLinkParam.put("selfdefine_enddate", this.getModel().getValue("selfdefine_enddate"));
        return hyperLinkParam;
    }

    private void addOrgIds(List<Object> orgIds, DynamicObject curRowData) {
        long orgId = curRowData.getLong("org");
        if (EmptyUtil.isNoEmpty((Long)orgId)) {
            orgIds.add(orgId);
        } else if (orgIds.isEmpty()) {
            String orgWay = (String)this.getModel().getValue("filter_queryway");
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (StringUtils.equals((CharSequence)orgWay, (CharSequence)"org")) {
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                    orgIds.addAll(orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
                }
            } else {
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
                if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                    orgIds.addAll(TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id")));
                }
            }
        }
    }

    private void addFinOrgIds(List<Object> finOrgIds, DynamicObject curRowData) {
        IDataModel model = this.getModel();
        DynamicObjectCollection finOrgInfoCol = (DynamicObjectCollection)model.getValue("filter_finorginfo");
        List finOrgIdList = finOrgInfoCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        long finOrgInfo = curRowData.getLong("finorginfo");
        if (EmptyUtil.isNoEmpty((Long)finOrgInfo)) {
            String level = (String)model.getValue("filter_level");
            String finorgType = curRowData.getString("finorgtype");
            if (StringUtils.equals((CharSequence)level, (CharSequence)"1") && StringUtils.equals((CharSequence)finorgType, (CharSequence)"0")) {
                QFilter qfilter = new QFilter("finorginfo.bank_cate", "=", (Object)finOrgInfo);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"addFinOrgIds.query", (String)"ifm_deposit", (String)"finorginfo", (QFilter[])new QFilter[]{qfilter}, null);
                for (Row row : dataSet) {
                    Object id = row.get("finorginfo");
                    if (!EmptyUtil.isEmpty(finOrgIdList) && (!EmptyUtil.isNoEmpty(finOrgIdList) || !finOrgIdList.contains(id))) continue;
                    finOrgIds.add(id);
                }
                dataSet.close();
            } else {
                finOrgIds.add(finOrgInfo);
            }
        } else if (finOrgIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgInfoCol)) {
            finOrgIds.addAll(finOrgIdList);
        }
    }

    private void addInvestIds(List<Object> InvestIds, DynamicObject curRowData) {
        DynamicObjectCollection investCol;
        long investId = curRowData.getLong("investvarieties");
        if (EmptyUtil.isNoEmpty((Long)investId)) {
            InvestIds.add(investId);
        } else if (InvestIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(investCol = (DynamicObjectCollection)this.getModel().getValue("filter_investvarieties")))) {
            InvestIds.addAll(investCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private void addProductIds(List<Object> productIds) {
        DynamicObjectCollection productCol;
        if (this.getModel().getDataEntityType().getName().startsWith("ifm") && EmptyUtil.isNoEmpty((DynamicObjectCollection)(productCol = (DynamicObjectCollection)this.getModel().getValue("filter_product")))) {
            productIds.addAll(productCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private void addCurrencyIds(List<Object> currencyIds, DynamicObject curRowData) {
        DynamicObjectCollection currencyCol;
        DynamicObject currency = curRowData.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            currencyIds.add(currency.getPkValue());
        } else if (currencyIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyCol = (DynamicObjectCollection)this.getModel().getValue("filter_currency")))) {
            currencyIds.addAll(currencyCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private void initQueryColumn() {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        this.reOrderColumn(columns);
    }

    private void reOrderColumn(List<AbstractReportColumn> columns) {
        String statDim = (String)this.getModel().getValue("filter_statdim");
        String[] fields = statDim.split(",");
        ArrayList<AbstractReportColumn> reBuildColumns = new ArrayList<AbstractReportColumn>(16);
        ArrayList<String> addedFields = new ArrayList<String>(16);
        block0: for (String field : fields) {
            for (AbstractReportColumn column : columns) {
                if (!((ReportColumn)column).getFieldKey().equals(field + "name")) continue;
                reBuildColumns.add(column);
                addedFields.add(field + "name");
                continue block0;
            }
        }
        List<String> hideCols = this.getHideCols(statDim);
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            boolean isContain = false;
            if (column instanceof ReportColumn) {
                col = (ReportColumn)column;
                if (!col.isHide()) {
                    col.setHide(hideCols.contains(col.getFieldKey()));
                }
                isContain = addedFields.contains(col.getFieldKey());
            } else if (column instanceof ReportColumnGroup) {
                col = (ReportColumnGroup)column;
                isContain = addedFields.contains(col.getFieldKey());
            }
            if (isContain) continue;
            reBuildColumns.add(column);
        }
        if (reBuildColumns.size() > 0) {
            columns.clear();
            columns.addAll(reBuildColumns);
        }
    }

    private List<String> getHideCols(String statDim) {
        ArrayList<String> hideCol = new ArrayList<String>();
        switch (statDim) {
            case "org,finorginfo,currency": 
            case "finorginfo,org,currency": {
                hideCol.add("investvarietiesname");
                break;
            }
            case "finorginfo,currency": {
                hideCol.add("orgname");
                hideCol.add("investvarietiesname");
                break;
            }
            case "investvarieties,currency": {
                hideCol.add("orgname");
                hideCol.add("finorginfoname");
                break;
            }
            case "org,currency": {
                hideCol.add("finorginfoname");
                hideCol.add("investvarietiesname");
                break;
            }
            case "org": {
                hideCol.add("investvarietiesname");
                hideCol.add("finorginfoname");
                hideCol.add("currencyname");
                break;
            }
            case "currency": {
                hideCol.add("investvarietiesname");
                hideCol.add("finorginfoname");
                hideCol.add("orgname");
                break;
            }
            case "finorginfo": {
                hideCol.add("investvarietiesname");
                hideCol.add("currencyname");
                hideCol.add("orgname");
            }
        }
        return hideCol;
    }

    private List<DynamicObject> getHyperLinkData(ReportList reportList, int rowIndex) {
        ArrayList<DynamicObject> hyperLinkData = new ArrayList<DynamicObject>(16);
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject firstData = reportModel.getRowData(rowIndex);
        ArrayList<Object> rowIds = new ArrayList<Object>(16);
        rowIds.add(firstData.get("rowid"));
        if (!firstData.getBoolean("isgroupnode")) {
            hyperLinkData.add(firstData);
            return hyperLinkData;
        }
        int totalRecords = reportList.getTotalRecords();
        for (int i = rowIndex + 1; i <= totalRecords; ++i) {
            DynamicObject data = reportModel.getRowData(i);
            Object pId = data.get("pid");
            boolean isGroupNode = data.getBoolean("isgroupnode");
            if (!data.getString("sumlevel").equals("0") || isGroupNode && !rowIds.contains(pId)) break;
            if (!isGroupNode) {
                hyperLinkData.add(data);
                continue;
            }
            rowIds.add(data.get("rowid"));
        }
        return hyperLinkData;
    }

    private List<Long> getAuthOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        return orgIds;
    }
}

