/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevEstimateReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        this.initQueryColumn(statdim);
        super.beforeQuery(queryParam);
    }

    private void initQueryColumn(String statdim) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        this.reOrderColumn(statdim, columns);
    }

    private void reOrderColumn(String statdim, List<AbstractReportColumn> columns) {
        ReportColumn statColumn = null;
        String statColumKey = "orgname";
        switch (statdim) {
            case "finorginfo": {
                statColumKey = "finorginfoname";
                break;
            }
            case "org": {
                statColumKey = "orgname";
                break;
            }
            case "investvarieties": {
                statColumKey = "investvarietyname";
                break;
            }
            case "currency": {
                statColumKey = "currencyname";
                break;
            }
            case "busitype": {
                statColumKey = "busitype";
                break;
            }
        }
        ArrayList<Object> rebuildColumns = new ArrayList<Object>();
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().equals(statColumKey)) continue;
            statColumn = reportColumn;
        }
        rebuildColumns.add(statColumn);
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_15", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        FilterInfo filter = queryParam.getFilter();
        Date filterEndDate = filter.getDate("filter_revenddate");
        Date filterstartDate = (Date)this.getModel().getValue("filter_revstartdate");
        if (EmptyUtil.isNoEmpty((Object)filterstartDate) && EmptyUtil.isNoEmpty((Object)filterEndDate) && !filterEndDate.after(filterstartDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u5f00\u59cb\u65e5\u671f\u3002", (String)"RevEstimateReportFormPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_revenddate", null);
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filterEndDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevEstimateReportFormPlugin_2", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                if (EmptyUtil.isEmpty((Object)rptFilter)) break;
                rptFilter.search();
                break;
            }
            case "filter_revstartdate": 
            case "filter_revenddate": {
                Date startDate = (Date)this.getModel().getValue("filter_revstartdate");
                Date endDate = (Date)this.getModel().getValue("filter_revenddate");
                if (!EmptyUtil.isNoEmpty((Object)startDate) || !EmptyUtil.isNoEmpty((Object)endDate) || endDate.after(startDate)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u5f00\u59cb\u65e5\u671f\u3002", (String)"RevEstimateReportFormPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, null);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        int rowIndex = evt.getRowIndex();
        switch (fieldName = evt.getFieldName()) {
            case "oriestimateint": {
                this.showRevenueDetail(reportModel, rowIndex);
                break;
            }
            case "billno": {
                this.showBill(reportModel, rowIndex);
                break;
            }
        }
    }

    private void showRevenueDetail(IReportListModel reportModel, int rowIndex) {
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        IntBillInfo intBillInfo = this.calcSelectRowRevenue(rowData);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("formId", "cim_revestcaldetailcard");
        param.put("RevEstimateReport", SerializationUtils.toJsonString((Object)intBillInfo));
        param.put("currency", rowData.getDynamicObject("oricurrency").getPkValue());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private IntBillInfo calcSelectRowRevenue(DynamicObject rowData) {
        IntBillInfo intBillInfo;
        String busiType;
        Long pkId = rowData.getLong("id");
        Date revstartdate = rowData.getDate("revstartdate");
        Date revenddate = rowData.getDate("revenddate");
        switch (busiType = rowData.getString("busitype")) {
            case "finance": {
                intBillInfo = RevenueCalcHelper.callIntForReport((Long)pkId, (Date)revstartdate, (Date)revenddate);
                break;
            }
            default: {
                intBillInfo = DepositHelper.calcDepositBillIntForReport((Long)pkId, (Date)revstartdate, (Date)revenddate);
            }
        }
        return intBillInfo;
    }

    private void showBill(IReportListModel reportModel, int rowIndex) {
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(this.getShowFormId(rowData.getString("busitype")));
        parameter.setPkId((Object)rowData.getLong("id"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getShowFormId(String busitype) {
        String formId;
        switch (busitype) {
            case "notice": {
                formId = "cim_noticedeposit";
                break;
            }
            case "finance": {
                formId = "cim_finsubscribe";
                break;
            }
            default: {
                formId = "cim_deposit";
            }
        }
        return formId;
    }
}

