/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.helper;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BalanceReportHelper {
    public static QFilter initBalanceQfilter(Map<String, Object> param, List<Long> orgIds) {
        QFilter filter = ReportHelper.initReportFilter(param, orgIds);
        Object redeemWay = param.get("filter_redeemway");
        if (EmptyUtil.isNoEmpty((Object)redeemWay)) {
            filter.and(new QFilter("redeemway", "=", redeemWay));
        }
        return filter;
    }

    public static DataSet groupByAndSum(DataSet dataSet, String[] groupFields, String[] sumFields, String[] avgFields) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(groupFields);
        for (String field : sumFields) {
            groupbyDataSet.sum(field);
        }
        for (String avgField : avgFields) {
            groupbyDataSet.avg(avgField);
        }
        return groupbyDataSet.finish();
    }

    public static String[] getStatDim(ReportQueryParam param) {
        String statDim = (String)param.getCustomParam().get("filter_statdim");
        String[] statDimArr = null;
        switch (statDim) {
            case "finorginfo": {
                statDimArr = new String[]{"finorginfomain", "finaccount", "finaccountid", "acccurrency", "acccurrencyname"};
                break;
            }
            case "org": {
                statDimArr = new String[]{"finorginfomain", "finaccount", "finaccountid", "acccurrency", "acccurrencyname"};
                break;
            }
            case "investvarieties": {
                statDimArr = new String[]{"finorginfomain", "finaccount", "finaccountid", "acccurrency", "acccurrencyname"};
                break;
            }
            case "finaccount": {
                statDimArr = new String[]{"finaccount", "finaccountid", "acccurrency", "acccurrencyname"};
                break;
            }
            case "currency": {
                statDimArr = new String[]{"acccurrency", "acccurrencyname"};
            }
        }
        return statDimArr;
    }

    public static Pair<String[], String> getAllTotalByStatDim(ReportQueryParam param) {
        String statDim = (String)param.getCustomParam().get("filter_statdim");
        Pair pairs = null;
        switch (statDim) {
            case "finorginfo": 
            case "org": 
            case "investvarieties": {
                pairs = Pair.of((Object)new String[]{"finorginfomain"}, (Object)"finaccount");
                break;
            }
            case "finaccount": {
                pairs = Pair.of((Object)new String[]{"finaccount"}, (Object)"acccurrencyname");
                break;
            }
            case "currency": {
                pairs = Pair.of((Object)new String[]{"acccurrency"}, (Object)"acccurrencyname");
            }
        }
        return pairs;
    }

    public static Pair<String, String> getSelectFieldAndOrder(ReportQueryParam param) {
        String statDim = (String)param.getCustomParam().get("filter_statdim");
        Pair pairs = null;
        switch (statDim) {
            case "finorginfo": {
                pairs = Pair.of((Object)"case when finorginfo.bank_cate.name is null then finorginfo.name else finorginfo.bank_cate.name end as finorginfomain,finorginfo.bank_cate,", (Object)"finorginfo.bank_cate,finaccount");
                break;
            }
            case "org": {
                pairs = Pair.of((Object)"org.name as finorginfomain,org,", (Object)"org,finaccount");
                break;
            }
            case "investvarieties": {
                pairs = Pair.of((Object)"investvarieties.name as finorginfomain,finservicestatus,", (Object)"finservicestatus,finaccount");
                break;
            }
            case "finaccount": {
                pairs = Pair.of((Object)"", (Object)"finaccount");
                break;
            }
            case "currency": {
                pairs = Pair.of((Object)"", (Object)"currency");
            }
        }
        return pairs;
    }

    public static BigDecimal getBankAccoutBalance(Object bankAcctId, Object currencyId) {
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)bankAcctId, (String)"bd_accountbanks", (String)"id,issetbankinterface,company");
        if (bankAcct == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal balance = null;
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        if (isOpenBei) {
            balance = BalanceReportHelper.getBeiBankBalance(bankAcct, currencyId);
        } else {
            try {
                balance = BalanceReportHelper.getBankBalance(bankAcct, currencyId);
            }
            catch (KDBizException e) {
                return BigDecimal.ZERO;
            }
        }
        balance = balance == null ? BigDecimal.ZERO : balance;
        return balance;
    }

    private static BigDecimal getBeiBankBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = BankServiceHelper.getCurBalance((Long)((Long)bankAcct.getPkValue()), (Long)((Long)currencyId));
        balance = balance == null ? new BigDecimal(0) : balance;
        return balance;
    }

    private static BigDecimal getBankBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = CasBusinessHelper.getBalance((long)((Long)bankAcct.get("company.id")), (long)((Long)bankAcct.getPkValue()), (long)((Long)currencyId));
        balance = balance == null ? new BigDecimal(0) : balance;
        return balance;
    }

    public static Pair<Date, Date> getDateSearchRanges(String rangeId, Map<String, Object> paramMap) {
        Timestamp currentTime = DateUtils.getCurrentTime();
        Pair dateRange = null;
        String rangeVal = (String)paramMap.get(rangeId);
        if (EmptyUtil.isNoEmpty((String)rangeVal)) {
            switch (rangeVal) {
                case "thismonth": {
                    dateRange = Pair.of((Object)DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate()), (Object)DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate()));
                    break;
                }
                case "threemonth": {
                    dateRange = Pair.of((Object)DateUtils.getLastMonth((Date)currentTime, (int)3), (Object)currentTime);
                    break;
                }
                case "sixmonth": {
                    dateRange = Pair.of((Object)DateUtils.getLastMonth((Date)currentTime, (int)6), (Object)currentTime);
                    break;
                }
                case "oneyear": {
                    dateRange = Pair.of((Object)DateUtils.getLastYear((Date)currentTime, (int)1), (Object)currentTime);
                    break;
                }
                case "custom": {
                    dateRange = Pair.of((Object)((Date)paramMap.get(rangeId + "_startdate")), (Object)((Date)paramMap.get(rangeId + "_enddate")));
                    break;
                }
            }
        }
        return dateRange;
    }
}

