/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.helper;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportHelper {
    public static QFilter initReportFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        Object redeemWay;
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("org", "in", orgIds);
        DynamicObject investVarieties = (DynamicObject)paramMap.get("filter_investvarieties");
        ReportHelper.buildDynamicObjectSearch(filter, investVarieties, "investvarieties");
        DynamicObject finOrgInfo = (DynamicObject)paramMap.get("filter_finorginfo");
        ReportHelper.buildDynamicObjectSearch(filter, finOrgInfo, "finorginfo");
        String finAccount = (String)paramMap.get("filter_finaccount");
        if (EmptyUtil.isNoEmpty((String)finAccount)) {
            filter.and("finaccount", "=", (Object)finAccount);
        }
        if (EmptyUtil.isNoEmpty((Object)(redeemWay = paramMap.get("filter_redeemway")))) {
            filter.and(new QFilter("redeemway", "=", redeemWay));
        }
        String purRanges = (String)paramMap.get("fpurranges");
        ReportHelper.buildDateSearchRanges(filter, "fpurranges", purRanges, "purchasedate", paramMap);
        String expireRanges = (String)paramMap.get("fexpireranges");
        ReportHelper.buildDateSearchRanges(filter, "fexpireranges", expireRanges, "expiredate", paramMap);
        if (paramMap.containsKey("filter_currency")) {
            DynamicObject currency = (DynamicObject)paramMap.get("filter_currency");
            ReportHelper.buildDynamicObjectSearch(filter, currency, "currency");
        }
        return filter;
    }

    public static QFilter initMultiReportFilter(Map<String, Object> paramMap, List<Long> queryOrgIds) {
        Object redeemWay;
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("org", "in", queryOrgIds);
        DynamicObjectCollection investVarieties = (DynamicObjectCollection)paramMap.get("filter_linvestvarieties");
        ReportHelper.buildDynamicObjectSearch(filter, investVarieties, "investvarieties");
        DynamicObjectCollection finOrgInfo = (DynamicObjectCollection)paramMap.get("filter_lfinorginfo");
        ReportHelper.buildDynamicObjectSearch(filter, finOrgInfo, "finorginfo");
        String finAccount = (String)paramMap.get("filter_finaccount");
        if (EmptyUtil.isNoEmpty((String)finAccount)) {
            filter.and("finaccount", "=", (Object)finAccount);
        }
        if (EmptyUtil.isNoEmpty((Object)(redeemWay = paramMap.get("filter_redeemway")))) {
            filter.and(new QFilter("redeemway", "=", redeemWay));
        }
        String purRanges = (String)paramMap.get("fpurranges");
        ReportHelper.buildDateSearchRanges(filter, "fpurranges", purRanges, "purchasedate", paramMap);
        String expireRanges = (String)paramMap.get("fexpireranges");
        ReportHelper.buildDateSearchRanges(filter, "fexpireranges", expireRanges, "expiredate", paramMap);
        if (paramMap.containsKey("filter_lcurrency")) {
            DynamicObjectCollection currency = (DynamicObjectCollection)paramMap.get("filter_lcurrency");
            ReportHelper.buildDynamicObjectSearch(filter, currency, "currency");
        }
        filter.and("currency", ">", (Object)0);
        return filter;
    }

    private static void buildDynamicObjectSearch(QFilter filter, DynamicObject baseData, String filed) {
        if (EmptyUtil.isNoEmpty((DynamicObject)baseData)) {
            filter.and(filed, "=", baseData.getPkValue());
        }
    }

    public static void buildDateSearchRanges(QFilter filter, String rangeId, String rangeVal, String dateField, Map<String, Object> paramMap) {
        Timestamp currentTime = DateUtils.getCurrentTime();
        if (EmptyUtil.isNoEmpty((String)rangeVal)) {
            switch (rangeVal) {
                case "thismonth": {
                    filter.and(dateField, ">=", (Object)DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate()));
                    filter.and(dateField, "<=", (Object)DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate()));
                    break;
                }
                case "threemonth": {
                    filter.and(dateField, ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)3));
                    filter.and(dateField, "<=", (Object)currentTime);
                    break;
                }
                case "sixmonth": {
                    filter.and(dateField, ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)6));
                    filter.and(dateField, "<=", (Object)currentTime);
                    break;
                }
                case "oneyear": {
                    filter.and(dateField, ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)1));
                    filter.and(dateField, "<=", (Object)currentTime);
                    break;
                }
                case "custom": {
                    Date startDate = (Date)paramMap.get(rangeId + "_startdate");
                    Date endDate = (Date)paramMap.get(rangeId + "_enddate");
                    filter.and(dateField, ">=", (Object)startDate);
                    filter.and(dateField, "<=", (Object)endDate);
                    break;
                }
            }
        }
    }

    public static DataSet createEmptyDS() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    public static boolean isEmpty(DataSet dataSet) {
        return null == dataSet || dataSet.isEmpty();
    }

    public static DynamicObjectCollection getFinOrgDefaultValue(String appId, String entityName) {
        if (StringUtils.equals((CharSequence)"ifm", (CharSequence)appId)) {
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObjectCollection finOrgCols = new DynamicObjectCollection();
            long orgId = RequestContext.get().getOrgId();
            QFilter finOrgFilter = new QFilter("org", "=", (Object)orgId);
            List<Object> finOrgTypeIds = ReportHelper.getFinOrgIds();
            QFilter finTypeFilter = new QFilter("finorgtype", "in", finOrgTypeIds);
            DynamicObject finOrgDyn = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{finOrgFilter, finTypeFilter});
            if (EmptyUtil.isNoEmpty((DynamicObject)finOrgDyn)) {
                finOrgCols.add((Object)finOrgDyn);
            } else {
                List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
                QFilter allOrgFilter = new QFilter("org", "in", (Object)orgIds);
                List finOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{allOrgFilter, finTypeFilter}, (String)"createtime", (int)1);
                if (EmptyUtil.isNoEmpty((Object)finOrgIds)) {
                    finOrgDyn = TmcDataServiceHelper.loadSingle(finOrgIds.get(0), (String)"bd_finorginfo");
                    finOrgCols.add((Object)finOrgDyn);
                }
            }
            return finOrgCols;
        }
        return null;
    }

    public static List<Object> getFinOrgIds() {
        QFilter finOrgFilter = new QFilter("type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorgtype", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        return finOrgTypeIds;
    }

    public static String loadKDString(String description, String resourceID, Object ... args) {
        return ResManager.loadKDString((String)description, (String)resourceID, (String)"tmc-cim-report", (Object[])new Object[0]);
    }

    private static void buildDynamicObjectSearch(QFilter filter, DynamicObjectCollection baseData, String filed) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)baseData)) {
            List pkIds = baseData.stream().map(b -> b.getPkValue()).collect(Collectors.toList());
            filter.and(filed, "in", pkIds);
        }
    }

    public static Date getCutOffDate(Map<String, Object> paramMap) {
        String cutOffDateRange = (String)paramMap.get("filter_querycutoffdate");
        Date currentDate = DateUtils.getCurrentDate();
        Date cutOffDate = null;
        switch (cutOffDateRange) {
            case "thisday": {
                cutOffDate = currentDate;
                break;
            }
            case "lastday": {
                cutOffDate = DateUtils.getLastDay((Date)currentDate, (int)1);
                break;
            }
            case "lastweek": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfWeek((Date)currentDate), (int)1);
                break;
            }
            case "lastmonth": {
                cutOffDate = DateUtils.getLastDateOfAnyMonth((Date)currentDate, (int)-1);
                break;
            }
            case "lastyear": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfCurYear(), (int)1);
                break;
            }
            case "custom": {
                cutOffDate = (Date)paramMap.get("filter_enddate");
                break;
            }
        }
        return cutOffDate;
    }
}

